/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.util;

import android.content.Context;
import android.content.res.Resources;
import cn.bmob.v3.util.BLog;

public class BmobResource {
    private static BmobResource sBmobResource = null;
    private Resources mResources;
    private final String mPackageName;

    private BmobResource(Context paramContext) {
        this.mResources = paramContext.getResources();
        this.mPackageName = paramContext.getPackageName();
    }

    public static synchronized BmobResource getInstance(Context paramContext) {
        if (sBmobResource == null) {
            sBmobResource = new BmobResource(paramContext.getApplicationContext());
        }
        return sBmobResource;
    }

    public int getAnim(String name) {
        return this.getRes(name, "anim");
    }

    public int getId(String name) {
        return this.getRes(name, "id");
    }

    public int getDrawable(String name) {
        return this.getRes(name, "drawable");
    }

    public int getLayout(String name) {
        return this.getRes(name, "layout");
    }

    public int getStyle(String name) {
        return this.getRes(name, "style");
    }

    public int getString(String name) {
        return this.getRes(name, "string");
    }

    public int getArray(String name) {
        return this.getRes(name, "array");
    }

    private int getRes(String name, String defType) {
        int identifier = this.mResources.getIdentifier(name, defType, this.mPackageName);
        if (identifier == 0) {
            BLog.i("getRes(" + defType + "/ " + name + ")");
            BLog.e("Error getting resource. Make sure you have copied all resources (res/) from SDK to your project. ");
            return 0;
        }
        return identifier;
    }
}

