/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.util;

import android.text.TextUtils;
import cn.bmob.v3.Bmob;
import cn.bmob.v3.encry.digest.DigestUtils;
import cn.bmob.v3.util.BmobContentProvider;
import cn.bmob.v3.util.IOUtils;
import cn.bmob.v3.util.ZipUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.json.JSONTokener;

public class CacheHelper {
    static int maxKeyValueCacheBytes = 0x200000;
    static int maxKeyValueCacheFiles = 1000;

    public static String getCacheKey(JSONObject params) {
        String json;
        try {
            if (params.has("timestamp")) {
                params.remove("timestamp");
            }
            if (params.has("sessionToken")) {
                params.remove("sessionToken");
            }
            params.remove("client");
            params.remove("v");
            params.remove("appSign");
            json = CacheHelper.toDeterministicString(params);
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
        String sessionToken = BmobContentProvider.getSessionToken();
        if (!TextUtils.isEmpty((CharSequence)sessionToken)) {
            json = json + sessionToken;
        }
        String key = "RequestCommand.find.3." + DigestUtils.md5Hex(json);
        return key;
    }

    static String toDeterministicString(Object o) throws JSONException {
        JSONStringer stringer = new JSONStringer();
        CacheHelper.addToStringer(stringer, o);
        return stringer.toString();
    }

    static void addToStringer(JSONStringer stringer, Object o) throws JSONException {
        if (o instanceof JSONObject) {
            stringer.object();
            JSONObject object = (JSONObject)o;
            Iterator keyIterator = object.keys();
            ArrayList<String> keys = new ArrayList<String>();
            while (keyIterator.hasNext()) {
                keys.add((String)keyIterator.next());
            }
            Collections.sort(keys);
            for (String key : keys) {
                stringer.key(key);
                CacheHelper.addToStringer(stringer, object.opt(key));
            }
            stringer.endObject();
            return;
        }
        if (o instanceof JSONArray) {
            JSONArray array = (JSONArray)o;
            stringer.array();
            for (int i = 0; i < array.length(); ++i) {
                CacheHelper.addToStringer(stringer, array.get(i));
            }
            stringer.endArray();
            return;
        }
        stringer.value(o);
    }

    public static void saveToKeyValueCache(String key, String value) {
        File prior = CacheHelper.getKeyValueCacheFile(key);
        if (prior != null) {
            prior.delete();
        }
        File f = CacheHelper.createKeyValueCacheFile(key);
        try {
            FileOutputStream out = new FileOutputStream(f);
            out.write(value.getBytes("UTF-8"));
            out.close();
        }
        catch (UnsupportedEncodingException out) {
        }
        catch (IOException out) {
            // empty catch block
        }
        File[] files = CacheHelper.getKeyValueCacheDir().listFiles();
        int numFiles = files.length;
        int numBytes = 0;
        for (File file : files) {
            numBytes = (int)((long)numBytes + file.length());
        }
        if (numFiles > maxKeyValueCacheFiles || numBytes > maxKeyValueCacheBytes) {
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File lhs, File rhs) {
                    Long lhsLong = lhs.lastModified();
                    Long rhsLong = rhs.lastModified();
                    if (lhsLong < rhsLong) {
                        return -1;
                    }
                    if (lhsLong > rhsLong) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (File file : files) {
                numBytes = (int)((long)numBytes - file.length());
                file.delete();
                if (--numFiles <= maxKeyValueCacheFiles && numBytes <= maxKeyValueCacheBytes) break;
            }
        }
    }

    static File getKeyValueCacheFile(String key) {
        final String suffix = '.' + key;
        File[] matches = CacheHelper.getKeyValueCacheDir().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(suffix);
            }
        });
        return matches.length == 0 ? null : matches[0];
    }

    static synchronized File getKeyValueCacheDir() {
        File parseCacheDir = Bmob.getCacheDir("BmobKeyValueCache");
        if (parseCacheDir.isDirectory() || parseCacheDir.mkdir()) {
            return parseCacheDir;
        }
        throw new RuntimeException("could not create Bmob cache directory");
    }

    static File createKeyValueCacheFile(String key) {
        String filename = String.valueOf(new Date().getTime()) + '.' + key;
        return new File(CacheHelper.getKeyValueCacheDir(), filename);
    }

    public static Object jsonFromKeyValueCache(String key, long maxAgeMilliseconds) {
        String raw = CacheHelper.loadFromKeyValueCache(key, maxAgeMilliseconds);
        if (raw == null) {
            return null;
        }
        JSONTokener tokener = new JSONTokener(ZipUtil.uncompress(raw));
        try {
            Object o = tokener.nextValue();
            return o;
        }
        catch (JSONException e) {
            CacheHelper.clearFromKeyValueCache(key);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String loadFromKeyValueCache(String key, long maxAgeMilliseconds) {
        String string;
        File file = CacheHelper.getKeyValueCacheFile(key);
        if (file == null) {
            return null;
        }
        Date now = new Date();
        long oldestAcceptableAge = Math.max(0L, now.getTime() - maxAgeMilliseconds);
        if (CacheHelper.getKeyValueCacheAge(file) < oldestAcceptableAge) {
            return null;
        }
        file.setLastModified(now.getTime());
        RandomAccessFile f = null;
        try {
            f = new RandomAccessFile(file, "r");
            byte[] bytes = new byte[(int)f.length()];
            f.readFully(bytes);
            f.close();
            string = new String(bytes, "UTF-8");
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(f);
                throw throwable;
            }
            IOUtils.closeQuietly(f);
            return null;
        }
        IOUtils.closeQuietly(f);
        return string;
    }

    static long getKeyValueCacheAge(File cacheFile) {
        String name = cacheFile.getName();
        try {
            return Long.parseLong(name.substring(0, name.indexOf(46)));
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public static void clearFromKeyValueCache(String key) {
        File file = CacheHelper.getKeyValueCacheFile(key);
        if (file != null && file.exists()) {
            file.delete();
        }
    }

    public static void clearCacheDir() {
        File dir = CacheHelper.getKeyValueCacheDir();
        File[] entries = dir.listFiles();
        if (entries == null) {
            return;
        }
        for (int i = 0; i < entries.length; ++i) {
            entries[i].delete();
        }
    }
}

