/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.util;

import android.content.Context;
import android.text.TextUtils;
import cn.bmob.v3.helper.GsonUtil;
import cn.bmob.v3.util.BLog;
import cn.bmob.v3.util.BmobContentProvider;
import cn.bmob.v3.util.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CacheManager {
    private static volatile CacheManager instance;
    Context context;

    private CacheManager(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CacheManager getInstance(Context context) {
        if (instance != null) return instance;
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (instance != null) return instance;
            instance = new CacheManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public <T> void changeCurrentUser(String submit, String data, Class<T> clazz) {
        String newCurrent;
        String local = BmobContentProvider.getUser();
        if (!TextUtils.isEmpty((CharSequence)local)) {
            Map<String, Object> localMap = GsonUtil.toMap(local);
            Map<String, Object> submitMap = GsonUtil.toMap(submit);
            if (submitMap.size() > 0 && localMap.size() > 0) {
                for (Map.Entry<String, Object> pair : submitMap.entrySet()) {
                    localMap.put(pair.getKey(), submitMap.get(pair.getKey()));
                }
            }
            newCurrent = GsonUtil.mapToJson(localMap);
        } else {
            newCurrent = submit;
        }
        String last = this.cast(newCurrent, data);
        BmobContentProvider.updateUser(last, clazz);
    }

    private String cast(String newCurrent, String data) {
        String lastData = "";
        try {
            JSONObject localObj = new JSONObject(newCurrent);
            JSONObject updateObj = new JSONObject(data);
            if (updateObj != null) {
                Iterator it = updateObj.keys();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    Object value = updateObj.get(key);
                    if (key.contains(".")) {
                        this.parseKey(key, value, localObj);
                        continue;
                    }
                    if (value instanceof JSONObject) {
                        JSONObject obj = (JSONObject)value;
                        this.parseJSONObject(key, obj, localObj);
                        continue;
                    }
                    if (value instanceof JSONArray) {
                        localObj.put(key, (Object)((JSONArray)value));
                        continue;
                    }
                    localObj.put(key, value);
                }
            }
            lastData = localObj.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            lastData = newCurrent;
        }
        return lastData;
    }

    private void parseKey(String key, Object value, JSONObject localObj) {
        try {
            String[] s = key.split("\\.");
            if (s.length >= 2) {
                String newKey = s[0];
                if (s.length == 2) {
                    String p = s[1];
                    try {
                        int pos = Integer.parseInt(p);
                        JSONArray ary = localObj.has(newKey) ? localObj.getJSONArray(newKey) : new JSONArray();
                        ary.put(pos, value);
                        localObj.put(newKey, (Object)ary);
                    }
                    catch (Exception e) {
                        String newKey2 = p;
                        JSONObject obj = localObj.has(newKey) ? localObj.getJSONObject(newKey) : new JSONObject();
                        obj.put(newKey2, value);
                        localObj.put(newKey, (Object)obj);
                    }
                } else if (s.length == 3) {
                    JSONArray ary = localObj.has(newKey) ? localObj.getJSONArray(newKey) : new JSONArray();
                    int pos = Integer.parseInt(s[1]);
                    String newKey2 = s[2];
                    JSONObject o = ary.getJSONObject(pos);
                    if (o == null) {
                        o = new JSONObject();
                    }
                    o.put(newKey2, value);
                    ary.put(pos, (Object)o);
                    localObj.put(newKey, (Object)ary);
                } else {
                    BLog.e("bmob", "key length (" + s.length + ") is not support.");
                }
            } else {
                BLog.e("bmob", "key length less than 2.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parseJSONObject(String key, JSONObject obj, JSONObject localObj) throws JSONException {
        if (obj.has("__op")) {
            String type = obj.getString("__op");
            if (type.equals("Increment")) {
                int amount = 0;
                if (obj.has("amount")) {
                    amount = obj.getInt("amount");
                }
                if (localObj.has(key)) {
                    int localAmount = localObj.getInt(key);
                    amount += localAmount;
                }
                localObj.put(key, amount);
            } else if (type.equals("Delete")) {
                if (localObj.has(key)) {
                    localObj.remove(key);
                } else {
                    BLog.e("bmob", "no key Delete");
                }
            } else {
                this.parseByObjects(key, obj, localObj);
            }
        } else {
            localObj.put(key, (Object)obj);
        }
    }

    private void parseByObjects(String key, JSONObject obj, JSONObject localObj) throws JSONException {
        ArrayList<Object> saveList;
        String type;
        int i;
        JSONArray ary;
        JSONArray saveAry = new JSONArray();
        if (obj.has("objects") && (ary = obj.getJSONArray("objects")) != null && ary.length() > 0) {
            int size = ary.length();
            for (i = 0; i < size; ++i) {
                Object o = ary.get(i);
                saveAry.put(o);
            }
        }
        if ((type = obj.getString("__op")).equals("Remove")) {
            if (localObj.has(key)) {
                JSONArray currentAry = localObj.getJSONArray(key);
                ArrayList<Object> curList = Utils.jsonArray2List(currentAry);
                saveList = Utils.jsonArray2List(saveAry);
                if (saveList.size() > 0) {
                    int s = saveList.size();
                    for (int i2 = 0; i2 < s; ++i2) {
                        curList.remove(saveList.get(i2));
                    }
                    localObj.put(key, (Object)Utils.list2JSONArray(curList));
                } else {
                    BLog.e("bmob", "no data remove");
                }
            } else {
                BLog.e("bmob", "no key remove");
            }
        } else if (type.equals("AddUnique")) {
            if (localObj.has(key)) {
                JSONArray currentAry = localObj.getJSONArray(key);
                ArrayList<Object> curList = Utils.jsonArray2List(currentAry);
                saveList = Utils.jsonArray2List(saveAry);
                curList.addAll(saveList);
                ArrayList newList = Utils.removeDuplicate(curList);
                localObj.put(key, (Object)Utils.list2JSONArray(newList));
            } else {
                localObj.put(key, (Object)saveAry);
            }
        } else if (type.equals("Add")) {
            if (localObj.has(key)) {
                if (saveAry.length() > 0) {
                    int s = saveAry.length();
                    for (i = 0; i < s; ++i) {
                        localObj.accumulate(key, saveAry.get(i));
                    }
                } else {
                    BLog.e("bmob", "no data add");
                }
            } else {
                localObj.put(key, (Object)saveAry);
            }
        } else {
            BLog.e("bmob", "\u5176\u4ed6\u7c7b\u578b\uff1a" + type);
        }
    }
}

