/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.util;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.widget.Toast;
import cn.bmob.v3.update.res.UpdateConfig;
import cn.bmob.v3.util.BmobNotificationManager;
import cn.bmob.v3.util.BmobResource;
import cn.bmob.v3.util.EncryptMD5;
import cn.bmob.v3.util.InstallUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class DownloadApk {
    private Context mContext;
    PendingIntent pendingIntent;
    String downUrl;
    String appName;
    @SuppressLint(value={"HandlerLeak"})
    Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            if (!Thread.currentThread().isInterrupted()) {
                switch (msg.what) {
                    case 1: {
                        DownloadApk.this.displayNotificationMessage(DownloadApk.this.mContext, msg.arg1);
                        break;
                    }
                    case 2: {
                        if (!UpdateConfig.isSilentDownload()) {
                            BmobNotificationManager.getInstance(DownloadApk.this.mContext).cancelNotification();
                            File file = new File(InstallUtil.getAppDir(), EncryptMD5.setMD5(DownloadApk.this.downUrl) + ".apk");
                            InstallUtil.startInstall(DownloadApk.this.mContext, file);
                            break;
                        }
                        File file = new File(InstallUtil.getAppDir(), EncryptMD5.setMD5(DownloadApk.this.downUrl) + ".apk");
                        Intent intent = InstallUtil.startInstall(DownloadApk.this.mContext, file);
                        DownloadApk.this.pendingIntent = Build.VERSION.SDK_INT >= 31 ? PendingIntent.getActivity((Context)DownloadApk.this.mContext, (int)0, (Intent)intent, (int)0x4000000) : PendingIntent.getActivity((Context)DownloadApk.this.mContext, (int)0, (Intent)intent, (int)0);
                        int icon = 17301634;
                        String ticker = DownloadApk.this.mContext.getString(BmobResource.getInstance(DownloadApk.this.mContext).getString("bmob_common_silent_download_finish"));
                        String contentTitle = DownloadApk.this.appName;
                        String contentText = DownloadApk.this.mContext.getString(BmobResource.getInstance(DownloadApk.this.mContext).getString("bmob_common_silent_download_finish"));
                        BmobNotificationManager.showNotification(DownloadApk.this.mContext, icon, contentTitle, contentText, ticker, DownloadApk.this.pendingIntent);
                        break;
                    }
                    case -1: {
                        String error = msg.getData().getString("error");
                        Toast.makeText((Context)DownloadApk.this.mContext, (CharSequence)error, (int)0).show();
                        BmobNotificationManager.getInstance(DownloadApk.this.mContext).cancelNotification();
                        break;
                    }
                }
            }
        }
    };

    public DownloadApk(Context context, String apkUrl) {
        this.mContext = context.getApplicationContext();
        this.downUrl = apkUrl;
        this.appName = this.mContext.getApplicationInfo().loadLabel(this.mContext.getPackageManager()).toString();
    }

    public void startDownload() {
        if (!UpdateConfig.isSilentDownload() && !TextUtils.isEmpty((CharSequence)this.downUrl)) {
            Intent intent = new Intent();
            intent.addFlags(0x20000000);
            this.pendingIntent = Build.VERSION.SDK_INT >= 31 ? PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)intent, (int)0x4000000) : PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)intent, (int)0);
            int icon = 0x1080081;
            String ticker = this.mContext.getString(BmobResource.getInstance(this.mContext).getString("bmob_common_start_download_notification"));
            String contentTitle = this.mContext.getString(BmobResource.getInstance(this.mContext).getString("bmob_common_download_notification_prefix")) + this.appName;
            String contentText = "0%";
            BmobNotificationManager.showNotification(this.mContext, icon, contentTitle, contentText, ticker, this.pendingIntent);
        } else if (TextUtils.isEmpty((CharSequence)this.downUrl)) {
            Toast.makeText((Context)this.mContext, (int)BmobResource.getInstance(this.mContext).getString("bmob_common_download_failed"), (int)0).show();
            return;
        }
        this.beginning(this.downUrl, this.mContext.getApplicationInfo().loadLabel(this.mContext.getPackageManager()).toString());
    }

    private void displayNotificationMessage(Context context, int count) {
        String title = this.mContext.getString(BmobResource.getInstance(this.mContext).getString("bmob_common_download_notification_prefix")) + this.appName;
        String content = count + "%";
        String ticker = this.mContext.getString(BmobResource.getInstance(this.mContext).getString("bmob_common_start_download_notification"));
        BmobNotificationManager.showNotification(context, 0x1080081, title, content, ticker, this.pendingIntent);
    }

    private void beginning(final String downUrl, String fileName) {
        new Thread(){

            @Override
            public void run() {
                DownloadApk.this.loadFileOkHttp(downUrl);
            }
        }.start();
    }

    public void loadFileOkHttp(String url) {
        OkHttpClient okHttpClient = new OkHttpClient();
        Request.Builder builder = new Request.Builder();
        builder.url(url);
        builder.get();
        Request request = builder.build();
        Call call = okHttpClient.newCall(request);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                Message msg = new Message();
                msg.what = -1;
                msg.arg1 = 0;
                Bundle bundle = new Bundle();
                bundle.putString("error", "\u4e0b\u8f7d\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u60a8\u7684\u7f51\u7edc" + e.getMessage());
                msg.setData(bundle);
                DownloadApk.this.handler.sendMessage(msg);
            }

            public void onResponse(Call call, Response response) throws IOException {
                long length = response.body().contentLength();
                InputStream is = response.body().byteStream();
                OutputStream fileOutputStream = null;
                if (is != null) {
                    int ch;
                    File file = new File(InstallUtil.getAppDir(), EncryptMD5.setMD5(DownloadApk.this.downUrl) + ".apk");
                    fileOutputStream = new FileOutputStream(file);
                    byte[] buf = new byte[1024];
                    float count = 0.0f;
                    int downloadCount = 0;
                    while ((ch = is.read(buf)) != -1) {
                        ((FileOutputStream)fileOutputStream).write(buf, 0, ch);
                        if (downloadCount != 0 && (int)((count += (float)ch) * 100.0f / (float)length) - 10 <= downloadCount) continue;
                        downloadCount += 10;
                        if (UpdateConfig.isSilentDownload()) continue;
                        DownloadApk.this.sendMsg(1, (int)(count * 100.0f / (float)length));
                    }
                }
                DownloadApk.this.sendMsg(2, 0);
                if (fileOutputStream != null) {
                    fileOutputStream.flush();
                    ((FileOutputStream)fileOutputStream).close();
                }
            }
        });
    }

    private void sendMsg(int flag, int c) {
        Message msg = new Message();
        msg.what = flag;
        msg.arg1 = c;
        this.handler.sendMessage(msg);
    }
}

