/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import android.util.Base64;
import cn.bmob.v3.util.BLog;
import cn.bmob.v3.util.EncryptMD5;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class EncryptUtils {
    public static String getAppSign(Context context) {
        String appSign = EncryptUtils.isDebuggable(context) ? EncryptUtils.getSignature(context) + "/" + 0 : EncryptUtils.getSignature(context) + "/" + 1;
        return appSign;
    }

    private static String getSignature(Context context) {
        String signature = "";
        try {
            Signature[] sigs = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)64).signatures;
            byte[] line = sigs[0].toByteArray();
            signature = EncryptMD5.hexdigest(line);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return signature;
    }

    private static boolean isDebuggable(Context ctx) {
        try {
            ApplicationInfo info = ctx.getApplicationInfo();
            return (info.flags & 2) != 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String getInstallationId(Context context) {
        String fakeUid = EncryptUtils.getFakeUniqueID();
        String androidId = EncryptUtils.getAndroidId(context);
        String m_szLongID = fakeUid + androidId;
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.update(m_szLongID.getBytes(), 0, m_szLongID.length());
            byte[] p_md5Data = m.digest();
            String m_szUniqueID = new String();
            for (int i = 0; i < p_md5Data.length; ++i) {
                int b = 0xFF & p_md5Data[i];
                if (b <= 15) {
                    m_szUniqueID = m_szUniqueID + "0";
                }
                m_szUniqueID = m_szUniqueID + Integer.toHexString(b);
            }
            m_szUniqueID = m_szUniqueID.toUpperCase(Locale.CHINA);
            return m_szUniqueID;
        }
        catch (Exception e) {
            e.printStackTrace();
            return m_szLongID.toUpperCase(Locale.CHINA);
        }
    }

    private static String getFakeUniqueID() {
        return "35" + Build.BOARD.length() % 10 + Build.BRAND.length() % 10 + Build.CPU_ABI.length() % 10 + Build.DEVICE.length() % 10 + Build.DISPLAY.length() % 10 + Build.HOST.length() % 10 + Build.ID.length() % 10 + Build.MANUFACTURER.length() % 10 + Build.MODEL.length() % 10 + Build.PRODUCT.length() % 10 + Build.TAGS.length() % 10 + Build.TYPE.length() % 10 + Build.USER.length() % 10;
    }

    private static String getAndroidId(Context context) {
        try {
            return "android";
        }
        catch (Exception e) {
            return "";
        }
    }

    public static final String getUserAgent(Context context) {
        StringBuilder builder = new StringBuilder();
        builder.append(EncryptUtils.getOldUserAgent(context));
        builder.append(String.valueOf(System.currentTimeMillis()));
        builder.append("Android");
        builder.append(String.valueOf("v3.6.9"));
        return builder.toString();
    }

    private static final String getOldUserAgent(Context context) {
        String userAgent = "volley/0";
        return userAgent;
    }

    public static String encrypt(String key, String iv, String value) {
        try {
            int keyLength = 16;
            int ivLength = 16;
            if (key.length() != keyLength) {
                return null;
            }
            if (iv.length() != ivLength) {
                return null;
            }
            byte[] keyBytes = key.getBytes("utf-8");
            byte[] ivBytes = iv.getBytes("utf-8");
            SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, "AES");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(ivBytes);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            byte[] encrypted = cipher.doFinal(value.getBytes());
            String base64 = Base64.encodeToString((byte[])encrypted, (int)2);
            return base64;
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            return null;
        }
    }

    public static void main(String[] args) {
        String enc = "p0frH2rtlSUlqSQ3y9NVDL8UopNj+k+fhEXfO5o2R2LU9ZncIixImnHlTYIfakbSfRb3feNLxvgz4Idb9exz3BWmbIgj/b1TPe17bwhWxws2v1rhLxYyHSwRwSzDEN5PtvkJDlSyA==";
        String key = "c377221481e717db";
        String res = EncryptUtils.decrypt(key, key, enc);
        BLog.e("" + res);
    }

    public static String decrypt(String key, String iv, String value) {
        try {
            int keyLength = 16;
            int ivLength = 16;
            if (key.length() != keyLength) {
                return null;
            }
            if (iv.length() != ivLength) {
                return null;
            }
            byte[] keyBytes = key.getBytes("utf-8");
            byte[] ivBytes = iv.getBytes("utf-8");
            SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, "AES");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(ivBytes);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            byte[] encrypted = Base64.decode((String)value, (int)2);
            byte[] original = cipher.doFinal(encrypted);
            return new String(original);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String encryptAgent(String agent, String value) {
        String key = agent.substring(agent.length() - 16);
        return EncryptUtils.encrypt(key, key, value);
    }
}

