/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.util;

import cn.bmob.v3.util.BLog;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HtmlUtils {
    private static Pattern HTML_TITLE_PATTERN = Pattern.compile("<title>.*?</title>");
    private static Pattern HTML_CODE_PATTERN = Pattern.compile("<div class=\"K\">.*?</div>");
    private static Pattern HTML_MESSAGE_PATTERN = Pattern.compile("<div class=\"O I\">.*?</div>");
    private static Pattern HTML_IP_PATTERN = Pattern.compile("<span class=\"F\">.*?</span>");

    private static String get(Pattern pattern, String htmlSource) {
        ArrayList<String> list = new ArrayList<String>();
        String title = "";
        Matcher ma = pattern.matcher(htmlSource);
        while (ma.find()) {
            list.add(ma.group());
        }
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) continue;
            title = title + (String)list.get(i);
        }
        return HtmlUtils.outTag(title);
    }

    public static String getTitle(String htmlSource) {
        return HtmlUtils.get(HTML_TITLE_PATTERN, htmlSource);
    }

    public static Integer getCode(String htmlSource) {
        Integer code = 9015;
        try {
            code = Integer.valueOf(HtmlUtils.get(HTML_CODE_PATTERN, htmlSource));
        }
        catch (Exception e) {
            BLog.e(e);
        }
        return code;
    }

    public static String getMessage(String htmlSource) {
        return HtmlUtils.get(HTML_MESSAGE_PATTERN, htmlSource);
    }

    public static String getIp(String htmlSource) {
        return HtmlUtils.get(HTML_IP_PATTERN, htmlSource);
    }

    public static String outTag(String s) {
        return s.replaceAll("<.*?>", "");
    }
}

