/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.util;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import androidx.core.content.FileProvider;
import cn.bmob.v3.BmobWrapper;
import java.io.File;

public class InstallUtil {
    private static String sAuthorities;
    private static boolean hasSDCard;

    public static void setAuthorities(String authorities) {
        sAuthorities = authorities;
    }

    public static String getAppDir() {
        if (hasSDCard) {
            return BmobWrapper.getInstance().getApplicationContext().getExternalCacheDir().getAbsolutePath();
        }
        return BmobWrapper.getInstance().getApplicationContext().getCacheDir().getAbsolutePath();
    }

    private static String mkdirs(String dir) {
        File file = new File(dir);
        if (!file.exists()) {
            file.mkdirs();
        }
        return dir;
    }

    public static Intent startInstall(Context context, File file) {
        Intent intent = new Intent("android.intent.action.VIEW");
        if (Build.VERSION.SDK_INT >= 24) {
            if (TextUtils.isEmpty((CharSequence)sAuthorities)) {
                sAuthorities = context.getPackageName();
            }
            Uri apkUri = FileProvider.getUriForFile((Context)context, (String)sAuthorities, (File)file);
            intent.addFlags(1);
            intent.addFlags(0x10000000);
            intent.setDataAndType(apkUri, "application/vnd.android.package-archive");
        } else {
            intent.addFlags(0x10000000);
            intent.setDataAndType(Uri.fromFile((File)file), "application/vnd.android.package-archive");
        }
        context.startActivity(intent);
        return intent;
    }

    static {
        hasSDCard = Environment.getExternalStorageState().equals("mounted");
    }
}

