/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.util;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import cn.bmob.v3.Bmob;
import cn.bmob.v3.util.BLog;

public class ManifestUtils {
    private static final String TAG = "bmob";
    private static final Object lock = new Object();
    static int versionCode = -1;
    static String versionName = null;
    private static int iconId = 0;
    private static String displayName = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getVersionCode() {
        Object object = lock;
        synchronized (object) {
            if (versionCode == -1) {
                try {
                    versionCode = ManifestUtils.getPackageManager().getPackageInfo((String)ManifestUtils.getContext().getPackageName(), (int)0).versionCode;
                }
                catch (PackageManager.NameNotFoundException e) {
                    BLog.e(TAG, "Couldn't find info about own package", (Exception)((Object)e));
                }
            }
        }
        return versionCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVersionName() {
        Object object = lock;
        synchronized (object) {
            if (versionName == null) {
                try {
                    versionName = ManifestUtils.getPackageManager().getPackageInfo((String)ManifestUtils.getContext().getPackageName(), (int)0).versionName;
                }
                catch (PackageManager.NameNotFoundException e) {
                    BLog.e(TAG, "Couldn't find info about own package", (Exception)((Object)e));
                }
            }
        }
        return versionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDisplayName() {
        Object object = lock;
        synchronized (object) {
            if (displayName == null) {
                ApplicationInfo appInfo = ManifestUtils.getContext().getApplicationInfo();
                displayName = ManifestUtils.getContext().getPackageManager().getApplicationLabel(appInfo).toString();
            }
        }
        return displayName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getIconId() {
        Object object = lock;
        synchronized (object) {
            if (iconId == 0) {
                iconId = ManifestUtils.getContext().getApplicationInfo().icon;
            }
        }
        return iconId;
    }

    private static Context getContext() {
        return Bmob.getApplicationContext();
    }

    private static PackageManager getPackageManager() {
        return ManifestUtils.getContext().getPackageManager();
    }

    private static ApplicationInfo getApplicationInfo(Context context, int flags) {
        try {
            return context.getPackageManager().getApplicationInfo(context.getPackageName(), flags);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    public static Bundle getMetaData() {
        ApplicationInfo info = ManifestUtils.getApplicationInfo(ManifestUtils.getContext(), 128);
        if (info != null) {
            return info.metaData;
        }
        return null;
    }

    public static String getMetaData(String name) {
        Bundle bundle = ManifestUtils.getMetaData();
        if (bundle != null) {
            return bundle.getString(name);
        }
        return null;
    }

    private static PackageInfo getPackageInfo(String name) {
        PackageInfo info = null;
        try {
            info = ManifestUtils.getPackageManager().getPackageInfo(name, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return info;
    }

    private static ServiceInfo getServiceInfo(Class<? extends Service> clazz) {
        ServiceInfo info = null;
        try {
            info = ManifestUtils.getPackageManager().getServiceInfo(new ComponentName(ManifestUtils.getContext(), clazz), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return info;
    }

    private static ActivityInfo getReceiverInfo(Class<? extends BroadcastReceiver> clazz) {
        ActivityInfo info = null;
        try {
            info = ManifestUtils.getPackageManager().getReceiverInfo(new ComponentName(ManifestUtils.getContext(), clazz), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return info;
    }

    public static String getNetType(Context context) {
        String netType = "4";
        ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkinfo = connManager.getActiveNetworkInfo();
        if (networkinfo != null) {
            if ("WIFI".equals(networkinfo.getTypeName())) {
                netType = "3";
            } else {
                String str = networkinfo.getExtraInfo();
                if (!TextUtils.isEmpty((CharSequence)str)) {
                    netType = str.equals("3gwap") || str.equals("3gnet") ? "2" : (str.equals("uninet") || str.equals("uniwap") || str.equals("cmwap") || str.equals("cmnet") || str.equals("ctwap") || str.equals("ctnet") ? "1" : "4");
                }
            }
        }
        return netType;
    }

    public static String getPermissionData(Context context) {
        PackageManager pm = context.getPackageManager();
        String[] permissions = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            PackageInfo pInfo = pm.getPackageInfo(context.getPackageName(), 4096);
            permissions = pInfo.requestedPermissions;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        if (permissions != null) {
            for (int i = 0; i < permissions.length; ++i) {
                stringBuffer.append(permissions[i]).append(",");
            }
        }
        return stringBuffer.toString();
    }

    public static boolean detectNetWork(Context context) {
        if (!ManifestUtils.getPermissionData(context).contains("android.permission.ACCESS_NETWORK_STATE")) {
            Log.w((String)TAG, (String)"No android.permission.ACCESS_NETWORK_STATE Privileges.");
            return false;
        }
        ConnectivityManager manager = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        if (manager == null) {
            return false;
        }
        NetworkInfo networkinfo = manager.getActiveNetworkInfo();
        return networkinfo != null && networkinfo.isAvailable();
    }
}

