/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.util;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Looper;
import android.util.Log;
import android.widget.Toast;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class Utils {
    public static boolean isMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static String byte2String(byte[] b) {
        return new String(b, Charset.forName("utf-8"));
    }

    public static byte[] string2Byte(String s) {
        if (s != null && s.length() > 0) {
            return s.getBytes(Charset.forName("utf-8"));
        }
        return "".getBytes(Charset.forName("utf-8"));
    }

    public static boolean checkTableName(String username, int min, int max) {
        String regex = "^[a-zA-Z]\\w{" + min + "," + max + "}$";
        return Utils.startCheck(regex, username);
    }

    private static boolean startCheck(String reg, String string) {
        Pattern pattern = Pattern.compile(reg);
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    public static boolean checkPermission(Context context, String permission) {
        PackageManager pm = context.getPackageManager();
        try {
            PackageInfo pi = pm.getPackageInfo(context.getPackageName(), 4096);
            String[] permissions = pi.requestedPermissions;
            if (permissions != null && permissions.length > 0) {
                int length = permissions.length;
                for (int i = 0; i < length; ++i) {
                    if (!permissions[i].equals(permission)) continue;
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void checkBmobContentProvider(Context context) {
        if (!Utils.checkProviderAuthority(context, context.getPackageName() + ".BmobContentProvider")) {
            Toast.makeText((Context)context, (CharSequence)("Please add provider in AndroidManifest:" + context.getPackageName() + ".BmobContentProvider"), (int)0).show();
            Log.e((String)"bmob develop tips", (String)("Please add provider in AndroidManifest:" + context.getPackageName() + ".BmobContentProvider"));
        }
    }

    public static boolean checkProviderAuthority(Context context, String authority) {
        try {
            PackageInfo localPackageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 8);
            if (localPackageInfo.providers != null) {
                for (int index = 0; index < localPackageInfo.providers.length; ++index) {
                    if (!authority.equals(localPackageInfo.providers[index].authority)) continue;
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        return false;
    }

    public static ArrayList<Object> jsonArray2List(JSONArray ary) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            if (ary != null && ary.length() > 0) {
                int size = ary.length();
                for (int i = 0; i < size; ++i) {
                    Object o = ary.get(i);
                    list.add(o);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList removeDuplicate(ArrayList al) {
        ArrayList list = new ArrayList();
        for (Object obj : al) {
            if (list.contains(obj)) continue;
            list.add(obj);
        }
        return list;
    }

    public static JSONArray list2JSONArray(ArrayList list) {
        JSONArray ary = new JSONArray();
        try {
            if (list != null && list.size() > 0) {
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    ary.put(list.get(i));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ary;
    }

    public static String parseArray2String(String[] keys) {
        StringBuilder sb = new StringBuilder();
        if (keys != null && keys.length > 0) {
            int groups = keys.length;
            for (int i = 0; i < groups; ++i) {
                if (i != groups - 1) {
                    sb.append(keys[i]);
                    sb.append(",");
                    continue;
                }
                sb.append(keys[i]);
            }
        }
        return sb.toString();
    }

    public static Map<String, Map<String, Object>> parse2Map(JSONObject fields) {
        HashMap<String, Map<String, Object>> maps = new HashMap<String, Map<String, Object>>();
        try {
            Iterator fks = fields.keys();
            while (fks.hasNext()) {
                String fk = (String)fks.next();
                JSONObject fkv = fields.getJSONObject(fk);
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (fkv == null) continue;
                Iterator kk = fkv.keys();
                while (kk.hasNext()) {
                    String k = (String)kk.next();
                    Object v = fkv.get(k);
                    map.put(k, v);
                }
                maps.put(fk, map);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return maps;
    }

    public static boolean mkdirs(File directory) {
        try {
            Utils.forceMkdir(directory);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static void forceMkdir(File directory) throws IOException {
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                String message = "File " + directory + " exists and is not a directory. Unable to create directory.";
                throw new IOException(message);
            }
        } else if (!directory.mkdirs() && !directory.isDirectory()) {
            String message = "Unable to create directory " + directory;
            throw new IOException(message);
        }
    }

    public static int calculatePercent(int cur, int total) {
        int p = 100;
        if (cur < total) {
            double percent = (double)cur / (double)total;
            p = (int)(percent * 100.0);
        }
        return p;
    }

    public static String convertUrl(String url) {
        String fileUrl;
        if (url.startsWith("https")) {
            try {
                String[] ary = url.split("/");
                fileUrl = url.replace("https://" + ary[2] + "/", "");
            }
            catch (Exception e) {
                fileUrl = url;
            }
        } else if (url.startsWith("http")) {
            try {
                String[] ary = url.split("/");
                fileUrl = url.replace("http://" + ary[2] + "/", "");
            }
            catch (Exception e) {
                fileUrl = url;
            }
        } else {
            fileUrl = url;
        }
        return fileUrl;
    }

    public static String convertFileSize(long fileS) {
        DecimalFormat df = new DecimalFormat("#.00");
        String fileSizeString = fileS > 0L ? (fileS < 1024L ? df.format((double)fileS) + "B" : (fileS < 0x100000L ? df.format((double)fileS / 1024.0) + "K" : (fileS < 0x40000000L ? df.format((double)fileS / 1048576.0) + "M" : df.format((double)fileS / 1.073741824E9) + "G"))) : "0B";
        return fileSizeString;
    }
}

