/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.util;

import cn.bmob.v3.util.IOUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ZipUtil {
    public static String compress(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(out);
            gzip.write(str.getBytes());
            gzip.close();
            return out.toString("ISO-8859-1");
        }
        catch (IOException e) {
            e.printStackTrace();
            return str;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uncompress(String str) {
        ByteArrayOutputStream out;
        block7: {
            if (str == null || str.length() == 0) {
                return str;
            }
            ByteArrayInputStream bis = null;
            GZIPInputStream gis = null;
            out = null;
            try {
                int n;
                out = new ByteArrayOutputStream();
                bis = new ByteArrayInputStream(str.getBytes("ISO-8859-1"));
                gis = new GZIPInputStream(bis);
                byte[] buffer = new byte[256];
                while ((n = gis.read(buffer)) >= 0) {
                    out.write(buffer, 0, n);
                }
                IOUtils.closeQuietly(bis);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block7;
            }
            finally {
                IOUtils.closeQuietly(bis);
                IOUtils.closeQuietly(gis);
                IOUtils.closeQuietly(out);
            }
            IOUtils.closeQuietly(gis);
            IOUtils.closeQuietly(out);
        }
        return out.toString();
    }

    public static void main(String[] args) throws IOException {
        System.out.println(ZipUtil.uncompress(ZipUtil.compress("\u4e2d\u56fdChina")));
    }

    private static int getShort(byte[] data) {
        return data[0] << 8 | data[1] & 0xFF;
    }

    public static String getRealString(byte[] data) {
        StringBuilder sb = new StringBuilder();
        if (data.length >= 2) {
            byte[] h = new byte[]{data[0], data[1]};
            int head = ZipUtil.getShort(h);
            boolean t = head == 8075;
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(data);
                InputStream in = t ? new GZIPInputStream(bis) : bis;
                BufferedReader r = new BufferedReader(new InputStreamReader(in), 1000);
                String line = r.readLine();
                while (line != null) {
                    sb.append(line);
                    line = r.readLine();
                }
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            String s = new String(data);
            sb.append(s);
        }
        return sb.toString();
    }
}

