/*
 * Decompiled with CFR 0.152.
 */
package io.bmuskalla.internal.system.properties;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Enumeration;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class DelegatingProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    private Properties baseline;
    private final ThreadLocal<Properties> environmentProperties = new ThreadLocal<Properties>(){

        @Override
        protected Properties initialValue() {
            return DelegatingProperties.this.baseline;
        }
    };

    public DelegatingProperties(Properties baseline) {
        Properties newEnvironment = this.buildNewEnvironment(baseline);
        this.environmentProperties.set(newEnvironment);
        this.baseline = baseline;
    }

    private Properties buildNewEnvironment(Properties baseline) {
        Properties frozenBaseline = (Properties)baseline.clone();
        Properties newEnvironment = new Properties();
        frozenBaseline.stringPropertyNames().forEach((? super T k) -> newEnvironment.setProperty((String)k, frozenBaseline.getProperty((String)k)));
        return newEnvironment;
    }

    @Override
    public synchronized Object get(Object key) {
        return this.environmentProperties.get().get(key);
    }

    @Override
    public Enumeration<?> propertyNames() {
        return this.environmentProperties.get().propertyNames();
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        return this.environmentProperties.get().put(key, value);
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        return this.environmentProperties.get().setProperty(key, value);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.environmentProperties.get().getProperty(key, defaultValue);
    }

    @Override
    public synchronized boolean contains(Object value) {
        return this.environmentProperties.get().contains(value);
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.environmentProperties.get().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.environmentProperties.get().containsValue(value);
    }

    @Override
    public Collection<Object> values() {
        return this.environmentProperties.get().values();
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        return this.environmentProperties.get().keys();
    }

    @Override
    public Set<Object> keySet() {
        return this.environmentProperties.get().keySet();
    }

    @Override
    public void store(OutputStream out, String comments) throws IOException {
        this.environmentProperties.get().store(out, comments);
    }

    @Override
    public void store(Writer writer, String comments) throws IOException {
        this.environmentProperties.get().store(writer, comments);
    }

    @Override
    public void storeToXML(OutputStream os, String comment) throws IOException {
        this.environmentProperties.get().storeToXML(os, comment);
    }

    @Override
    public void storeToXML(OutputStream os, String comment, String encoding) throws IOException {
        this.environmentProperties.get().storeToXML(os, comment, encoding);
    }

    @Override
    public void storeToXML(OutputStream os, String comment, Charset charset) throws IOException {
        this.storeToXML(os, comment, charset.name());
    }

    @Override
    public void load(Reader reader) throws IOException {
        this.environmentProperties.get().load(reader);
    }

    @Override
    public int size() {
        return this.environmentProperties.get().size();
    }

    @Override
    public boolean isEmpty() {
        return this.environmentProperties.get().isEmpty();
    }

    @Override
    public Enumeration<Object> elements() {
        return this.environmentProperties.get().elements();
    }

    @Override
    public void load(InputStream inStream) throws IOException {
        this.environmentProperties.get().load(inStream);
    }

    @Override
    public Object remove(Object key) {
        return this.environmentProperties.get().remove(key);
    }

    @Override
    public void putAll(Map<? extends Object, ? extends Object> t) {
        this.environmentProperties.get().putAll(t);
    }

    @Override
    public void clear() {
        this.environmentProperties.get().clear();
    }

    @Override
    public Object clone() {
        return this.environmentProperties.get().clone();
    }

    @Override
    public String toString() {
        return this.environmentProperties.get().toString();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.environmentProperties.get().entrySet();
    }

    @Override
    public void save(OutputStream out, String comments) {
        this.environmentProperties.get().save(out, comments);
    }

    @Override
    public boolean equals(Object o) {
        return this.environmentProperties.get().equals(o);
    }

    @Override
    public int hashCode() {
        return this.environmentProperties.get().hashCode();
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        return this.environmentProperties.get().getOrDefault(key, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super Object, ? super Object> action) {
        this.environmentProperties.get().forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super Object, ? super Object, ? extends Object> function) {
        this.environmentProperties.get().replaceAll(function);
    }

    @Override
    public Object putIfAbsent(Object key, Object value) {
        return this.environmentProperties.get().putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.environmentProperties.get().remove(key, value);
    }

    @Override
    public boolean replace(Object key, Object oldValue, Object newValue) {
        return this.environmentProperties.get().replace(key, oldValue, newValue);
    }

    @Override
    public void loadFromXML(InputStream in) throws IOException, InvalidPropertiesFormatException {
        this.environmentProperties.get().loadFromXML(in);
    }

    @Override
    public Object replace(Object key, Object value) {
        return this.environmentProperties.get().replace(key, value);
    }

    @Override
    public Object computeIfAbsent(Object key, Function<? super Object, ? extends Object> mappingFunction) {
        return this.environmentProperties.get().computeIfAbsent(key, mappingFunction);
    }

    @Override
    public Object computeIfPresent(Object key, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        return this.environmentProperties.get().computeIfPresent(key, remappingFunction);
    }

    @Override
    public Object compute(Object key, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        return this.environmentProperties.get().compute(key, remappingFunction);
    }

    @Override
    public Object merge(Object key, Object value, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        return this.environmentProperties.get().merge(key, value, remappingFunction);
    }

    @Override
    public String getProperty(String key) {
        return this.environmentProperties.get().getProperty(key);
    }

    @Override
    public Set<String> stringPropertyNames() {
        return this.environmentProperties.get().stringPropertyNames();
    }

    @Override
    public void list(PrintStream out) {
        this.environmentProperties.get().list(out);
    }

    @Override
    public void list(PrintWriter out) {
        this.environmentProperties.get().list(out);
    }
}

