/*
 * Decompiled with CFR 0.152.
 */
package org.treesitter;

import org.treesitter.TSException;
import org.treesitter.TSParser;
import org.treesitter.TSSymbolType;

public interface TSLanguage {
    public long getPtr();

    default public int version() {
        return TSParser.ts_language_version(this.getPtr());
    }

    default public int fieldCount() {
        return TSParser.ts_language_field_count(this.getPtr());
    }

    default public String fieldNameForId(int id) {
        return TSParser.ts_language_field_name_for_id(this.getPtr(), id);
    }

    default public int fieldIdForName(String name) {
        return TSParser.ts_language_field_id_for_name(this.getPtr(), name);
    }

    default public TSSymbolType symbolType(int symbol) {
        int type = TSParser.ts_language_symbol_type(this.getPtr(), symbol);
        switch (type) {
            case 0: {
                return TSSymbolType.TSSymbolTypeRegular;
            }
            case 1: {
                return TSSymbolType.TSSymbolTypeAnonymous;
            }
            case 2: {
                return TSSymbolType.TSSymbolTypeAuxiliary;
            }
        }
        throw new TSException("Can't handle symbol type: %d" + type);
    }

    default public int symbolCount() {
        return TSParser.ts_language_symbol_count(this.getPtr());
    }

    default public String symbolName(int symbol) {
        return TSParser.ts_language_symbol_name(this.getPtr(), symbol);
    }

    default public int symbolForName(String name, boolean isNamed) {
        return TSParser.ts_language_symbol_for_name(this.getPtr(), name, isNamed);
    }
}

