/*
 * Decompiled with CFR 0.152.
 */
package org.treesitter;

import org.treesitter.TSException;
import org.treesitter.TSInputEdit;
import org.treesitter.TSParser;
import org.treesitter.TSPoint;

public class TSNode {
    private int context0;
    private int context1;
    private int context2;
    private int context3;
    private long idPtr;
    private long treePtr;

    private void asserNotNull() {
        if (this.isNull()) {
            throw new TSException("Node is a null node");
        }
    }

    public int getChildCount() {
        this.asserNotNull();
        return TSParser.ts_node_child_count(this);
    }

    public int getNamedChildCount() {
        this.asserNotNull();
        return TSParser.ts_node_named_child_count(this);
    }

    public TSNode getNamedChild(int index) {
        this.asserNotNull();
        return TSParser.ts_node_named_child(this, index);
    }

    public String getType() {
        this.asserNotNull();
        return TSParser.ts_node_type(this);
    }

    public int getSymbol() {
        this.asserNotNull();
        return TSParser.ts_node_symbol(this);
    }

    public boolean isNull() {
        return TSParser.ts_node_is_null(this);
    }

    public boolean isNamed() {
        this.asserNotNull();
        return TSParser.ts_node_is_named(this);
    }

    public boolean isMissing() {
        this.asserNotNull();
        return TSParser.ts_node_is_missing(this);
    }

    public boolean isExtra() {
        this.asserNotNull();
        return TSParser.ts_node_is_extra(this);
    }

    public boolean hasChanges() {
        this.asserNotNull();
        return TSParser.ts_node_has_changes(this);
    }

    public boolean hasError() {
        this.asserNotNull();
        return TSParser.ts_node_has_error(this);
    }

    public int getStartByte() {
        this.asserNotNull();
        return TSParser.ts_node_start_byte(this);
    }

    public int getEndByte() {
        this.asserNotNull();
        return TSParser.ts_node_end_byte(this);
    }

    public TSPoint getStartPoint() {
        this.asserNotNull();
        return TSParser.ts_node_start_point(this);
    }

    public TSPoint getEndPoint() {
        this.asserNotNull();
        return TSParser.ts_node_end_point(this);
    }

    public TSNode getParent() {
        this.asserNotNull();
        return TSParser.ts_node_parent(this);
    }

    public TSNode getChild(int index) {
        this.asserNotNull();
        return TSParser.ts_node_child(this, index);
    }

    public String getFieldNameForChild(int index) {
        this.asserNotNull();
        return TSParser.ts_node_field_name_for_child(this, index);
    }

    public TSNode getNextNamedSibling() {
        this.asserNotNull();
        return TSParser.ts_node_next_named_sibling(this);
    }

    public TSNode getPrevNamedSibling() {
        this.asserNotNull();
        return TSParser.ts_node_prev_named_sibling(this);
    }

    public TSNode getNextSibling() {
        this.asserNotNull();
        return TSParser.ts_node_next_sibling(this);
    }

    public TSNode getPrevSibling() {
        this.asserNotNull();
        return TSParser.ts_node_prev_sibling(this);
    }

    public TSNode getChildByFieldName(String fieldName) {
        this.asserNotNull();
        return TSParser.ts_node_child_by_field_name(this, fieldName);
    }

    public TSNode getChildByFieldId(int fieldId) {
        this.asserNotNull();
        return TSParser.ts_node_child_by_field_id(this, fieldId);
    }

    public TSNode getFirstChildForByte(int startByte) {
        this.asserNotNull();
        return TSParser.ts_node_first_child_for_byte(this, startByte);
    }

    public TSNode getFirstNamedChildForByte(int startByte) {
        this.asserNotNull();
        return TSParser.ts_node_first_named_child_for_byte(this, startByte);
    }

    public TSNode getDescendantForByteRange(int startByte, int endByte) {
        this.asserNotNull();
        return TSParser.ts_node_descendant_for_byte_range(this, startByte, endByte);
    }

    public TSNode getDescendantForPointRange(TSPoint startPoint, TSPoint endPoint) {
        this.asserNotNull();
        return TSParser.ts_node_descendant_for_point_range(this, startPoint, endPoint);
    }

    public TSNode getNamedDescendantForByteRange(int startByte, int endByte) {
        this.asserNotNull();
        return TSParser.ts_node_named_descendant_for_byte_range(this, startByte, endByte);
    }

    public TSNode getNamedDescendantForPointRange(TSPoint startPoint, TSPoint endPoint) {
        this.asserNotNull();
        return TSParser.ts_node_named_descendant_for_point_range(this, startPoint, endPoint);
    }

    public void edit(TSInputEdit inputEdit) {
        this.asserNotNull();
        TSNode tsNode = TSParser.ts_node_edit(this, inputEdit);
        this.context0 = tsNode.context0;
        this.context1 = tsNode.context1;
        this.context2 = tsNode.context2;
        this.context3 = tsNode.context3;
        this.idPtr = tsNode.idPtr;
        this.treePtr = tsNode.treePtr;
    }

    public static boolean eq(TSNode a, TSNode b) {
        if (a.isNull() || b.isNull()) {
            return false;
        }
        return TSParser.ts_node_eq(a, b);
    }

    public String toString() {
        if (this.isNull()) {
            return "null";
        }
        return TSParser.ts_node_string(this);
    }
}

