/*
 * Decompiled with CFR 0.152.
 */
package org.treesitter;

import java.lang.ref.Cleaner;
import org.treesitter.TSException;
import org.treesitter.TSNode;
import org.treesitter.TSParser;
import org.treesitter.TSPoint;
import org.treesitter.TSQuery;
import org.treesitter.TSQueryMatch;

public class TSQueryCursor {
    private static Cleaner cleaner = Cleaner.create();
    private final long ptr;
    private boolean executed = false;

    private TSQueryCursor(long ptr) {
        this.ptr = ptr;
        cleaner.register(this, () -> new TSQueryCursorCleaner(ptr));
    }

    public TSQueryCursor() {
        this(TSParser.ts_query_cursor_new());
    }

    public void exec(TSQuery query, TSNode node) {
        this.executed = true;
        TSParser.ts_query_cursor_exec(this.ptr, query.getPtr(), node);
    }

    public boolean didExceedMatchLimit() {
        return TSParser.ts_query_cursor_did_exceed_match_limit(this.ptr);
    }

    public int getMatchLimit() {
        return TSParser.ts_query_cursor_match_limit(this.ptr);
    }

    public void setMatchLimit(int limit) {
        TSParser.ts_query_cursor_set_match_limit(this.ptr, limit);
    }

    public void setByteRange(int startByte, int endByte) {
        TSParser.ts_query_cursor_set_byte_range(this.ptr, startByte, endByte);
    }

    public void setPointRange(TSPoint startPoint, TSPoint endPoint) {
        TSParser.ts_query_cursor_set_point_range(this.ptr, startPoint, endPoint);
    }

    public boolean nextMatch(TSQueryMatch match) {
        if (!this.executed) {
            throw new TSException("Query not executed, call exec() first.");
        }
        return TSParser.ts_query_cursor_next_match(this.ptr, match);
    }

    public void removeMatch(int matchId) {
        TSParser.ts_query_cursor_remove_match(this.ptr, matchId);
    }

    public boolean nextCapture(TSQueryMatch match) {
        if (!this.executed) {
            throw new TSException("Query not executed, call exec() first.");
        }
        return TSParser.ts_query_cursor_next_capture(this.ptr, match);
    }

    private static class TSQueryCursorCleaner
    implements Runnable {
        private final long ptr;

        public TSQueryCursorCleaner(long ptr) {
            this.ptr = ptr;
        }

        @Override
        public void run() {
            TSParser.ts_query_cursor_delete(this.ptr);
        }
    }
}

