/*
 * Decompiled with CFR 0.152.
 */
package org.treesitter;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import org.treesitter.CleanerRunner;
import org.treesitter.TSException;
import org.treesitter.TSNode;
import org.treesitter.TSParser;
import org.treesitter.TSPoint;
import org.treesitter.TSQuery;
import org.treesitter.TSQueryCapture;
import org.treesitter.TSQueryMatch;

public class TSQueryCursor {
    private final long ptr;
    private boolean executed = false;
    private TSNode node;

    private TSQueryCursor(long ptr) {
        this.ptr = ptr;
        CleanerRunner.register(this, new TSQueryCursorCleanAction(ptr));
    }

    public TSQueryCursor() {
        this(TSParser.ts_query_cursor_new());
    }

    public void exec(TSQuery query, TSNode node) {
        this.executed = true;
        this.node = node;
        TSParser.ts_query_cursor_exec(this.ptr, query.getPtr(), node);
    }

    public boolean didExceedMatchLimit() {
        return TSParser.ts_query_cursor_did_exceed_match_limit(this.ptr);
    }

    public int getMatchLimit() {
        return TSParser.ts_query_cursor_match_limit(this.ptr);
    }

    public void setMatchLimit(int limit) {
        TSParser.ts_query_cursor_set_match_limit(this.ptr, limit);
    }

    public void setByteRange(int startByte, int endByte) {
        TSParser.ts_query_cursor_set_byte_range(this.ptr, startByte, endByte);
    }

    public void setPointRange(TSPoint startPoint, TSPoint endPoint) {
        TSParser.ts_query_cursor_set_point_range(this.ptr, startPoint, endPoint);
    }

    public boolean nextMatch(TSQueryMatch match) {
        this.assertExecuted();
        boolean ret = TSParser.ts_query_cursor_next_match(this.ptr, match);
        this.addTsTreeRef(match);
        return ret;
    }

    public void removeMatch(int matchId) {
        TSParser.ts_query_cursor_remove_match(this.ptr, matchId);
    }

    public boolean nextCapture(TSQueryMatch match) {
        this.assertExecuted();
        boolean ret = TSParser.ts_query_cursor_next_capture(this.ptr, match);
        this.addTsTreeRef(match);
        return ret;
    }

    private void addTsTreeRef(TSQueryMatch match) {
        if (match.getCaptures() != null) {
            for (TSQueryCapture capture : match.getCaptures()) {
                if (capture.getNode() == null) continue;
                capture.getNode().setTree(this.node.getTree());
            }
        }
    }

    private void assertExecuted() {
        if (!this.executed) {
            throw new TSException("Query not executed, call exec() first.");
        }
    }

    public TSMatchIterator getMatches() {
        return new TSMatchIterator(TSParser::ts_query_cursor_next_match);
    }

    public TSMatchIterator getCaptures() {
        return new TSMatchIterator(TSParser::ts_query_cursor_next_capture);
    }

    public class TSMatchIterator
    implements Iterator<TSQueryMatch> {
        private TSQueryMatch tempMatch = null;
        private TSQueryMatch lastMatch = null;
        private BiFunction<Long, TSQueryMatch, Boolean> nextFunction;

        public TSMatchIterator(BiFunction<Long, TSQueryMatch, Boolean> nextFunction) {
            this.nextFunction = nextFunction;
        }

        private TSQueryMatch nextMatch() {
            TSQueryCursor.this.assertExecuted();
            TSQueryMatch match = new TSQueryMatch();
            boolean ret = this.nextFunction.apply(TSQueryCursor.this.ptr, match);
            if (ret) {
                TSQueryCursor.this.addTsTreeRef(match);
                return match;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            TSQueryMatch match = this.nextMatch();
            if (match != null) {
                this.tempMatch = match;
                return true;
            }
            return false;
        }

        @Override
        public TSQueryMatch next() {
            if (this.tempMatch != null) {
                TSQueryMatch newMatch = this.tempMatch;
                this.tempMatch = null;
                return newMatch;
            }
            TSQueryMatch match = this.nextMatch();
            if (match != null) {
                this.lastMatch = match;
                return match;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.lastMatch == null) {
                throw new IllegalStateException();
            }
            TSParser.ts_query_cursor_remove_match(TSQueryCursor.this.ptr, this.tempMatch.getId());
        }
    }

    private static class TSQueryCursorCleanAction
    implements Runnable {
        private final long ptr;

        public TSQueryCursorCleanAction(long ptr) {
            this.ptr = ptr;
        }

        @Override
        public void run() {
            TSParser.ts_query_cursor_delete(this.ptr);
        }
    }
}

