/*
 * Decompiled with CFR 0.152.
 */
package org.treesitter.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import java.util.zip.CRC32;

public abstract class NativeUtils {
    private static String getFullLibName(String libName) {
        String arch;
        String os;
        String ext;
        String osName = System.getProperty("os.name").toLowerCase();
        String archName = System.getProperty("os.arch").toLowerCase();
        if (osName.contains("windows")) {
            ext = "dll";
            os = "windows";
        } else if (osName.contains("linux")) {
            ext = "so";
            os = "linux-gnu";
        } else if (osName.contains("mac")) {
            ext = "dylib";
            os = "macos";
        } else {
            throw new RuntimeException(String.format("Does not support OS: %s", osName));
        }
        if (archName.contains("amd64") || archName.contains("x86_64")) {
            arch = "x86_64";
        } else if (archName.contains("aarch64")) {
            arch = "aarch64";
        } else {
            throw new RuntimeException(String.format("Does not support arch: %s", archName));
        }
        String[] parts = libName.split("/");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            if (i == parts.length - 1) {
                stringBuilder.append(String.format("%s-%s-%s.%s", arch, os, parts[i], ext));
                continue;
            }
            stringBuilder.append(parts[i]);
            stringBuilder.append("/");
        }
        return stringBuilder.toString();
    }

    private static Path getLibStorePath() {
        String userDefinedPath = System.getProperty("tree-sitter-lib");
        if (userDefinedPath == null) {
            return Path.of(System.getProperty("user.home"), ".tree-sitter");
        }
        return Path.of(userDefinedPath, new String[0]);
    }

    private static long crc32(byte[] bytes) {
        CRC32 crc32 = new CRC32();
        crc32.update(bytes, 0, bytes.length);
        return crc32.getValue();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static byte[] readFile(File file) {
        try (FileInputStream inputStream = new FileInputStream(file);){
            byte[] byArray;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                ((InputStream)inputStream).transferTo(outputStream);
                byArray = outputStream.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] readInputStream(InputStream inputStream) {
        byte[] byArray;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            inputStream.transferTo(outputStream);
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        outputStream.close();
        return byArray;
    }

    private static byte[] readLib(String libName) {
        String fullLibName = NativeUtils.getFullLibName(libName);
        InputStream inputStream = NativeUtils.class.getClassLoader().getResourceAsStream(fullLibName);
        if (inputStream == null) {
            throw new RuntimeException(String.format("Can't open %s", fullLibName));
        }
        return NativeUtils.readInputStream(inputStream);
    }

    public static void loadLib(String libName) {
        String fullLibName = NativeUtils.getFullLibName(libName);
        Path filePath = NativeUtils.getLibStorePath().resolve(fullLibName);
        File file = filePath.toFile();
        file.getParentFile().mkdirs();
        boolean shouldOverwrite = false;
        byte[] newFileBytes = null;
        if (file.exists()) {
            byte[] oldFileBytes = NativeUtils.readFile(file);
            newFileBytes = NativeUtils.readLib(libName);
            if (NativeUtils.crc32(oldFileBytes) != NativeUtils.crc32(newFileBytes)) {
                shouldOverwrite = true;
            }
        } else {
            shouldOverwrite = true;
        }
        if (!shouldOverwrite) {
            System.load(file.getAbsolutePath());
            return;
        }
        if (newFileBytes == null) {
            newFileBytes = NativeUtils.readLib(libName);
        }
        try (RandomAccessFile raf = new RandomAccessFile(file, "rw");
             FileChannel channel = raf.getChannel();
             ByteArrayInputStream inputStream = new ByteArrayInputStream(newFileBytes);
             FileLock fileLock = channel.lock();){
            if (!file.exists() || file.length() == 0L) {
                int bytesRead;
                ByteBuffer buffer = ByteBuffer.allocate(4096);
                while ((bytesRead = inputStream.read(buffer.array())) != -1) {
                    buffer.limit(bytesRead);
                    channel.write(buffer);
                    buffer.clear();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        System.load(file.getAbsolutePath());
    }
}

