/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup;

import io.github.bonigarcia.seljup.AnnotationsReader;
import io.github.bonigarcia.seljup.BrowserInstance;
import io.github.bonigarcia.seljup.BrowserType;
import io.github.bonigarcia.seljup.CloudType;
import io.github.bonigarcia.seljup.InternalPreferences;
import io.github.bonigarcia.seljup.Server;
import io.github.bonigarcia.seljup.config.Config;
import io.github.bonigarcia.seljup.handler.DockerDriverHandler;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Optional;
import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeleniumJupiter {
    static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static Config config = new Config();
    static AnnotationsReader annotationsReader = new AnnotationsReader();
    static InternalPreferences preferences = new InternalPreferences(config);

    public static void main(String[] args) {
        String validBrowsers = "chrome|firefox|opera|edge|iexplorer|android";
        if (args.length <= 0) {
            SeleniumJupiter.logCliError(validBrowsers);
        } else {
            String arg = args[0];
            if (arg.equalsIgnoreCase("server")) {
                SeleniumJupiter.startServer(args);
            } else if (arg.equalsIgnoreCase("clear-preferences")) {
                new InternalPreferences(config).clear();
            } else {
                SeleniumJupiter.resolveLocal(args);
            }
        }
    }

    private static void resolveLocal(String[] args) {
        String browser = args[0];
        String version = "";
        String deviceName = "";
        String versionMessage = "(latest)";
        if (args.length > 1) {
            versionMessage = version = args[1];
        }
        if (args.length > 2) {
            deviceName = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
        }
        log.info("Using Selenium-Jupiter to execute {} {} in Docker", (Object)browser, (Object)versionMessage);
        try {
            config.setVnc(true);
            config.setBrowserSessionTimeoutDuration("99h0m0s");
            BrowserInstance browserInstance = new BrowserInstance(config, annotationsReader, BrowserType.valueOf(browser.toUpperCase()), CloudType.NONE, Optional.empty(), Optional.empty());
            final DockerDriverHandler dockerDriverHandler = new DockerDriverHandler(config, browserInstance, version, preferences);
            final WebDriver webdriver = dockerDriverHandler.resolve(browserInstance, version, deviceName, config.getDockerServerUrl(), true);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    SeleniumJupiter.cleanContainers(dockerDriverHandler, webdriver);
                }
            });
            log.info("Press ENTER to exit");
            Scanner scanner = new Scanner(System.in);
            scanner.nextLine();
            scanner.close();
            SeleniumJupiter.cleanContainers(dockerDriverHandler, webdriver);
        }
        catch (Exception e) {
            log.error("Exception trying to execute {} {} in Docker", new Object[]{browser, versionMessage, e});
        }
    }

    private static void cleanContainers(DockerDriverHandler dockerDriverHandler, WebDriver webdriver) {
        if (webdriver != null) {
            webdriver.quit();
        }
        if (dockerDriverHandler != null) {
            dockerDriverHandler.cleanup();
            dockerDriverHandler.close();
        }
    }

    private static void startServer(String[] args) {
        int port = config.getServerPort();
        if (args.length > 1 && StringUtils.isNumeric((CharSequence)args[1])) {
            port = Integer.parseInt(args[1]);
        }
        new Server(port);
    }

    private static void logCliError(String validBrowsers) {
        log.error("There are 3 options to run Selenium-Jupiter CLI");
        log.error("1. Selenium-Jupiter used to get VNC sessions of browsers:");
        log.error("\tSeleniumJupiter browserName <version> <deviceName>");
        log.error("\t...where:");
        log.error("\tbrowserName = {}", (Object)validBrowsers);
        log.error("\tversion = optional version (latest by default)");
        log.error("\tdeviceName = Device name (only for Android)");
        log.error("\t(where browserName={})", (Object)validBrowsers);
        log.error("2. Selenium-Jupiter as a server:");
        log.error("\tSelenium-Jupiter server <port>");
        log.error("\t(where default port is 4042)");
        log.error("3. To clear previously Docker image versions (as Java preferences):");
        log.error("\tSelenium-Jupiter clear-preferences");
    }
}

