/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup;

import com.google.gson.GsonBuilder;
import io.github.bonigarcia.seljup.BrowserInstance;
import io.github.bonigarcia.seljup.BrowserType;
import io.github.bonigarcia.seljup.DockerBrowserConfig;
import io.github.bonigarcia.seljup.SeleniumJupiterException;
import io.github.bonigarcia.seljup.config.Config;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelenoidConfig {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    DockerBrowserConfig browsers;
    Config config;

    public SelenoidConfig() {
    }

    public SelenoidConfig(Config config, BrowserInstance browserInstance, String version) {
        this.config = config;
        if (browserInstance.getBrowserType() != BrowserType.ANDROID) {
            this.browsers = new DockerBrowserConfig(this.getDockerEnvs(), this.getConfig(), browserInstance, version);
        }
    }

    public String getBrowsersJsonAsString() {
        return new GsonBuilder().disableHtmlEscaping().create().toJson((Object)this.browsers);
    }

    public String getImageVersion(BrowserType browser, String version) {
        Map<String, DockerBrowserConfig.Browser> versions = this.browsers.getBrowserConfig(browser).getVersions();
        if (versions.containsKey(version)) {
            return version;
        }
        for (String v : versions.keySet()) {
            if (!v.startsWith(version)) continue;
            return v;
        }
        throw new SeleniumJupiterException("Version " + version + " is not valid for Chrome");
    }

    public String getImageFromVersion(BrowserType browser, String version) {
        return this.browsers.getBrowserConfig(browser).getVersions().get(this.getImageVersion(browser, version)).getImage();
    }

    public String getLatestImage(BrowserInstance browserInstance) {
        return String.format(browserInstance.getDockerImage(), this.getDefaultBrowser(browserInstance.getBrowserType()));
    }

    public String getDefaultBrowser(BrowserType browser) {
        return this.browsers.getBrowserConfig(browser).getDefaultBrowser();
    }

    public List<String> getDockerEnvs() {
        ArrayList<String> envs = new ArrayList<String>();
        envs.add("DOCKER_API_VERSION=" + this.getConfig().getDockerApiVersion());
        envs.add("TZ=" + this.getConfig().getDockerTimeZone());
        envs.add("LANG=" + this.getConfig().getDockerLang());
        if (this.getConfig().isVnc()) {
            envs.add("ENABLE_WINDOW_MANAGER=true");
        }
        return envs;
    }

    public Config getConfig() {
        return this.config;
    }

    public DockerBrowserConfig getDockerBrowserConfig() {
        return this.browsers;
    }
}

