/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup;

import io.github.bonigarcia.seljup.SurefireReports;
import io.github.bonigarcia.seljup.config.Config;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenshotManager {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    ExtensionContext context;
    Config config;

    public ScreenshotManager(ExtensionContext context, Config config) {
        this.context = context;
        this.config = config;
    }

    boolean isScreenshotRequired() {
        Optional executionException = this.context.getExecutionException();
        String screenshotAtTheEnd = this.getConfig().getScreenshotAtTheEndOfTests();
        return screenshotAtTheEnd.equalsIgnoreCase("true") || executionException.isPresent() && screenshotAtTheEnd.equalsIgnoreCase("whenfailure");
    }

    void makeScreenshot(WebDriver driver, String fileName) {
        if (this.isScreenshotRequired() && driver != null && fileName != null) {
            String screenshotFormat;
            switch (screenshotFormat = this.getConfig().getScreenshotFormat()) {
                case "png": {
                    this.logFileScreenshot(driver, fileName);
                    break;
                }
                case "base64": {
                    this.logBase64Screenshot(driver, fileName);
                    break;
                }
                case "base64andpng": {
                    this.logBase64Screenshot(driver, fileName);
                    this.logFileScreenshot(driver, fileName);
                    break;
                }
                default: {
                    this.log.warn("Invalid screenshot format {}", (Object)screenshotFormat);
                }
            }
        }
    }

    void logBase64Screenshot(WebDriver driver, String fileName) {
        try {
            String screenshotBase64 = (String)((TakesScreenshot)driver).getScreenshotAs(OutputType.BASE64);
            this.log.info("Screenshot (in Base64) at the end of {} (copy&paste this string as URL in browser to watch it):\r\ndata:image/png;base64,{}", (Object)fileName, (Object)screenshotBase64);
        }
        catch (Exception e) {
            this.log.trace("Exception getting screenshot in Base64", (Throwable)e);
        }
    }

    void logFileScreenshot(WebDriver driver, String fileName) {
        this.log.trace("Creating screenshot for {} in {}", (Object)driver, (Object)fileName);
        try {
            File screenshotFile = (File)((TakesScreenshot)driver).getScreenshotAs(OutputType.FILE);
            String outputFolder = SurefireReports.getOutputFolder(this.context, this.getConfig().getOutputFolder());
            File destFile = new File(outputFolder, fileName + ".png");
            if (destFile.exists()) {
                destFile = new File(outputFolder, fileName + "_" + System.nanoTime() + ".png");
            }
            FileUtils.copyFile((File)screenshotFile, (File)destFile);
        }
        catch (Exception e) {
            this.log.trace("Exception getting screenshot as file", (Throwable)e);
        }
    }

    Config getConfig() {
        return this.config;
    }
}

