/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup.handler;

import com.codeborne.selenide.SelenideDriver;
import com.google.common.base.Strings;
import com.google.gson.GsonBuilder;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.PortBinding;
import io.appium.java_client.android.AndroidDriver;
import io.github.bonigarcia.seljup.AnnotationsReader;
import io.github.bonigarcia.seljup.BrowserInstance;
import io.github.bonigarcia.seljup.BrowserType;
import io.github.bonigarcia.seljup.CloudType;
import io.github.bonigarcia.seljup.DockerBrowser;
import io.github.bonigarcia.seljup.DockerContainer;
import io.github.bonigarcia.seljup.DockerService;
import io.github.bonigarcia.seljup.InternalPreferences;
import io.github.bonigarcia.seljup.SeleniumJupiterException;
import io.github.bonigarcia.seljup.SelenoidConfig;
import io.github.bonigarcia.seljup.SurefireReports;
import io.github.bonigarcia.seljup.WebDriverCreator;
import io.github.bonigarcia.seljup.config.Config;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.opera.OperaOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerDriverHandler {
    static final String ALL_IPV4_ADDRESSES = "0.0.0.0";
    static final String LATEST = "latest";
    static final String BETA = "beta";
    static final String BROWSER = "browser";
    static final String CHROME = "chrome";
    static final String OPERA_NAME = "operablink";
    static final int APPIUM_MIN_PING_SEC = 5;
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    Config config;
    DockerService dockerService;
    SelenoidConfig selenoidConfig;
    Map<String, DockerContainer> containerMap;
    Map<String, String[]> finalizerCommandMap;
    File recordingFile;
    String name;
    File hostVideoFolder;
    ExtensionContext context;
    Parameter parameter;
    Optional<Object> testInstance;
    AnnotationsReader annotationsReader;
    String index;
    String androidNoVncUrl;
    List<File> filesInVideoFolder;
    String browserName;
    WebDriverCreator webDriverCreator;
    URL hubUrl;
    File hostAndroidLogsFolder;
    URL remoteUrl;
    String browserVersion;

    public DockerDriverHandler(Config config, BrowserInstance browserInstance, String version, InternalPreferences preferences) {
        this.config = config;
        this.selenoidConfig = new SelenoidConfig(config, browserInstance, version);
        this.dockerService = new DockerService(config, preferences);
        this.containerMap = new LinkedHashMap<String, DockerContainer>();
        this.finalizerCommandMap = new LinkedHashMap<String, String[]>();
        this.testInstance = Optional.empty();
        this.browserVersion = version;
    }

    public DockerDriverHandler(ExtensionContext context, Parameter parameter, Optional<Object> testInstance, AnnotationsReader annotationsReader, Map<String, DockerContainer> containerMap, DockerService dockerService, Config config, BrowserInstance browserInstance, String version) {
        this.context = context;
        this.parameter = parameter;
        this.testInstance = testInstance;
        this.annotationsReader = annotationsReader;
        this.containerMap = containerMap;
        this.finalizerCommandMap = new LinkedHashMap<String, String[]>();
        this.dockerService = dockerService;
        this.config = config;
        this.selenoidConfig = new SelenoidConfig(this.getConfig(), browserInstance, version);
        this.browserVersion = version;
    }

    public WebDriver resolve(DockerBrowser dockerBrowser) {
        BrowserType browserType = dockerBrowser.type();
        CloudType cloudType = dockerBrowser.cloud();
        BrowserInstance browserInstance = new BrowserInstance(this.config, this.annotationsReader, browserType, cloudType, Optional.ofNullable(dockerBrowser.browserName()), Optional.ofNullable(dockerBrowser.volumes()));
        String version = dockerBrowser.version();
        String deviceName = dockerBrowser.deviceName();
        String url = dockerBrowser.url();
        return this.resolve(browserInstance, version, deviceName, url, true);
    }

    public WebDriver resolve(BrowserInstance browserInstance, String version, String deviceName, String url, boolean createWebDriver) {
        BrowserType browserType = browserInstance.getBrowserType();
        try {
            if (url != null && !url.isEmpty()) {
                this.remoteUrl = new URL(url);
                this.dockerService.updateDockerClient(url);
            }
            if (this.getConfig().isRecording() || this.getConfig().isRecordingWhenFailure()) {
                this.hostVideoFolder = new File(SurefireReports.getOutputFolder(this.context, this.getConfig().getOutputFolder()));
            }
            WebDriver webdriver = browserType == BrowserType.ANDROID ? this.getDriverForAndroid(browserInstance, version, deviceName) : this.getDriverForBrowser(browserInstance, version, createWebDriver);
            return webdriver;
        }
        catch (Exception e) {
            String errorMessage = String.format("Exception resolving driver in Docker (%s %s)", new Object[]{browserType, version});
            throw new SeleniumJupiterException(errorMessage, e);
        }
    }

    private boolean isAndroidLogging() {
        boolean androidLogging = this.getConfig().isAndroidLogging();
        if (androidLogging) {
            String dateTime = DateTimeFormatter.ofPattern("uuuu-MM-dd--HH-mm-ss").format(LocalDateTime.now());
            String logsFolder = this.getConfig().getAndroidLogsFolder();
            Path path = Paths.get(SurefireReports.getOutputFolder(this.context, this.getConfig().getOutputFolder()), logsFolder, dateTime);
            try {
                Files.createDirectories(path, new FileAttribute[0]);
                this.hostAndroidLogsFolder = path.toFile();
                this.log.debug("Android logs will be stored in {}", (Object)this.hostAndroidLogsFolder);
            }
            catch (IOException e) {
                this.log.warn("Failed to create directories for Android logs {}", (Object)path.toAbsolutePath(), (Object)e);
                androidLogging = false;
            }
        }
        return androidLogging;
    }

    private WebDriver getDriverForBrowser(BrowserInstance browserInstance, String version, boolean createWebDriver) throws IllegalAccessException, IOException, DockerException, InterruptedException {
        String imageVersion;
        boolean enableVnc = this.getConfig().isVnc();
        DesiredCapabilities capabilities = this.getCapabilities(browserInstance, enableVnc);
        BrowserType browserType = browserInstance.getBrowserType();
        String versionFromLabel = version;
        if (version != null && !version.isEmpty() && !version.equalsIgnoreCase(LATEST)) {
            if (version.startsWith("latest-")) {
                versionFromLabel = this.selenoidConfig.getDockerBrowserConfig().getVersion();
            }
            if (!(imageVersion = this.selenoidConfig.getImageVersion(browserType, versionFromLabel)).equalsIgnoreCase(BETA)) {
                capabilities.setCapability("version", imageVersion);
            }
        } else {
            imageVersion = this.selenoidConfig.getDefaultBrowser(browserType);
        }
        boolean seleniumServerUrlAvailable = this.setHubUrl(browserInstance, versionFromLabel);
        if (!createWebDriver) {
            return null;
        }
        if (this.webDriverCreator == null) {
            this.webDriverCreator = new WebDriverCreator(this.getConfig());
        }
        this.log.trace("Creating webdriver for {} {} ({})", new Object[]{browserType, version, this.hubUrl});
        WebDriver webdriver = this.webDriverCreator.createRemoteWebDriver(this.hubUrl, (Capabilities)capabilities);
        SessionId sessionId = ((RemoteWebDriver)webdriver).getSessionId();
        this.updateName(browserType, imageVersion, webdriver);
        if (enableVnc && !seleniumServerUrlAvailable) {
            String selenoidHost = this.hubUrl.getHost();
            int selenoidPort = this.hubUrl.getPort();
            String novncUrl = this.getNoVncUrl(selenoidHost, selenoidPort, sessionId.toString(), this.getConfig().getSelenoidVncPassword());
            this.logSessionId(sessionId);
            this.logNoVncUrl(novncUrl);
            String vncExport = this.getConfig().getVncExport();
            this.log.trace("Exporting VNC URL as Java property {}", (Object)vncExport);
            System.setProperty(vncExport, novncUrl);
            if (this.getConfig().isVncRedirectHtmlPage()) {
                String outputFolder = SurefireReports.getOutputFolder(this.context, this.getConfig().getOutputFolder());
                String vncHtmlPage = String.format("<!DOCTYPE html>\n<html>\n<head>\n<meta http-equiv=\"refresh\" content=\"0; url=%s\">\n</head>\n<body>\n</body>\n</html>", novncUrl);
                String htmlPageName = this.name + ".html";
                this.log.debug("Redirecting VNC URL to HTML page at {}/{}", (Object)outputFolder, (Object)htmlPageName);
                Files.write(Paths.get(outputFolder, htmlPageName), vncHtmlPage.getBytes(), new OpenOption[0]);
            }
        }
        if (this.getConfig().isRecording() || this.getConfig().isRecordingWhenFailure()) {
            this.recordingFile = new File(this.hostVideoFolder, sessionId + ".mp4");
        }
        return webdriver;
    }

    private boolean setHubUrl(BrowserInstance browserInstance, String versionFromLabel) throws MalformedURLException, DockerException, InterruptedException {
        String seleniumServerUrl = this.getConfig().getSeleniumServerUrl();
        boolean seleniumServerUrlAvailable = seleniumServerUrl != null && !seleniumServerUrl.isEmpty();
        this.hubUrl = new URL(seleniumServerUrlAvailable ? seleniumServerUrl : this.startDockerBrowser(browserInstance, versionFromLabel));
        if (this.remoteUrl != null) {
            try {
                String remoteHost = this.remoteUrl.getHost();
                this.log.trace("Converting {} to use {}", (Object)this.hubUrl, (Object)remoteHost);
                URI uri = new URI(this.hubUrl.toString());
                this.hubUrl = new URI(uri.getScheme(), null, remoteHost, uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment()).toURL();
            }
            catch (URISyntaxException e) {
                this.log.warn("Exception converting URL {}", (Object)this.remoteUrl, (Object)e);
            }
        }
        return seleniumServerUrlAvailable;
    }

    private void logSessionId(SessionId sessionId) {
        this.log.info("Session id {}", (Object)sessionId);
    }

    private void logNoVncUrl(String novncUrl) {
        this.log.info("VNC URL (copy and paste in a browser navigation bar to interact with remote session)");
        this.log.info("{}", (Object)novncUrl);
    }

    private WebDriver getDriverForAndroid(BrowserInstance browserInstance, String version, String deviceName) throws DockerException, InterruptedException, IOException, IllegalAccessException {
        int androidAppiumPingPeriodSec;
        if (this.getConfig().isRecording() || this.getConfig().isRecordingWhenFailure()) {
            this.filesInVideoFolder = Arrays.asList(this.hostVideoFolder.listFiles());
        }
        if (version == null || version.isEmpty()) {
            version = this.getConfig().getAndroidDefaultVersion();
        }
        String deviceNameCapability = deviceName != null && !deviceName.isEmpty() ? deviceName : this.getConfig().getAndroidDeviceName();
        CloudType cloudType = browserInstance.getCloudType();
        String appiumUrl = this.startAndroidBrowser(version, deviceNameCapability, browserInstance.getBrowserName(), cloudType);
        DesiredCapabilities capabilities = this.getCapabilitiesForAndroid(browserInstance, deviceNameCapability);
        capabilities.setBrowserName(this.browserName);
        this.log.info("Appium URL in Android device: {}", (Object)appiumUrl);
        this.log.info("Android device name: {} -- Browser: {}", (Object)deviceNameCapability, (Object)this.browserName);
        int androidStartupTimeoutSec = this.getConfig().getAndroidDeviceStartupTimeoutSec();
        if (0 < androidStartupTimeoutSec) {
            this.log.debug("Waiting for Android device to start for {} seconds", (Object)androidStartupTimeoutSec);
            Thread.sleep(TimeUnit.SECONDS.toMillis(androidStartupTimeoutSec));
        }
        if ((androidAppiumPingPeriodSec = this.getConfig().getAndroidAppiumPingPeriodSec().intValue()) < 5) {
            androidAppiumPingPeriodSec = 5;
        }
        this.log.debug("Waiting for Appium creates session in Android device ... this might take long, please wait (retries each {} seconds)", (Object)androidAppiumPingPeriodSec);
        AndroidDriver androidDriver = null;
        int androidDeviceTimeoutSec = this.getConfig().getAndroidDeviceTimeoutSec();
        long endTimeMillis = System.currentTimeMillis() + (long)(androidDeviceTimeoutSec * 1000);
        do {
            try {
                androidDriver = new AndroidDriver(new URL(appiumUrl), (Capabilities)capabilities);
            }
            catch (Exception e) {
                this.checkAndroidException(androidAppiumPingPeriodSec, androidDeviceTimeoutSec, endTimeMillis, e);
            }
        } while (androidDriver == null);
        this.log.info("Android device ready {}", (Object)androidDriver);
        this.updateName(browserInstance.getBrowserType(), version, (WebDriver)androidDriver);
        if (this.getConfig().isVnc()) {
            this.logSessionId(androidDriver.getSessionId());
            this.logNoVncUrl(this.androidNoVncUrl);
        }
        return androidDriver;
    }

    private void checkAndroidException(int androidAppiumPingPeriodSec, int androidDeviceTimeoutSec, long endTimeMillis, Exception e) throws InterruptedException {
        if (System.currentTimeMillis() > endTimeMillis) {
            throw new SeleniumJupiterException("Timeout (" + androidDeviceTimeoutSec + " seconds) waiting for Android device in Docker");
        }
        String errorMessage = this.getErrorMessage(e);
        this.log.debug("Android device not ready: {}", (Object)errorMessage);
        if (errorMessage.contains("Could not find package")) {
            throw new SeleniumJupiterException(errorMessage);
        }
        Thread.sleep(TimeUnit.SECONDS.toMillis(androidAppiumPingPeriodSec));
    }

    private String getErrorMessage(Exception e) {
        String errorMessage = ExceptionUtils.getRootCause((Throwable)e).getMessage();
        int i = errorMessage.indexOf(10);
        if (i != -1) {
            errorMessage = errorMessage.substring(0, i);
        }
        return errorMessage;
    }

    private void updateName(BrowserType browser, String imageVersion, WebDriver webdriver) {
        if (this.parameter != null) {
            String parameterName = this.parameter.getName();
            this.name = parameterName + "_" + (Object)((Object)browser) + "_" + imageVersion + "_" + ((RemoteWebDriver)webdriver).getSessionId();
            Optional testMethod = this.context.getTestMethod();
            if (testMethod.isPresent()) {
                this.name = ((Method)testMethod.get()).getName() + "_" + this.name;
            }
            if (this.index != null) {
                this.name = this.name + this.index;
            }
        } else {
            this.name = browser.name().toLowerCase();
        }
    }

    private DesiredCapabilities getCapabilities(BrowserInstance browserInstance, boolean enableVnc) throws IllegalAccessException, IOException {
        DesiredCapabilities capabilities = browserInstance.getCapabilities();
        if (enableVnc) {
            capabilities.setCapability("enableVNC", true);
            capabilities.setCapability("screenResolution", this.getConfig().getVncScreenResolution());
        }
        if (this.getConfig().isRecording() || this.getConfig().isRecordingWhenFailure()) {
            capabilities.setCapability("enableVideo", true);
            capabilities.setCapability("videoScreenSize", this.getConfig().getRecordingVideoScreenSize());
            capabilities.setCapability("videoFrameRate", (Object)this.getConfig().getRecordingVideoFrameRate());
        }
        Optional<DesiredCapabilities> optionalCapabilities = this.annotationsReader != null ? this.annotationsReader.getCapabilities(this.parameter, this.testInstance) : Optional.of(new DesiredCapabilities());
        MutableCapabilities options = browserInstance.getDriverHandler().getOptions(this.parameter, this.testInstance);
        if (browserInstance.getBrowserType() == BrowserType.OPERA && this.browserVersion.equals("62.0")) {
            String operaBinaryPathLinux = this.getConfig().getOperaBinaryPathLinux();
            ((OperaOptions)options).setBinary(operaBinaryPathLinux);
            ChromeOptions chromeOptions = new ChromeOptions();
            chromeOptions.setBinary(operaBinaryPathLinux);
            OperaOptions operaOptions = new OperaOptions().merge((Capabilities)chromeOptions);
            operaOptions.setCapability("browserName", OPERA_NAME);
            options.merge((Capabilities)operaOptions);
            this.log.trace("Opera options: {}", (Object)options);
        }
        if (optionalCapabilities.isPresent()) {
            options.merge((Capabilities)optionalCapabilities.get());
        }
        capabilities.setCapability(browserInstance.getOptionsKey(), (Object)options);
        this.log.trace("Using {}", (Object)capabilities);
        return capabilities;
    }

    private DesiredCapabilities getCapabilitiesForAndroid(BrowserInstance browserInstance, String deviceNameCapability) throws IllegalAccessException, IOException {
        DesiredCapabilities capabilities = browserInstance.getCapabilities();
        capabilities.setCapability("browserName", this.browserName);
        capabilities.setCapability("deviceName", deviceNameCapability);
        Optional<DesiredCapabilities> optionalCapabilities = this.annotationsReader != null ? this.annotationsReader.getCapabilities(this.parameter, this.testInstance) : Optional.of(new DesiredCapabilities());
        MutableCapabilities options = browserInstance.getDriverHandler().getOptions(this.parameter, this.testInstance);
        if (optionalCapabilities.isPresent()) {
            options.merge((Capabilities)optionalCapabilities.get());
        }
        capabilities.setCapability("goog:chromeOptions", (Object)options);
        this.log.trace("Using {}", (Object)capabilities);
        return capabilities;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        try {
            boolean recordingWhenFailure = this.getConfig().isRecordingWhenFailure();
            boolean recording = this.getConfig().isRecording();
            if (recording || recordingWhenFailure) {
                this.waitForRecording();
                boolean isFailed = this.context.getExecutionException().isPresent();
                if (recordingWhenFailure && !isFailed) {
                    this.log.trace("Deleting {} (recordingWhenFailure={})", (Object)this.recordingFile, (Object)recordingWhenFailure);
                    Files.delete(this.recordingFile.toPath());
                }
            }
            String vncExport = this.getConfig().getVncExport();
            if (this.getConfig().isVnc() && System.getProperty(vncExport) != null) {
                this.log.trace("Clearing Java property {}", (Object)vncExport);
                System.clearProperty(vncExport);
            }
        }
        catch (Exception e) {
            this.log.warn("Exception waiting for recording {}", (Object)e.getMessage());
        }
        finally {
            this.finaliceContainers();
            this.stopContainers();
        }
    }

    private void stopContainers() {
        if (this.containerMap != null && !this.containerMap.isEmpty() && this.dockerService != null) {
            int numContainers = this.containerMap.size();
            this.log.trace("There are {} container(s): {}", (Object)numContainers, this.containerMap);
            if (numContainers > 0) {
                ExecutorService executorService = Executors.newFixedThreadPool(numContainers);
                CountDownLatch latch = new CountDownLatch(numContainers);
                for (Map.Entry<String, DockerContainer> entry : this.containerMap.entrySet()) {
                    executorService.submit(() -> {
                        this.dockerService.stopAndRemoveContainer(((DockerContainer)entry.getValue()).getContainerId(), (String)entry.getKey());
                        latch.countDown();
                    });
                }
                this.containerMap.clear();
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                executorService.shutdown();
            }
        }
    }

    private void finaliceContainers() {
        if (this.finalizerCommandMap != null && !this.finalizerCommandMap.isEmpty() && this.dockerService != null) {
            for (Map.Entry<String, String[]> entry : this.finalizerCommandMap.entrySet()) {
                String container = entry.getKey();
                String[] command = entry.getValue();
                try {
                    this.log.trace("Executing {} in {}", (Object)command, (Object)container);
                    this.dockerService.execCommandInContainer(container, command);
                }
                catch (Exception e) {
                    this.log.warn("Exception executing {} in {}", new Object[]{command, container, e});
                }
            }
        }
    }

    public void close() {
        this.dockerService.close();
    }

    public String startAndroidBrowser(String version, String deviceName, String browserNameSetByUser, CloudType cloudType) throws DockerException, InterruptedException {
        String androidImage;
        if (!SystemUtils.IS_OS_LINUX) {
            throw new SeleniumJupiterException("Android devices are only supported in Linux hosts");
        }
        if (cloudType == CloudType.NONE) {
            String versionTag;
            String apiLevel;
            switch (version) {
                case "5.0.1": 
                case "latest-7": {
                    androidImage = this.getConfig().getAndroidImage501();
                    apiLevel = "21";
                    this.browserName = BROWSER;
                    versionTag = "37.0";
                    break;
                }
                case "5.1.1": 
                case "latest-6": {
                    androidImage = this.getConfig().getAndroidImage511();
                    apiLevel = "22";
                    this.browserName = BROWSER;
                    versionTag = "39.0";
                    break;
                }
                case "6.0": 
                case "latest-5": {
                    androidImage = this.getConfig().getAndroidImage60();
                    apiLevel = "23";
                    this.browserName = BROWSER;
                    versionTag = "44.0";
                    break;
                }
                case "7.0": 
                case "latest-4": {
                    androidImage = this.getConfig().getAndroidImage701();
                    apiLevel = "24";
                    this.browserName = CHROME;
                    versionTag = "51.0";
                    break;
                }
                case "7.1.1": 
                case "latest-3": {
                    androidImage = this.getConfig().getAndroidImage711();
                    apiLevel = "25";
                    this.browserName = CHROME;
                    versionTag = "55.0";
                    break;
                }
                case "8.0": 
                case "latest-2": {
                    androidImage = this.getConfig().getAndroidImage80();
                    apiLevel = "26";
                    this.browserName = CHROME;
                    versionTag = "58.0";
                    break;
                }
                case "8.1": 
                case "latest-1": {
                    androidImage = this.getConfig().getAndroidImage81();
                    apiLevel = "27";
                    this.browserName = CHROME;
                    versionTag = "61.0";
                    break;
                }
                case "9.0": 
                case "latest": {
                    androidImage = this.getConfig().getAndroidImage90();
                    apiLevel = "28";
                    this.browserName = CHROME;
                    versionTag = "66.0";
                    break;
                }
                default: {
                    throw new SeleniumJupiterException("Version " + version + " not valid for Android devices");
                }
            }
            this.log.info("Starting {} {} in Android {} (API level {})", new Object[]{this.browserName, versionTag, version, apiLevel});
        } else {
            androidImage = this.getConfig().getAndroidImageGenymotion();
            this.browserName = browserNameSetByUser;
        }
        this.dockerService.pullImage(androidImage);
        DockerContainer androidContainer = this.startAndroidContainer(androidImage, deviceName, cloudType);
        return androidContainer.getContainerUrl();
    }

    public String startDockerBrowser(BrowserInstance browserInstance, String version) throws DockerException, InterruptedException {
        String browserImage;
        BrowserType browserType = browserInstance.getBrowserType();
        if (version == null || version.isEmpty() || version.equalsIgnoreCase(LATEST)) {
            this.log.info("Using {} version {} (latest)", (Object)browserType, (Object)this.selenoidConfig.getDefaultBrowser(browserType));
            browserImage = this.selenoidConfig.getLatestImage(browserInstance);
        } else {
            this.log.info("Using {} version {}", (Object)browserType, (Object)version);
            browserImage = this.selenoidConfig.getImageFromVersion(browserType, version);
        }
        if (browserType != BrowserType.EDGE && browserType != BrowserType.IEXPLORER) {
            this.dockerService.pullImage(browserImage);
        }
        DockerContainer selenoidContainer = this.startSelenoidContainer();
        return selenoidContainer.getContainerUrl();
    }

    public DockerContainer startSelenoidContainer() throws DockerException, InterruptedException {
        DockerContainer selenoidContainer;
        boolean recording;
        String selenoidImage = this.getConfig().getSelenoidImage();
        boolean bl = recording = this.getConfig().isRecording() || this.getConfig().isRecordingWhenFailure();
        if (this.containerMap.containsKey(selenoidImage)) {
            this.log.trace("Selenoid container already available");
            selenoidContainer = this.containerMap.get(selenoidImage);
        } else {
            String defaultSelenoidPort;
            this.dockerService.pullImage(selenoidImage);
            String recordingImage = this.getConfig().getRecordingImage();
            if (recording) {
                this.dockerService.pullImage(recordingImage);
            }
            HashMap<String, List<PortBinding>> portBindings = new HashMap<String, List<PortBinding>>();
            String internalSelenoidPort = defaultSelenoidPort = this.getConfig().getSelenoidPort();
            portBindings.put(internalSelenoidPort, Arrays.asList(PortBinding.randomPort((String)ALL_IPV4_ADDRESSES)));
            String defaultSocket = this.dockerService.getDockerDefaultSocket();
            ArrayList<String> binds = new ArrayList<String>();
            binds.add(defaultSocket + ":" + defaultSocket);
            if (recording) {
                binds.add(this.getDockerPath(this.hostVideoFolder) + ":/opt/selenoid/video");
            }
            List<String> entryPoint = Arrays.asList("");
            String internalBrowserPort = this.getConfig().getSelenoidPort();
            String browsersJson = this.selenoidConfig.getBrowsersJsonAsString();
            String browserTimeout = this.getConfig().getBrowserSessionTimeoutDuration();
            String network = this.getConfig().getDockerNetwork();
            String dockerStartupTimeout = this.getConfig().getDockerStartupTimeoutDuration();
            List<String> cmd = Arrays.asList("sh", "-c", "mkdir -p /etc/selenoid/; echo '" + browsersJson + "' > /etc/selenoid/browsers.json; /usr/bin/selenoid -listen :" + internalBrowserPort + " -service-startup-timeout " + dockerStartupTimeout + " -conf /etc/selenoid/browsers.json -video-output-dir /opt/selenoid/video/ -timeout " + browserTimeout + " -container-network " + network + " -limit " + this.getDockerBrowserCount());
            List<String> envs = this.selenoidConfig.getDockerEnvs();
            if (recording) {
                envs.add("OVERRIDE_VIDEO_OUTPUT_DIR=" + this.getDockerPath(this.hostVideoFolder));
            }
            DockerContainer.DockerBuilder dockerBuilder = DockerContainer.dockerBuilder(selenoidImage).portBindings(portBindings).binds(binds).cmd(cmd).entryPoint(entryPoint).envs(envs).network(network);
            selenoidContainer = dockerBuilder.build();
            this.containerMap.put(selenoidImage, selenoidContainer);
            String containerId = this.dockerService.startContainer(selenoidContainer);
            selenoidContainer.setContainerId(containerId);
            String selenoidHost = this.dockerService.getHost(containerId, network);
            String selenoidPort = this.dockerService.getBindPort(containerId, internalSelenoidPort + "/tcp");
            String selenoidUrl = String.format("http://%s:%s/wd/hub", selenoidHost, selenoidPort);
            selenoidContainer.setContainerUrl(selenoidUrl);
            this.log.trace("Selenium server URL {}", (Object)selenoidUrl);
        }
        return selenoidContainer;
    }

    public DockerContainer startAndroidContainer(String androidImage, String deviceName, CloudType cloudType) throws DockerException, InterruptedException {
        DockerContainer androidContainer;
        if (this.containerMap.containsKey(androidImage)) {
            this.log.trace("Android container already available");
            androidContainer = this.containerMap.get(androidImage);
        } else {
            boolean useGenymotion;
            this.dockerService.pullImage(androidImage);
            HashMap<String, List<PortBinding>> portBindings = new HashMap<String, List<PortBinding>>();
            String internalAppiumPort = this.getConfig().getAndroidAppiumPort();
            portBindings.put(internalAppiumPort, Arrays.asList(PortBinding.randomPort((String)ALL_IPV4_ADDRESSES)));
            String internalNoVncPort = this.getConfig().getAndroidNoVncPort();
            portBindings.put(internalNoVncPort, Arrays.asList(PortBinding.randomPort((String)ALL_IPV4_ADDRESSES)));
            boolean recording = this.getConfig().isRecording() || this.getConfig().isRecordingWhenFailure();
            ArrayList<String> binds = new ArrayList<String>();
            if (recording) {
                binds.add(this.getDockerPath(this.hostVideoFolder) + ":/tmp/video");
            }
            if (this.isAndroidLogging()) {
                binds.add(this.getDockerPath(this.hostAndroidLogsFolder) + ":/var/log/supervisor");
            }
            String network = this.getConfig().getDockerNetwork();
            List<String> envs = this.getAndroidEnvs(deviceName, cloudType, recording);
            DockerContainer.DockerBuilder dockerBuilder = DockerContainer.dockerBuilder(androidImage).portBindings(portBindings).binds(binds).envs(envs).network(network).privileged();
            String androidGenymotionDeviceName = this.getConfig().getAndroidGenymotionDeviceName();
            boolean bl = useGenymotion = cloudType == CloudType.GENYMOTION_SAAS && !Strings.isNullOrEmpty((String)androidGenymotionDeviceName);
            if (useGenymotion) {
                this.getGenymotionContainer(dockerBuilder, androidGenymotionDeviceName);
            }
            androidContainer = dockerBuilder.build();
            String containerId = this.dockerService.startContainer(androidContainer);
            if (useGenymotion) {
                String[] disposeDeviceCommand = new String[]{"gmtool", "--cloud", "admin", "stopdisposable", androidGenymotionDeviceName};
                this.finalizerCommandMap.put(containerId, disposeDeviceCommand);
            }
            String androidHost = this.dockerService.getHost(containerId, network);
            String androidPort = this.dockerService.getBindPort(containerId, internalAppiumPort + "/tcp");
            String appiumUrl = String.format("http://%s:%s/wd/hub", androidHost, androidPort);
            androidContainer.setContainerId(containerId);
            androidContainer.setContainerUrl(appiumUrl);
            String androidNoVncPort = this.dockerService.getBindPort(containerId, internalNoVncPort + "/tcp");
            this.androidNoVncUrl = String.format("http://%s:%s/", androidHost, androidNoVncPort);
            this.containerMap.put(androidImage, androidContainer);
        }
        return androidContainer;
    }

    private void getGenymotionContainer(DockerContainer.DockerBuilder dockerBuilder, String androidGenymotionDeviceName) {
        String androidGenymotionScreenSize;
        String androidGenymotionAndroidApi;
        Devices[] devices = new Devices[1];
        String androidGenymotionTemplate = this.getConfig().getAndroidGenymotionTemplate();
        String androidGenymotionAndroidVersion = this.getConfig().getAndroidGenymotionAndroidVersion();
        if (!Strings.isNullOrEmpty((String)androidGenymotionAndroidVersion)) {
            androidGenymotionTemplate = androidGenymotionTemplate + " - " + androidGenymotionAndroidVersion;
        }
        if (!Strings.isNullOrEmpty((String)(androidGenymotionAndroidApi = this.getConfig().getAndroidGenymotionAndroidApi()))) {
            androidGenymotionTemplate = androidGenymotionTemplate + " - API " + androidGenymotionAndroidApi;
        }
        if (!Strings.isNullOrEmpty((String)(androidGenymotionScreenSize = this.getConfig().getAndroidGenymotionScreenSize()))) {
            androidGenymotionTemplate = androidGenymotionTemplate + " - " + androidGenymotionScreenSize;
        }
        this.log.debug("Using Genymotion device name: {}, template: {}", (Object)androidGenymotionDeviceName, (Object)androidGenymotionTemplate);
        devices[0] = new Devices(androidGenymotionDeviceName, androidGenymotionTemplate);
        String deviceJson = new GsonBuilder().disableHtmlEscaping().create().toJson((Object)devices);
        String chromedriverVersion = this.getConfig().getAndroidGenymotionChromedriver();
        if (Strings.isNullOrEmpty((String)chromedriverVersion) && !Strings.isNullOrEmpty((String)androidGenymotionAndroidVersion)) {
            switch (androidGenymotionAndroidVersion) {
                case "5.0.1": {
                    chromedriverVersion = "2.21";
                    break;
                }
                case "5.1.1": {
                    chromedriverVersion = "2.13";
                    break;
                }
                case "6.0": 
                case "6.0.0": {
                    chromedriverVersion = "2.18";
                    break;
                }
                case "7.0": 
                case "7.0.0": {
                    chromedriverVersion = "2.23";
                    break;
                }
                case "7.1.1": {
                    chromedriverVersion = "2.28";
                    break;
                }
                case "8.0": 
                case "8.0.0": {
                    chromedriverVersion = "2.31";
                    break;
                }
                case "8.1": 
                case "8.1.0": {
                    chromedriverVersion = "2.33";
                    break;
                }
                case "9.0": 
                case "9.0.0": {
                    chromedriverVersion = "2.40";
                    break;
                }
                default: {
                    chromedriverVersion = "";
                }
            }
        }
        String downloadChromeDriverScript = "";
        if (!Strings.isNullOrEmpty((String)chromedriverVersion)) {
            this.log.debug("Chromedriver {} is downloaded inside Genymotion container", (Object)chromedriverVersion);
            downloadChromeDriverScript = "wget https://chromedriver.storage.googleapis.com/" + chromedriverVersion + "/chromedriver_linux64.zip; unzip chromedriver_linux64.zip; cp chromedriver /usr/lib/node_modules/appium/node_modules/appium-chromedriver/chromedriver/linux/chromedriver_64; rm chromedriver*; ";
        }
        this.log.trace("Devices.json = {}", (Object)deviceJson);
        List<String> cmd = Arrays.asList("sh", "-c", "mkdir /root/tmp; echo '" + deviceJson + "' > /root/tmp/devices.json; " + downloadChromeDriverScript + "./geny_start.sh");
        dockerBuilder.cmd(cmd);
    }

    private List<String> getAndroidEnvs(String deviceName, CloudType cloudType, boolean recording) {
        ArrayList<String> envs = new ArrayList<String>();
        String screenWidth = this.getConfig().getAndroidScreenWidth();
        String screenHeigth = this.getConfig().getAndroidScreenHeigth();
        String screenDepth = this.getConfig().getAndroidScreenDepth();
        envs.add("DEVICE=" + deviceName);
        envs.add("SCREEN_WIDTH=" + screenWidth);
        envs.add("SCREEN_HEIGHT=" + screenHeigth);
        envs.add("SCREEN_DEPTH=" + screenDepth);
        envs.add("APPIUM=true");
        List<String> proxyEnvVars = Arrays.asList("HTTP_PROXY", "HTTPS_PROXY", "NO_PROXY", "http_proxy", "https_proxy", "no_proxy");
        proxyEnvVars.stream().filter(envName -> StringUtils.isNotBlank((CharSequence)System.getenv(envName))).forEach(envName -> envs.add(envName + "=" + System.getenv(envName)));
        if (recording) {
            envs.add("AUTO_RECORD=true");
        } else {
            envs.add("AUTO_RECORD=false");
        }
        if (cloudType == CloudType.GENYMOTION_SAAS) {
            envs.add("TYPE=SaaS");
            envs.add("USER=" + this.getConfig().getAndroidGenymotionUser());
            envs.add("PASS=" + this.getConfig().getAndroidGenymotionPassword());
            envs.add("LICENSE=" + this.getConfig().getAndroidGenymotionLicense());
        }
        return envs;
    }

    private int getDockerBrowserCount() {
        int count = 0;
        if (this.context != null) {
            Optional testClass = this.context.getTestClass();
            if (testClass.isPresent()) {
                Method[] allMethods;
                Constructor<?>[] declaredConstructors;
                for (Constructor<?> constructor : declaredConstructors = ((Class)testClass.get()).getDeclaredConstructors()) {
                    Parameter[] parameters = constructor.getParameters();
                    count += this.getDockerBrowsersInParams(parameters);
                }
                Object[] methods = ((Class)testClass.get()).getMethods();
                Object[] declaredMethods = ((Class)testClass.get()).getDeclaredMethods();
                for (Method method : allMethods = (Method[])ArrayUtils.addAll((Object[])methods, (Object[])declaredMethods)) {
                    Parameter[] parameters = method.getParameters();
                    count += this.getDockerBrowsersInParams(parameters);
                }
            }
        } else {
            count = 1;
        }
        this.log.trace("Number of required Docker browser(s): {}", (Object)count);
        return count;
    }

    private int getDockerBrowsersInParams(Parameter[] parameters) {
        int count = 0;
        for (Parameter param : parameters) {
            DockerBrowser dockerBrowser;
            Class<List> type = param.getType();
            if (WebDriver.class.isAssignableFrom(type) || SelenideDriver.class.isAssignableFrom(type)) {
                ++count;
                continue;
            }
            if (!type.isAssignableFrom(List.class) || (dockerBrowser = param.getAnnotation(DockerBrowser.class)) == null) continue;
            count += dockerBrowser.size();
        }
        return count;
    }

    private String getNoVncUrl(String selenoidHost, int selenoidPort, String sessionId, String novncPassword) throws DockerException, InterruptedException {
        DockerContainer novncContainer = this.startNoVncContainer();
        String novncUrl = novncContainer.getContainerUrl();
        return String.format("%svnc.html?host=%s&port=%d&path=vnc/%s&resize=scale&autoconnect=true&password=%s", novncUrl, selenoidHost, selenoidPort, sessionId, novncPassword);
    }

    public DockerContainer startNoVncContainer() throws DockerException, InterruptedException {
        DockerContainer novncContainer;
        String novncImage = this.getConfig().getNovncImage();
        if (this.containerMap.containsKey(novncImage)) {
            this.log.debug("noVNC container already available");
            novncContainer = this.containerMap.get(novncImage);
        } else {
            this.dockerService.pullImage(novncImage);
            HashMap<String, List<PortBinding>> portBindings = new HashMap<String, List<PortBinding>>();
            String defaultNovncPort = this.getConfig().getNovncPort();
            portBindings.put(defaultNovncPort, Arrays.asList(PortBinding.randomPort((String)ALL_IPV4_ADDRESSES)));
            String network = this.getConfig().getDockerNetwork();
            novncContainer = DockerContainer.dockerBuilder(novncImage).portBindings(portBindings).network(network).build();
            String containerId = this.dockerService.startContainer(novncContainer);
            String novncHost = this.dockerService.getHost(containerId, network);
            String novncPort = this.dockerService.getBindPort(containerId, defaultNovncPort + "/tcp");
            String novncUrl = String.format("http://%s:%s/", novncHost, novncPort);
            novncContainer.setContainerId(containerId);
            novncContainer.setContainerUrl(novncUrl);
            this.containerMap.put(novncImage, novncContainer);
        }
        return novncContainer;
    }

    private String getDockerPath(File file) {
        String fileString = file.getAbsolutePath();
        if (fileString.contains(":")) {
            fileString = Character.toLowerCase(fileString.charAt(0)) + fileString.substring(1);
            fileString = fileString.replace("\\\\", "/");
            fileString = fileString.replace(":", "");
            fileString = "/" + fileString;
        }
        this.log.trace("The path of file {} in Docker format is {}", (Object)file, (Object)fileString);
        return fileString;
    }

    private void waitForRecording() throws IOException {
        if (this.filesInVideoFolder != null) {
            List<File> newFilesInVideoFolder = Arrays.asList(this.hostVideoFolder.listFiles());
            Iterator iterator = CollectionUtils.disjunction(this.filesInVideoFolder, newFilesInVideoFolder).iterator();
            while (iterator.hasNext()) {
                String filename = iterator.next().toString();
                if (!filename.endsWith("mp4")) continue;
                this.recordingFile = new File(filename);
                break;
            }
        }
        if (this.recordingFile != null) {
            int dockerWaitTimeoutSec = this.dockerService.getDockerWaitTimeoutSec();
            int dockerPollTimeMs = this.dockerService.getDockerPollTimeMs();
            long timeoutMs = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(dockerWaitTimeoutSec);
            this.log.debug("Waiting for recording to be available");
            while (!this.recordingFile.exists()) {
                if (System.currentTimeMillis() > timeoutMs) {
                    this.log.warn("Timeout of {} seconds waiting for file {}", (Object)dockerWaitTimeoutSec, (Object)this.recordingFile);
                    break;
                }
                this.log.trace("Recording {} not present ... waiting {} ms", (Object)this.recordingFile, (Object)dockerPollTimeMs);
                try {
                    Thread.sleep(dockerPollTimeMs);
                }
                catch (InterruptedException e) {
                    this.log.warn("Interrupted Exception while waiting for container", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            String newRecordingName = this.name + ".mp4";
            this.log.trace("Renaming {} to {}", (Object)this.recordingFile, (Object)newRecordingName);
            Files.move(this.recordingFile.toPath(), this.recordingFile.toPath().resolveSibling(newRecordingName), StandardCopyOption.REPLACE_EXISTING);
            this.recordingFile = new File(newRecordingName);
        }
    }

    public Map<String, DockerContainer> getContainerMap() {
        return this.containerMap;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public Config getConfig() {
        return this.config;
    }

    public URL getHubUrl() {
        return this.hubUrl;
    }

    public class Devices {
        String template;
        String device;

        public Devices(String device, String template) {
            this.device = device;
            this.template = template;
        }
    }
}

