/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup;

import io.github.bonigarcia.seljup.SelenoidApi;
import io.github.bonigarcia.seljup.SelenoidStatus;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Optional;
import okhttp3.OkHttpClient;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

public class SelenoidService {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String CONTAINER = "container=";
    SelenoidApi selenoidApi;

    public SelenoidService(String selenoidUrl) {
        OkHttpClient okHttpClient = new OkHttpClient.Builder().build();
        Retrofit retrofit = new Retrofit.Builder().client(okHttpClient).addCallAdapterFactory((CallAdapter.Factory)RxJavaCallAdapterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).baseUrl(selenoidUrl).build();
        this.selenoidApi = (SelenoidApi)retrofit.create(SelenoidApi.class);
    }

    public Optional<String> getContainerId(WebDriver driver) throws IOException {
        String sessionId;
        Optional<String> output = Optional.empty();
        Response execute = this.selenoidApi.status().execute();
        String browsers = ((SelenoidStatus)execute.body()).getBrowsers();
        int i = browsers.indexOf(sessionId = ((RemoteWebDriver)driver).getSessionId().toString());
        if (i != -1) {
            int j = browsers.indexOf(CONTAINER, i) + CONTAINER.length();
            int k = browsers.indexOf(44, j);
            if (j != -1 && k != -1) {
                String containerId = browsers.substring(j, k);
                output = Optional.of(containerId);
            }
        }
        this.log.trace("Container id for session {} = {}", (Object)sessionId, output);
        return output;
    }
}

