/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup;

import com.google.gson.internal.LinkedTreeMap;
import io.github.bonigarcia.seljup.AnnotationsReader;
import io.github.bonigarcia.seljup.Arguments;
import io.github.bonigarcia.seljup.Binary;
import io.github.bonigarcia.seljup.BrowserType;
import io.github.bonigarcia.seljup.BrowsersTemplate;
import io.github.bonigarcia.seljup.Extensions;
import io.github.bonigarcia.seljup.Options;
import io.github.bonigarcia.seljup.Preferences;
import io.github.bonigarcia.seljup.config.Config;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.File;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.chromium.ChromiumDriver;
import org.openqa.selenium.chromium.ChromiumOptions;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.opera.OperaDriver;
import org.openqa.selenium.opera.OperaOptions;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.safari.SafariOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapabilitiesHandler {
    static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    Config config;
    AnnotationsReader annotationsReader;
    Parameter parameter;
    ExtensionContext extensionContext;
    Optional<BrowsersTemplate.Browser> browser;
    Optional<BrowserType> browserType;
    boolean isGeneric;

    public CapabilitiesHandler(Config config, AnnotationsReader annotationsReader, Parameter parameter, ExtensionContext extensionContext, Optional<BrowsersTemplate.Browser> browser, Optional<BrowserType> browserType, boolean isGeneric) {
        this.config = config;
        this.annotationsReader = annotationsReader;
        this.parameter = parameter;
        this.extensionContext = extensionContext;
        this.browser = browser;
        this.browserType = browserType;
        this.isGeneric = isGeneric;
    }

    public Optional<Capabilities> getCapabilities() {
        Capabilities options;
        Optional<Class<? extends Capabilities>> optionsClass = this.getOptionsClass();
        if (optionsClass.isPresent() && (options = this.getOptions(optionsClass.get())) != null) {
            return Optional.of(options);
        }
        return Optional.empty();
    }

    private Optional<Class<? extends Capabilities>> getOptionsClass() {
        Class<?> type = this.parameter.getType();
        log.trace("Getting capabilities for type={} -- browserType={}", type, this.browserType);
        if (type == ChromeDriver.class || this.browserType.isPresent() && this.browserType.get().isChromeBased()) {
            return Optional.of(ChromeOptions.class);
        }
        if (type == FirefoxDriver.class || this.browserType.isPresent() && this.browserType.get() == BrowserType.FIREFOX) {
            return Optional.of(FirefoxOptions.class);
        }
        if (type == OperaDriver.class || this.browserType.isPresent() && this.browserType.get() == BrowserType.OPERA) {
            return Optional.of(OperaOptions.class);
        }
        if (type == EdgeDriver.class || this.browserType.isPresent() && this.browserType.get() == BrowserType.EDGE) {
            return Optional.of(EdgeOptions.class);
        }
        if (type == SafariDriver.class || this.browserType.isPresent() && this.browserType.get() == BrowserType.SAFARI) {
            return Optional.of(SafariOptions.class);
        }
        if (type == InternetExplorerDriver.class) {
            return Optional.of(InternetExplorerOptions.class);
        }
        if (type == ChromiumDriver.class) {
            return Optional.of(ChromiumOptions.class);
        }
        if (this.isGeneric) {
            String defaultBrowser = WebDriverManager.getInstance().config().getDefaultBrowser();
            this.browserType = Optional.of(BrowsersTemplate.Browser.toBrowserType(defaultBrowser));
        }
        return Optional.empty();
    }

    private Capabilities getOptions(Class<? extends Capabilities> optionsClass) {
        Optional testInstance = this.extensionContext.getTestInstance();
        Capabilities options = null;
        try {
            options = optionsClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            log.warn("Exception creating instance of {}", optionsClass);
            return options;
        }
        log.trace("Getting options for {}", optionsClass);
        this.handleArguments(optionsClass, options);
        this.handleExtensions(optionsClass, options);
        this.handlePreferences(optionsClass, options);
        this.handleBinary(optionsClass, options);
        options = this.handleOptions(optionsClass, options, testInstance);
        this.handleCapabilities(optionsClass, options);
        log.trace("Gathered {}", (Object)options);
        return options;
    }

    private void handleCapabilities(Class<? extends Capabilities> optionsClass, Capabilities options) {
        try {
            if (this.browser.isPresent() && this.browser.get() != null && this.browser.get().getCapabilities() != null) {
                Method setCapabilityMethod = optionsClass.getMethod("setCapability", String.class, String.class);
                Set caps = ((LinkedTreeMap)this.browser.get().getCapabilities()).entrySet();
                for (Map.Entry entry : caps) {
                    setCapabilityMethod.invoke((Object)options, entry.getKey(), entry.getValue());
                }
            }
        }
        catch (Exception e) {
            log.trace("Exception reading capabilities of {} ({})", optionsClass, (Object)e.getMessage());
        }
    }

    private Capabilities handleOptions(Class<? extends Capabilities> optionsClass, Capabilities options, Optional<Object> testInstance) {
        try {
            Capabilities optionsFromAnnotatedField = this.annotationsReader.getFromAnnotatedField(testInstance, Options.class, optionsClass);
            if (optionsFromAnnotatedField != null) {
                options = optionsFromAnnotatedField.merge(options);
            }
        }
        catch (Exception e) {
            log.trace("Exception reading options of {} ({})", optionsClass, (Object)e.getMessage());
        }
        return options;
    }

    private void handleBinary(Class<? extends Capabilities> optionsClass, Capabilities options) {
        try {
            Method setBinaryMethod = optionsClass.getMethod("setBinary", String.class);
            Binary binary = this.parameter.getAnnotation(Binary.class);
            if (binary != null) {
                setBinaryMethod.invoke((Object)options, binary.value());
            }
        }
        catch (Exception e) {
            log.trace("Exception reading binary of {} ({})", optionsClass, (Object)e.getMessage());
        }
    }

    private void handlePreferences(Class<? extends Capabilities> optionsClass, Capabilities options) {
        try {
            Method addPreferenceMethod = optionsClass.getMethod("addPreference", String.class, Object.class);
            Preferences preferences = this.parameter.getAnnotation(Preferences.class);
            if (preferences != null) {
                this.addPreferences(options, preferences.value(), addPreferenceMethod);
            }
            if (this.browser.isPresent() && this.browser.get() != null && this.browser.get().getPreferences() != null) {
                this.addPreferences(options, this.browser.get().getPreferences(), addPreferenceMethod);
            }
        }
        catch (Exception e) {
            log.trace("Exception reading preferences of {} ({})", optionsClass, (Object)e.getMessage());
        }
    }

    private Capabilities addPreferences(Capabilities options, String[] preferences, Method addPreferenceMethod) throws IllegalAccessException, InvocationTargetException {
        for (String preference : preferences) {
            Optional<List<Object>> keyValue = this.annotationsReader.getKeyValue(preference);
            if (!keyValue.isPresent()) continue;
            String name = keyValue.get().get(0).toString();
            String value = keyValue.get().get(1).toString();
            if (this.annotationsReader.isBoolean(value)) {
                addPreferenceMethod.invoke((Object)options, name, Boolean.valueOf(value));
                continue;
            }
            if (this.annotationsReader.isNumeric(value)) {
                addPreferenceMethod.invoke((Object)options, name, Integer.parseInt(value));
                continue;
            }
            addPreferenceMethod.invoke((Object)options, name, value);
        }
        return options;
    }

    private Capabilities handleExtensions(Class<? extends Capabilities> optionsClass, Capabilities options) {
        try {
            boolean isFirefox = optionsClass == FirefoxOptions.class;
            Method addExtensionsMethod = isFirefox ? optionsClass.getMethod("setProfile", FirefoxProfile.class) : optionsClass.getMethod("addExtensions", File[].class);
            Extensions extensions = this.parameter.getAnnotation(Extensions.class);
            if (extensions != null) {
                for (String extension : extensions.value()) {
                    if (isFirefox) {
                        FirefoxProfile firefoxProfile = new FirefoxProfile();
                        firefoxProfile.addExtension(this.getExtension(extension));
                        addExtensionsMethod.invoke((Object)options, firefoxProfile);
                        continue;
                    }
                    addExtensionsMethod.invoke((Object)options, this.getExtension(extension));
                }
            }
        }
        catch (Exception e) {
            log.trace("Exception reading extensions of {} ({})", optionsClass, (Object)e.getMessage());
        }
        return options;
    }

    private void handleArguments(Class<? extends Capabilities> optionsClass, Capabilities options) {
        try {
            Method addArgumentsMethod = optionsClass.getMethod("addArguments", List.class);
            Arguments arguments = this.parameter.getAnnotation(Arguments.class);
            if (arguments != null) {
                addArgumentsMethod.invoke((Object)options, Arrays.asList(arguments.value()));
            }
            if (this.browser.isPresent() && this.browser.get() != null && this.browser.get().getArguments() != null) {
                addArgumentsMethod.invoke((Object)options, Arrays.asList(this.browser.get().getArguments()));
            }
        }
        catch (Exception e) {
            log.trace("Exception reading arguments of {} ({})", optionsClass, (Object)e.getMessage());
        }
    }

    private File getExtension(String fileName) {
        File file = new File(fileName);
        try {
            InputStream inputStream;
            if (!file.exists() && (inputStream = this.getClass().getResourceAsStream("/" + file)) != null) {
                file = File.createTempFile("tmp-", fileName);
                file.deleteOnExit();
                FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)file);
            }
        }
        catch (Exception e) {
            log.warn("There was a problem handling extension", (Throwable)e);
        }
        return file;
    }
}

