/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup;

import io.github.bonigarcia.seljup.BrowserType;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;

public class BrowsersTemplate {
    static final String IN_DOCKER = "-in-docker";
    static final String IN_SELENIDE = "-in-selenide";
    List<List<Browser>> browsers;

    public Stream<List<Browser>> getStream() {
        return this.browsers.stream();
    }

    public static class Browser {
        String type;
        String version;
        String remoteUrl;
        String[] arguments;
        String[] preferences;
        Object capabilities;

        public Browser(String type, String version, String remoteUrl, String[] arguments, String[] preferences, Object capabilities) {
            this.type = type;
            this.version = version;
            this.remoteUrl = remoteUrl;
            this.arguments = arguments;
            this.preferences = preferences;
            this.capabilities = capabilities;
        }

        public Browser() {
        }

        public String getType() {
            return this.type;
        }

        public String getVersion() {
            return this.version;
        }

        public String getRemoteUrl() {
            return this.remoteUrl;
        }

        public void setRemoteUrl(String url) {
            this.remoteUrl = url;
        }

        public String[] getArguments() {
            return this.arguments;
        }

        public void setArguments(String[] arguments) {
            this.arguments = arguments;
        }

        public String[] getPreferences() {
            return this.preferences;
        }

        public void setPreferences(String[] preferences) {
            this.preferences = preferences;
        }

        public Object getCapabilities() {
            return this.capabilities;
        }

        public void setCapabilities(Object capabilities) {
            this.capabilities = capabilities;
        }

        public BrowserType toBrowserType() {
            return Browser.toBrowserType(this.getType());
        }

        public static BrowserType toBrowserType(String browser) {
            return BrowserType.valueOf(browser.replace(BrowsersTemplate.IN_DOCKER, "").replace(BrowsersTemplate.IN_SELENIDE, "").replace("-", "_").toUpperCase(Locale.ROOT));
        }

        public boolean isAndroidBrowser() {
            return this.toBrowserType() == BrowserType.CHROME_MOBILE;
        }

        public boolean isDockerBrowser() {
            return this.getType().contains(BrowsersTemplate.IN_DOCKER);
        }

        public boolean isInSelenide() {
            return this.getType().contains(BrowsersTemplate.IN_SELENIDE);
        }

        public String toString() {
            String versionMessage = this.getVersion() != null ? ", version=" + this.getVersion() : "";
            return "Browser [type=" + this.getType() + versionMessage + "]";
        }
    }
}

