/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup;

import com.google.gson.Gson;
import io.github.bonigarcia.seljup.AnnotationsReader;
import io.github.bonigarcia.seljup.Browser;
import io.github.bonigarcia.seljup.BrowserBuilder;
import io.github.bonigarcia.seljup.BrowserType;
import io.github.bonigarcia.seljup.BrowsersTemplate;
import io.github.bonigarcia.seljup.CapabilitiesHandler;
import io.github.bonigarcia.seljup.DockerBrowser;
import io.github.bonigarcia.seljup.EnabledIfBrowserAvailable;
import io.github.bonigarcia.seljup.EnabledIfDockerAvailable;
import io.github.bonigarcia.seljup.EnabledIfDriverUrlOnline;
import io.github.bonigarcia.seljup.OutputHandler;
import io.github.bonigarcia.seljup.ScreenshotManager;
import io.github.bonigarcia.seljup.SelenideHandler;
import io.github.bonigarcia.seljup.SeleniumJupiterException;
import io.github.bonigarcia.seljup.SingleSession;
import io.github.bonigarcia.seljup.Watch;
import io.github.bonigarcia.seljup.config.Config;
import io.github.bonigarcia.wdm.WebDriverManager;
import io.github.bonigarcia.wdm.config.DriverManagerType;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.platform.commons.util.AnnotationUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeleniumJupiter
implements ParameterResolver,
AfterTestExecutionCallback,
AfterEachCallback,
AfterAllCallback,
TestTemplateInvocationContextProvider,
ExecutionCondition {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String CLASSPATH_PREFIX = "classpath:";
    static final String DEVTOOLS_CLASS = "org.openqa.selenium.devtools.DevTools";
    static final String HTMLUNIT_DRIVER_CLASS = "org.openqa.selenium.htmlunit.HtmlUnitDriver";
    static final String APPIUM_DRIVER_CLASS = "io.appium.java_client.AppiumDriver";
    static final ConditionEvaluationResult ENABLED = ConditionEvaluationResult.enabled((String)"Test enabled");
    Config config = new Config();
    Map<String, List<WebDriverManager>> wdmMap = Collections.synchronizedMap(new LinkedHashMap());
    List<DevTools> devToolsList;
    AnnotationsReader annotationsReader = new AnnotationsReader();
    List<List<BrowsersTemplate.Browser>> browserListList = new ArrayList<List<BrowsersTemplate.Browser>>();
    Map<String, List<BrowsersTemplate.Browser>> browserListMap = new ConcurrentHashMap<String, List<BrowsersTemplate.Browser>>();
    OutputHandler outputHandler;
    URL urlFromAnnotation;
    SelenideHandler selenideHandler;

    public SeleniumJupiter() {
        this.devToolsList = new ArrayList<DevTools>();
        this.selenideHandler = new SelenideHandler(this.annotationsReader);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Parameter parameter = parameterContext.getParameter();
        Class<?> type = parameter.getType();
        Type parameterizedType = parameter.getParameterizedType();
        String parameterizedTypeName = "";
        if (ParameterizedType.class.isAssignableFrom(parameterizedType.getClass())) {
            parameterizedTypeName = ((ParameterizedType)parameterizedType).getActualTypeArguments()[0].getTypeName();
        }
        Optional<DockerBrowser> dockerBrowser = this.annotationsReader.getDocker(parameter);
        return (WebDriver.class.isAssignableFrom(type) || type.equals(DevTools.class) || type.equals(List.class) && dockerBrowser.isPresent() && this.isGeneric(parameterizedTypeName) || this.selenideHandler.isSelenide(type)) && !this.isTestTemplate(extensionContext);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        String contextId = this.getContextId(extensionContext);
        Parameter parameter = parameterContext.getParameter();
        int index = parameterContext.getIndex();
        Optional testInstance = extensionContext.getTestInstance();
        this.log.trace("Resolving parameter {} (contextId {}, index {})", new Object[]{parameter, contextId, index});
        Class<?> type = parameter.getType();
        switch (type.getName()) {
            case "org.openqa.selenium.devtools.DevTools": {
                return this.resolveDevTools(contextId, index);
            }
            case "org.openqa.selenium.htmlunit.HtmlUnitDriver": {
                return this.resolveHtmlUnit(type, extensionContext, parameter);
            }
            case "io.appium.java_client.AppiumDriver": {
                return this.resolveAppium(testInstance, parameter);
            }
        }
        return this.resolveSeleniumWebDriver(extensionContext, contextId, parameter, index, testInstance, type);
    }

    private Object resolveSeleniumWebDriver(ExtensionContext extensionContext, String contextId, Parameter parameter, int index, Optional<Object> testInstance, Class<?> type) {
        WebDriver driver;
        WebDriverManager wdm = null;
        BrowsersTemplate.Browser browser = null;
        int browserNumber = 0;
        boolean isGeneric = this.isGeneric(type);
        boolean isSelenide = this.selenideHandler.isSelenide(type);
        boolean isOpera = this.annotationsReader.getOpera(parameter);
        Optional<DockerBrowser> dockerBrowser = this.annotationsReader.getDocker(parameter);
        Optional<URL> url = this.findUrl(parameter, testInstance);
        Optional<Capabilities> caps = this.annotationsReader.getCapabilities(parameter, testInstance);
        if (this.isSingleSession(extensionContext) && this.wdmMap.containsKey(contextId) && index < this.wdmMap.get(contextId).size() && (driver = this.wdmMap.get(contextId).get(index).getWebDriver()) != null) {
            this.log.trace("Returning driver at index {}: {}", (Object)index, (Object)driver);
            return driver;
        }
        if (this.config.getManager() != null) {
            wdm = this.config.getManager();
        } else if (dockerBrowser.isPresent()) {
            if (dockerBrowser.get().size() > 0) {
                browserNumber = dockerBrowser.get().size();
            }
            wdm = this.getManagerForDocker(extensionContext, parameter, dockerBrowser.get());
        } else if (url.isPresent() && caps.isPresent()) {
            wdm = this.getManagerForRemote(url.get(), caps.get());
        } else if ((isGeneric || isSelenide) && !isOpera) {
            browser = this.getBrowser(contextId, index);
            wdm = this.getManagerForTemplate(extensionContext, parameter, browser, url);
        } else {
            wdm = this.getManagerForLocal(extensionContext, parameter, type, isGeneric, isOpera);
        }
        this.outputHandler = new OutputHandler(extensionContext, this.getConfig(), parameter);
        wdm.dockerRecordingPrefix(this.outputHandler.getPrefix());
        wdm.dockerRecordingOutput(this.outputHandler.getOutputFolder());
        this.putManagerInMap(contextId, wdm);
        Optional<Watch> watcher = this.annotationsReader.getWatch(parameter);
        if (watcher.isPresent()) {
            Watch watch = watcher.get();
            if (watch.display()) {
                wdm.watchAndDisplay();
            } else {
                wdm.watch();
            }
            if (watch.disableCsp()) {
                wdm.disableCsp();
            }
        }
        return this.getObjectFromWdm(wdm, browser, browserNumber, isSelenide, parameter, testInstance);
    }

    private Object getObjectFromWdm(WebDriverManager wdm, BrowsersTemplate.Browser browser, int browserNumber, boolean isSelenide, Parameter parameter, Optional<Object> testInstance) {
        Object object = null;
        if (!isSelenide || !this.selenideHandler.useCustomSelenideConfig(parameter, testInstance)) {
            Object object2 = object = browserNumber == 0 ? wdm.create() : wdm.create(browserNumber);
        }
        if (isSelenide || browser != null && browser.isInSelenide()) {
            if (browserNumber == 0) {
                object = this.selenideHandler.createSelenideDriver((WebDriver)object, parameter, testInstance);
            } else if (object != null) {
                object = ((List)object).stream().map(driver -> this.selenideHandler.createSelenideDriver((WebDriver)driver, parameter, testInstance)).collect(Collectors.toList());
            }
        }
        return object;
    }

    private Optional<URL> findUrl(Parameter parameter, Optional<Object> testInstance) {
        Optional<URL> url = this.annotationsReader.getUrl(parameter, testInstance, this.config.getSeleniumServerUrl());
        if (!url.isPresent() && this.urlFromAnnotation != null) {
            url = Optional.of(this.urlFromAnnotation);
        }
        return url;
    }

    private Object resolveDevTools(String contextId, int index) {
        if (this.wdmMap != null && this.wdmMap.get(contextId) != null && this.wdmMap.get(contextId).size() >= index) {
            WebDriver driver = this.wdmMap.get(contextId).get(index - 1).getWebDriver();
            this.log.debug("Opening DevTools for {}", (Object)driver);
            DevTools devTools = ((HasDevTools)driver).getDevTools();
            devTools.createSessionIfThereIsNotOne();
            this.devToolsList.add(devTools);
            return devTools;
        }
        throw new SeleniumJupiterException("Incorrect position of DevTool arguments (it should be declared after a ChromiumDriver parameter)");
    }

    private Object resolveHtmlUnit(Class<?> type, ExtensionContext extensionContext, Parameter parameter) {
        WebDriver driver = null;
        try {
            Optional<Capabilities> capabilities = this.getCapabilities(extensionContext, parameter, Optional.empty(), Optional.empty());
            driver = capabilities.isPresent() ? (WebDriver)type.getDeclaredConstructor(Capabilities.class).newInstance(capabilities.get()) : (WebDriver)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            this.log.warn("Exception trying to create HtmlUnit instance", (Throwable)e);
        }
        return driver;
    }

    private Object resolveAppium(Optional<Object> testInstance, Parameter parameter) {
        Object driver = null;
        try {
            Optional<URL> url = this.findUrl(parameter, testInstance);
            Optional<Capabilities> caps = this.annotationsReader.getCapabilities(parameter, testInstance);
            if (url.isPresent() && caps.isPresent()) {
                driver = Class.forName(APPIUM_DRIVER_CLASS).getDeclaredConstructor(URL.class, Capabilities.class).newInstance(url.get(), caps.get());
            }
        }
        catch (Exception e) {
            this.log.warn("Exception creating instance of AppiumDriver", (Throwable)e);
        }
        return driver;
    }

    private String getContextId(ExtensionContext extensionContext) {
        Optional parent = extensionContext.getParent();
        return parent.isPresent() && extensionContext.getClass().getCanonicalName().equals("org.junit.jupiter.engine.descriptor.MethodExtensionContext") ? ((ExtensionContext)parent.get()).getUniqueId() : extensionContext.getUniqueId();
    }

    private WebDriverManager getManagerForRemote(URL url, Capabilities caps) {
        WebDriverManager wdm = WebDriverManager.getInstance().remoteAddress(url.toString()).capabilities(caps);
        return wdm;
    }

    private WebDriverManager getManagerForLocal(ExtensionContext extensionContext, Parameter parameter, Class<?> type, boolean isGeneric, boolean isOpera) {
        WebDriverManager wdm;
        if (type == List.class) {
            throw new SeleniumJupiterException("List<WebDriver> must be used together with @DockerBrowser");
        }
        if (isOpera) {
            wdm = WebDriverManager.operadriver();
        } else if (isGeneric) {
            wdm = WebDriverManager.getInstance();
        } else {
            Class<?> webdriverClass = type;
            wdm = WebDriverManager.getInstance(webdriverClass);
        }
        Optional<Capabilities> capabilities = this.getCapabilities(extensionContext, parameter, Optional.empty(), Optional.empty());
        if (capabilities.isPresent()) {
            wdm.capabilities(capabilities.get());
        }
        return wdm;
    }

    private WebDriverManager getManagerForDocker(ExtensionContext extensionContext, Parameter parameter, DockerBrowser dockerBrowser) {
        Optional<Capabilities> capabilities;
        String browserVersion = dockerBrowser.version();
        BrowserType browserType = dockerBrowser.type();
        WebDriverManager wdm = WebDriverManager.getInstance((String)browserType.toBrowserName()).browserVersion(browserVersion).browserInDocker();
        if (browserType == BrowserType.CHROME_MOBILE) {
            wdm.browserInDockerAndroid();
        }
        if (dockerBrowser.recording() || this.config.isRecording() || this.config.isRecordingWhenFailure()) {
            wdm.enableRecording();
        }
        if (dockerBrowser.vnc() || this.config.isVnc()) {
            wdm.enableVnc();
        }
        if (dockerBrowser.volumes().length > 0) {
            wdm.dockerVolumes(dockerBrowser.volumes());
        }
        if (!dockerBrowser.lang().isEmpty()) {
            wdm.dockerLang(dockerBrowser.lang());
        }
        if (!dockerBrowser.timezone().isEmpty()) {
            wdm.dockerTimezone(dockerBrowser.timezone());
        }
        if ((capabilities = this.getCapabilities(extensionContext, parameter, Optional.of(browserType), Optional.empty())).isPresent()) {
            wdm.capabilities(capabilities.get());
        }
        return wdm;
    }

    private WebDriverManager getManagerForTemplate(ExtensionContext extensionContext, Parameter parameter, BrowsersTemplate.Browser browser, Optional<URL> url) {
        Optional<Capabilities> capabilities;
        WebDriverManager wdm;
        Optional<BrowserType> browserType = Optional.empty();
        Optional<BrowsersTemplate.Browser> opBrowser = Optional.empty();
        if (browser != null) {
            opBrowser = Optional.of(browser);
            browserType = Optional.of(browser.toBrowserType());
            wdm = WebDriverManager.getInstance((String)browserType.get().toBrowserName()).browserVersion(browser.getVersion()).remoteAddress(browser.getRemoteUrl());
            if (url.isPresent()) {
                wdm.remoteAddress(url.get().toString());
            }
            if (browser.isDockerBrowser()) {
                wdm.browserInDocker();
            }
            if (browser.isAndroidBrowser()) {
                wdm.browserInDockerAndroid();
            }
            if (this.config.isRecording() || this.config.isRecordingWhenFailure()) {
                wdm.enableRecording();
            }
            if (this.config.isVnc()) {
                wdm.enableVnc();
            }
        } else {
            wdm = WebDriverManager.getInstance();
        }
        if ((capabilities = this.getCapabilities(extensionContext, parameter, browserType, opBrowser)).isPresent()) {
            wdm.capabilities(capabilities.get());
        }
        return wdm;
    }

    private Optional<Capabilities> getCapabilities(ExtensionContext extensionContext, Parameter parameter, Optional<BrowserType> browserType, Optional<BrowsersTemplate.Browser> browser) {
        boolean isOpera = this.annotationsReader.getOpera(parameter);
        CapabilitiesHandler capsHandler = new CapabilitiesHandler(this.config, this.annotationsReader, parameter, extensionContext, browser, browserType, this.isGeneric(parameter.getType()), isOpera);
        return capsHandler.getCapabilities();
    }

    public void afterTestExecution(ExtensionContext extensionContext) throws Exception {
        String contextId = this.getContextId(extensionContext);
        ScreenshotManager screenshotManager = new ScreenshotManager(extensionContext, this.getConfig(), this.outputHandler);
        if (this.wdmMap.containsKey(contextId)) {
            this.wdmMap.get(contextId).stream().map(WebDriverManager::getWebDriverList).forEach(screenshotManager::makeScreenshotIfRequired);
            this.wdmMap.get(contextId).stream().forEach(WebDriverManager::stopDockerRecording);
        }
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        if (!this.isSingleSession(extensionContext)) {
            this.quitWebDriver(extensionContext);
        }
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        if (this.isSingleSession(extensionContext)) {
            this.quitWebDriver(extensionContext);
        }
    }

    public boolean supportsTestTemplate(ExtensionContext context) {
        boolean allWebDriver = false;
        if (context.getTestMethod().isPresent()) {
            allWebDriver = !Arrays.stream(((Method)context.getTestMethod().get()).getParameterTypes()).map(s -> s.equals(WebDriver.class) || s.equals(RemoteWebDriver.class) || this.selenideHandler.isSelenide((Class<?>)s)).collect(Collectors.toList()).contains(false);
        }
        return allWebDriver;
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext extensionContext) {
        String contextId = this.getContextId(extensionContext);
        try {
            if (!this.browserListList.isEmpty()) {
                return this.browserListList.stream().map(b -> this.invocationContext((List<BrowsersTemplate.Browser>)b, this));
            }
            String browserJsonContent = this.config.getBrowserTemplateJsonContent();
            if (browserJsonContent.isEmpty()) {
                String browserJsonFile = this.config.getBrowserTemplateJsonFile();
                if (browserJsonFile.startsWith(CLASSPATH_PREFIX)) {
                    String browserJsonInClasspath = browserJsonFile.substring(CLASSPATH_PREFIX.length());
                    InputStream resourceAsStream = this.getClass().getResourceAsStream("/" + browserJsonInClasspath);
                    if (resourceAsStream != null) {
                        browserJsonContent = IOUtils.toString((InputStream)resourceAsStream, (Charset)Charset.defaultCharset());
                    }
                } else {
                    browserJsonContent = new String(Files.readAllBytes(Paths.get(browserJsonFile, new String[0])));
                }
            }
            if (!browserJsonContent.isEmpty()) {
                return ((BrowsersTemplate)new Gson().fromJson(browserJsonContent, BrowsersTemplate.class)).getStream().map(b -> this.invocationContext((List<BrowsersTemplate.Browser>)b, this));
            }
            if (this.browserListMap != null) {
                List<BrowsersTemplate.Browser> browsers = this.browserListMap.get(contextId);
                if (browsers != null) {
                    return Stream.of(this.invocationContext(browsers, this));
                }
                return Stream.empty();
            }
        }
        catch (IOException e) {
            throw new SeleniumJupiterException(e);
        }
        throw new SeleniumJupiterException("No browser scenario registered for test template");
    }

    private synchronized TestTemplateInvocationContext invocationContext(final List<BrowsersTemplate.Browser> template, final SeleniumJupiter parent) {
        return new TestTemplateInvocationContext(){

            public String getDisplayName(int invocationIndex) {
                return template.toString();
            }

            public List<Extension> getAdditionalExtensions() {
                return Collections.singletonList(new ParameterResolver(){

                    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
                        Class<?> type = parameterContext.getParameter().getType();
                        return type.equals(WebDriver.class) || type.equals(RemoteWebDriver.class) || SeleniumJupiter.this.selenideHandler.isSelenide(type);
                    }

                    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
                        String contextId = SeleniumJupiter.this.getContextId(extensionContext);
                        SeleniumJupiter.this.log.trace("Setting browser list {} for context id {}", (Object)template, (Object)contextId);
                        parent.browserListMap.put(contextId, template);
                        return parent.resolveParameter(parameterContext, extensionContext);
                    }
                });
            }
        };
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        AnnotatedElement element = context.getElement().orElse(null);
        return AnnotationUtils.findAnnotation((AnnotatedElement)element, EnabledIfBrowserAvailable.class).map(this::toBrowserResult).orElse(AnnotationUtils.findAnnotation((AnnotatedElement)element, EnabledIfDriverUrlOnline.class).map(this::toUrlResult).orElse(AnnotationUtils.findAnnotation((AnnotatedElement)element, EnabledIfDockerAvailable.class).map(this::toDockerResult).orElse(ENABLED)));
    }

    public Config getConfig() {
        return this.config;
    }

    public void addBrowsers(BrowsersTemplate.Browser ... browsers) {
        this.browserListList.add(Arrays.asList(browsers));
    }

    public void addBrowsers(String[] ... browsers) {
        Arrays.asList(browsers).stream().forEach(this::addBrowsers);
    }

    public void addBrowsers(String ... browsers) {
        this.browserListList.add(Arrays.asList(browsers).stream().map(browser -> new BrowserBuilder((String)browser).build()).collect(Collectors.toList()));
    }

    public void putBrowserList(String key, List<BrowsersTemplate.Browser> browserList) {
        this.browserListMap.put(key, browserList);
    }

    private boolean isTestTemplate(ExtensionContext extensionContext) {
        Optional testMethod = extensionContext.getTestMethod();
        return testMethod.isPresent() && ((Method)testMethod.get()).isAnnotationPresent(TestTemplate.class);
    }

    private boolean isGeneric(Class<?> type) {
        return this.isGeneric(type.getCanonicalName());
    }

    private boolean isGeneric(String type) {
        return type.equals("org.openqa.selenium.remote.RemoteWebDriver") || type.equals("org.openqa.selenium.WebDriver");
    }

    private BrowsersTemplate.Browser getBrowser(String contextId, int index) {
        this.log.trace("Getting browser by contextId {} and index {}", (Object)contextId, (Object)index);
        BrowsersTemplate.Browser browser = null;
        if (!this.browserListMap.containsKey(contextId)) {
            this.log.warn("Browser list for context id {} not found", (Object)contextId);
        } else {
            List<BrowsersTemplate.Browser> browserList = this.browserListMap.get(contextId);
            if (index >= browserList.size()) {
                index = browserList.size() - 1;
            }
            browser = browserList.get(index);
        }
        return browser;
    }

    private ConditionEvaluationResult toDockerResult(EnabledIfDockerAvailable annotation) {
        if (!WebDriverManager.isDockerAvailable()) {
            return ConditionEvaluationResult.disabled((String)"Docker is not installed in the system");
        }
        return ENABLED;
    }

    private ConditionEvaluationResult toBrowserResult(EnabledIfBrowserAvailable annotation) {
        Browser[] browsers;
        for (Browser browser : browsers = annotation.value()) {
            DriverManagerType driverManagerType = DriverManagerType.valueOf((String)browser.name());
            Optional browserPath = WebDriverManager.getInstance((DriverManagerType)driverManagerType).getBrowserPath();
            if (browserPath.isPresent()) continue;
            return ConditionEvaluationResult.disabled((String)(browser + " is not installed in the system"));
        }
        return ENABLED;
    }

    private ConditionEvaluationResult toUrlResult(EnabledIfDriverUrlOnline annotation) {
        String urlValue = annotation.value();
        ConditionEvaluationResult disabled = ConditionEvaluationResult.disabled((String)(urlValue + " is not online"));
        try {
            URL urlStatus;
            URL url = new URL(urlValue);
            if (!WebDriverManager.isOnline((URL)url) && !WebDriverManager.isOnline((URL)(urlStatus = new URL(url, "/status")))) {
                return disabled;
            }
            this.urlFromAnnotation = url;
        }
        catch (MalformedURLException e) {
            return disabled;
        }
        return ENABLED;
    }

    private void removeManagersFromMap(String contextId) {
        if (this.wdmMap.containsKey(contextId)) {
            this.wdmMap.remove(contextId);
            this.log.trace("Removing managers from map (id {})", (Object)contextId);
        }
    }

    private void putManagerInMap(String contextId, WebDriverManager wdm) {
        this.log.trace("Put manager {} in map (context id {})", (Object)wdm, (Object)contextId);
        if (this.wdmMap.containsKey(contextId)) {
            this.wdmMap.get(contextId).add(wdm);
            this.log.trace("Adding {} to existing map (id {})", (Object)wdm, (Object)contextId);
        } else {
            ArrayList<WebDriverManager> wdmList = new ArrayList<WebDriverManager>();
            wdmList.add(wdm);
            this.wdmMap.put(contextId, wdmList);
            this.log.trace("Adding {} to new map (id {})", (Object)wdm, (Object)contextId);
        }
    }

    private boolean isSingleSession(ExtensionContext extensionContext) {
        boolean singleSession = false;
        Optional testClass = extensionContext.getTestClass();
        if (testClass.isPresent()) {
            singleSession = ((Class)testClass.get()).isAnnotationPresent(SingleSession.class);
        }
        this.log.trace("Single session {}", (Object)singleSession);
        return singleSession;
    }

    private void quitWebDriver(ExtensionContext extensionContext) {
        String contextId = this.getContextId(extensionContext);
        this.log.trace("Quitting contextId {}: (wdmMap={})", (Object)contextId, this.wdmMap);
        this.devToolsList.forEach(DevTools::close);
        this.devToolsList.clear();
        if (this.wdmMap.containsKey(contextId)) {
            Optional executionException = extensionContext.getExecutionException();
            this.wdmMap.get(contextId).forEach(manager -> {
                List<Path> recordingList = Collections.emptyList();
                if (this.config.isRecordingWhenFailure() && !executionException.isPresent()) {
                    recordingList = manager.getWebDriverList().stream().map(arg_0 -> ((WebDriverManager)manager).getDockerRecordingPath(arg_0)).collect(Collectors.toList());
                }
                manager.quit();
                recordingList.forEach(path -> {
                    try {
                        this.log.debug("Deleting {} (since test does not fail)", path);
                        Files.delete(path);
                    }
                    catch (Exception e) {
                        this.log.warn("Exception trying to delete recording {}", path);
                    }
                });
            });
            this.removeManagersFromMap(contextId);
        }
    }

    public URL getDockerNoVncUrl() {
        return (URL)this.invokeWdm("getDockerNoVncUrl", new Object[0]);
    }

    public URL getDockerNoVncUrl(WebDriver driver) {
        return (URL)this.invokeWdm(driver, "getDockerNoVncUrl", new Object[0]);
    }

    public List<Map<String, Object>> getLogs() {
        return (List)this.invokeWdm("getLogs", new Object[0]);
    }

    public List<Map<String, Object>> getLogs(WebDriver driver) {
        return (List)this.invokeWdm(driver, "getLogs", new Object[0]);
    }

    public void startRecording(String recFilename) {
        this.invokeWdm("startRecording", recFilename);
    }

    public void startRecording(String recFilename, WebDriver driver) {
        this.invokeWdm(driver, "startRecording", recFilename);
    }

    public void stopRecording() {
        this.invokeWdm("stopRecording", new Object[0]);
    }

    public void stopRecording(WebDriver driver) {
        this.invokeWdm(driver, "stopRecording", new Object[0]);
    }

    public <T> T invokeWdm(String method, Object ... params) {
        T out = null;
        try {
            if (!this.wdmMap.isEmpty()) {
                List<WebDriverManager> wdmList = this.wdmMap.entrySet().iterator().next().getValue();
                WebDriverManager wdm = wdmList.get(0);
                Method wdmMethod = params.length == 0 ? wdm.getClass().getMethod(method, new Class[0]) : wdm.getClass().getMethod(method, params[0].getClass());
                return (T)wdmMethod.invoke((Object)wdm, params);
            }
        }
        catch (Exception e) {
            this.log.warn("Exception invoking {}", (Object)method, (Object)e);
        }
        return out;
    }

    public <T> T invokeWdm(WebDriver driver, String method, Object ... params) {
        Object out = null;
        try {
            if (!this.wdmMap.isEmpty()) {
                for (List<WebDriverManager> wdmList : this.wdmMap.values()) {
                    Iterator<WebDriverManager> iterator = wdmList.iterator();
                    while (iterator.hasNext()) {
                        WebDriverManager wdm;
                        Method wdmMethod = params.length == 0 ? wdm.getClass().getMethod(method, new Class[0]) : wdm.getClass().getMethod(method, params[0].getClass());
                        out = wdmMethod.invoke((Object)(wdm = iterator.next()), params);
                        if (out == null) continue;
                        return (T)out;
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.warn("Exception invoking {} for {}", new Object[]{method, driver, e});
        }
        return (T)out;
    }
}

