/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup;

import io.github.bonigarcia.seljup.BrowsersTemplate;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.junit.jupiter.api.TestTemplate;
import org.junit.platform.commons.util.Preconditions;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@TestTemplate
public @interface BrowserScenarioTest {
    public static final String DISPLAY_NAME_PLACEHOLDER = "{displayName}";
    public static final String TYPE_PLACEHOLDER = "{type}";
    public static final String VERSION_PLACEHOLDER = "{version}";
    public static final String ARGUMENTS_PLACEHOLDER = "{arguments}";
    public static final String PREFERENCES_PLACEHOLDER = "{preferences}";
    public static final String CAPABILITIES_PLACEHOLDER = "{capabilities}";
    public static final String REMOTE_URL_PLACEHOLDER = "{remoteUrl}";
    public static final String DEFAULT_NAME = "{displayName} - {type} {version}";

    public String name() default "{displayName} - {type} {version}";

    public static final class NameFormatter {
        private NameFormatter() {
        }

        public static String format(String namePattern, String displayName, BrowsersTemplate.Browser browser) {
            Preconditions.notNull((Object)namePattern, (String)"namePattern must not be null");
            Preconditions.notNull((Object)displayName, (String)"displayName must not be null");
            Preconditions.notNull((Object)browser, (String)"browser must not be null");
            String result = namePattern.trim();
            Preconditions.notBlank((String)result, (String)"@BrowserScenarioTest must be declared with a non-empty name.");
            result = NameFormatter.replacePlaceholders(result, BrowserScenarioTest.DISPLAY_NAME_PLACEHOLDER, displayName);
            result = NameFormatter.replacePlaceholders(result, BrowserScenarioTest.TYPE_PLACEHOLDER, browser.getType());
            result = NameFormatter.replacePlaceholders(result, BrowserScenarioTest.VERSION_PLACEHOLDER, browser.getVersion());
            result = NameFormatter.replacePlaceholders(result, BrowserScenarioTest.ARGUMENTS_PLACEHOLDER, browser.getArguments(), Arrays::toString);
            result = NameFormatter.replacePlaceholders(result, BrowserScenarioTest.PREFERENCES_PLACEHOLDER, browser.getPreferences(), Arrays::toString);
            result = NameFormatter.replacePlaceholders(result, BrowserScenarioTest.CAPABILITIES_PLACEHOLDER, browser.getCapabilities(), Object::toString);
            return NameFormatter.replacePlaceholders(result, BrowserScenarioTest.REMOTE_URL_PLACEHOLDER, browser.getRemoteUrl());
        }

        private static String replacePlaceholders(String namePattern, String placeholder, String value) {
            return NameFormatter.replacePlaceholders(namePattern, placeholder, value, UnaryOperator.identity());
        }

        private static <T> String replacePlaceholders(String namePattern, String placeholder, T value, Function<T, String> mapper) {
            if (value != null) {
                return namePattern.replace(placeholder, mapper.apply(value));
            }
            return namePattern;
        }
    }
}

