/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.DriverManagerType;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;

public class FirefoxDriverManager
extends WebDriverManager {
    public static synchronized WebDriverManager getInstance() {
        return FirefoxDriverManager.firefoxdriver();
    }

    public FirefoxDriverManager() {
        this.driverManagerType = DriverManagerType.FIREFOX;
        this.exportParameterKey = "wdm.geckoDriverExport";
        this.driverVersionKey = "wdm.geckoDriverVersion";
        this.driverUrlKey = "wdm.geckoDriverUrl";
        this.driverMirrorUrlKey = "wdm.geckoDriverMirrorUrl";
        this.driverName = Arrays.asList("wires", "geckodriver");
    }

    @Override
    protected List<URL> getDrivers() throws IOException {
        return this.getDriversFromGitHub();
    }

    @Override
    protected String getCurrentVersion(URL url, String driverName) {
        String currentVersion = url.getFile().substring(url.getFile().indexOf(45) + 1, url.getFile().lastIndexOf(45));
        if (currentVersion.startsWith("v")) {
            currentVersion = currentVersion.substring(1);
        }
        return currentVersion;
    }

    @Override
    protected String preDownload(String target, String version) {
        int iSeparator = target.indexOf(version) - 1;
        int iDash = target.lastIndexOf(version) + version.length();
        int iPoint = target.lastIndexOf(".zip");
        int iPointTazGz = target.lastIndexOf(".tar.gz");
        int iPointGz = target.lastIndexOf(".gz");
        if (iPointTazGz != -1) {
            iPoint = iPointTazGz;
        } else if (iPointGz != -1) {
            iPoint = iPointGz;
        }
        target = target.substring(0, iSeparator + 1) + target.substring(iDash + 1, iPoint).toLowerCase() + target.substring(iSeparator);
        return target;
    }
}

