/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.WebDriverManager;
import io.javalin.Context;
import io.javalin.Handler;
import io.javalin.Javalin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public Server(int port) {
        Javalin app = Javalin.create().start(port);
        Handler handler = this::handleRequest;
        app.get("/chromedriver", handler);
        app.get("/firefoxdriver", handler);
        app.get("/edgedriver", handler);
        app.get("/iedriver", handler);
        app.get("/operadriver", handler);
        app.get("/phantomjs", handler);
        app.get("/selenium-server-standalone", handler);
        this.log.info("WebDriverManager server listening on port {}", (Object)port);
    }

    private void handleRequest(Context ctx) throws IOException {
        String requestMethod = ctx.method();
        String requestPath = ctx.path();
        this.log.info("Server request: {} {}", (Object)requestMethod, (Object)requestPath);
        Optional<WebDriverManager> driverManager = this.createDriverManager(requestPath);
        if (driverManager.isPresent()) {
            this.resolveDriver(ctx, driverManager.get());
        }
    }

    private Optional<WebDriverManager> createDriverManager(String requestPath) {
        Optional<WebDriverManager> out;
        switch (requestPath.substring(1)) {
            case "chromedriver": {
                out = Optional.of(WebDriverManager.chromedriver());
                break;
            }
            case "firefoxdriver": {
                out = Optional.of(WebDriverManager.firefoxdriver());
                break;
            }
            case "edgedriver": {
                out = Optional.of(WebDriverManager.edgedriver());
                break;
            }
            case "iedriver": {
                out = Optional.of(WebDriverManager.iedriver());
                break;
            }
            case "operadriver": {
                out = Optional.of(WebDriverManager.operadriver());
                break;
            }
            case "phantomjs": {
                out = Optional.of(WebDriverManager.phantomjs());
                break;
            }
            case "selenium-server-standalone": {
                out = Optional.of(WebDriverManager.seleniumServerStandalone());
                break;
            }
            default: {
                this.log.warn("Unknown option {}", (Object)requestPath);
                out = Optional.empty();
            }
        }
        return out;
    }

    private synchronized void resolveDriver(Context ctx, WebDriverManager driverManager) throws IOException {
        Map queryParamMap = ctx.queryParamMap();
        if (!queryParamMap.isEmpty()) {
            this.log.info("Server query string for configuration {}", (Object)queryParamMap);
            for (Map.Entry entry : queryParamMap.entrySet()) {
                String configKey = "wdm." + (String)entry.getKey();
                String configValue = (String)((List)entry.getValue()).get(0);
                this.log.trace("\t{} = {}", (Object)configKey, (Object)configValue);
                System.setProperty(configKey, configValue);
            }
        }
        WebDriverManager.config().setAvoidExport(true);
        WebDriverManager.config().setAvoidAutoVersion(true);
        driverManager.setup();
        File binary = new File(driverManager.getBinaryPath());
        String binaryVersion = driverManager.getDownloadedVersion();
        String binaryName = binary.getName();
        String binaryLength = String.valueOf(binary.length());
        ctx.res.setHeader("Content-Disposition", "attachment; filename=\"" + binaryName + "\"");
        ctx.result((InputStream)FileUtils.openInputStream((File)binary));
        this.log.info("Server response: {} {} ({} bytes)", new Object[]{binaryName, binaryVersion, binaryLength});
        for (String key : queryParamMap.keySet()) {
            System.clearProperty("wdm." + key);
        }
    }
}

