/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.WebDriverManagerException;

public enum DriverManagerType {
    CHROME("org.openqa.selenium.chrome.ChromeDriver"),
    FIREFOX("org.openqa.selenium.firefox.FirefoxDriver"),
    OPERA("org.openqa.selenium.opera.OperaDriver"),
    EDGE("org.openqa.selenium.edge.EdgeDriver"),
    PHANTOMJS("org.openqa.selenium.phantomjs.PhantomJSDriver"),
    IEXPLORER("org.openqa.selenium.ie.InternetExplorerDriver"),
    SELENIUM_SERVER_STANDALONE("org.openqa.selenium.remote.server.SeleniumServer"),
    CHROMIUM("org.openqa.selenium.chrome.ChromeDriver");

    String browserClass;

    private DriverManagerType(String browserClass) {
        this.browserClass = browserClass;
    }

    public String browserClass() {
        return this.browserClass;
    }

    public String toString() {
        switch (this) {
            case CHROME: {
                return "Google Chrome";
            }
            case CHROMIUM: {
                return "Chromium";
            }
            case FIREFOX: {
                return "Mozilla Firefox";
            }
            case OPERA: {
                return "Opera";
            }
            case EDGE: {
                return "Microsoft Edge";
            }
            case PHANTOMJS: {
                return "PhantomJS";
            }
            case IEXPLORER: {
                return "Internet Explorer";
            }
            case SELENIUM_SERVER_STANDALONE: {
                return "Selenium Server Standalone";
            }
        }
        throw new WebDriverManagerException("Invalid driver manager type: " + this.name());
    }
}

