/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.versions;

import io.github.bonigarcia.wdm.config.Config;
import io.github.bonigarcia.wdm.config.OperatingSystem;
import io.github.bonigarcia.wdm.online.HttpClient;
import io.github.bonigarcia.wdm.versions.Shell;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionDetector {
    static final String ONLINE = "online";
    static final String LOCAL = "local";
    static final String VERSIONS_PROPERTIES = "versions.properties";
    static final String COMMANDS_PROPERTIES = "commands.properties";
    static final String FILE_PROTOCOL = "file";
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    Config config;
    HttpClient httpClient;
    Map<String, Properties> propertiesMap;
    boolean isSnap;

    public VersionDetector(Config config, HttpClient httpClient) {
        this.config = config;
        this.httpClient = httpClient;
        this.propertiesMap = new HashMap<String, Properties>();
    }

    public Optional<String> getDriverVersionFromProperties(String key) {
        if (key.contains("chromium")) {
            key = key.replace("chromium", "chrome");
        }
        boolean online = this.config.getVersionsPropertiesOnlineFirst();
        String propertiesName = VERSIONS_PROPERTIES;
        String onlineMessage = online ? ONLINE : LOCAL;
        this.log.debug("Getting driver version for {} from {} {}", new Object[]{key, onlineMessage, propertiesName});
        String value = this.getValueFromProperties(this.getProperties(propertiesName, online), key);
        if (value == null) {
            String notOnlineMessage = online ? LOCAL : ONLINE;
            this.log.debug("Driver for {} not found in {} properties (using {} {})", new Object[]{key, onlineMessage, notOnlineMessage, propertiesName});
            this.propertiesMap.remove(propertiesName);
            value = this.getProperties(propertiesName, !online).getProperty(key);
        }
        return value == null ? Optional.empty() : Optional.of(value);
    }

    public String getValueFromProperties(Properties properties, String key) {
        String keyWithOs = key + "." + this.config.getOperatingSystem().getName();
        return Optional.ofNullable(properties.getProperty(keyWithOs)).orElse(properties.getProperty(key));
    }

    public Optional<String> getDriverVersionFromRepository(Optional<String> driverVersion, URL driverUrl, Charset versionCharset, String driverName, String versionLabel, String latestLabel, Optional<String> optOsLabel) {
        String osLabel = optOsLabel.isPresent() ? optOsLabel.get() : "";
        String url = driverVersion.isPresent() ? driverUrl + latestLabel + "_" + driverVersion.get() + osLabel : driverUrl + versionLabel;
        Optional<Object> result = Optional.empty();
        try (InputStream response = this.httpClient.execute((ClassicHttpRequest)this.httpClient.createHttpGet(new URL(url))).getEntity().getContent();){
            result = Optional.of(IOUtils.toString((InputStream)response, (Charset)versionCharset).replace("\r\n", ""));
        }
        catch (Exception e) {
            this.log.warn("Exception reading {} to get latest version of {} ({})", new Object[]{url, driverName, e.getMessage()});
        }
        if (result.isPresent()) {
            this.log.debug("Latest version of {} according to {} is {}", new Object[]{driverName, url, result.get()});
        }
        return result;
    }

    public Optional<Path> getBrowserPath(String browserName) {
        this.log.debug("Detecting {} path using the commands database", (Object)browserName);
        String pathStr = "";
        Properties commandsProperties = this.getProperties(COMMANDS_PROPERTIES, this.config.getCommandsPropertiesOnlineFirst());
        List<String> commandsPerOs = this.getCommandsList(browserName, commandsProperties);
        for (String commandKey : commandsPerOs) {
            String command = commandsProperties.get(commandKey).toString();
            int lastSpaceIndex = command.lastIndexOf(" ");
            String firstCommand = command;
            if (lastSpaceIndex != -1) {
                firstCommand = command.substring(0, lastSpaceIndex);
            }
            OperatingSystem operatingSystem = this.config.getOperatingSystem();
            switch (operatingSystem) {
                case WIN: {
                    String newCommand;
                    File wmicLocation;
                    String captionOutput;
                    int iCaption;
                    if (!command.toLowerCase(Locale.ROOT).contains("wmic") || (iCaption = (captionOutput = Shell.runAndWait(wmicLocation = this.findFileLocation("wmic.exe"), (newCommand = command.replace("Version", "Caption")).split(" "))).indexOf("=")) == -1) break;
                    pathStr = captionOutput.substring(iCaption + 1);
                    break;
                }
                default: {
                    if (firstCommand.contains("/")) {
                        pathStr = firstCommand;
                        break;
                    }
                    String[] commandArray = new String[]{"bash", "-c", "type -p " + firstCommand};
                    pathStr = Shell.runAndWait(commandArray);
                }
            }
            Path path = Paths.get(pathStr, new String[0]);
            if (Config.isNullOrEmpty(pathStr) || !Files.exists(path, new LinkOption[0])) continue;
            this.log.debug("The path of {} is {}", (Object)browserName, (Object)pathStr);
            return Optional.of(path);
        }
        this.log.info("Browser {} is not available in the system", (Object)browserName);
        return Optional.empty();
    }

    public Optional<String> getBrowserVersionFromTheShell(String browserName) {
        Optional<String> browserVersionUsingProperties = Optional.empty();
        String browserVersionDetectionCommand = this.config.getBrowserVersionDetectionCommand();
        if (!Config.isNullOrEmpty(browserVersionDetectionCommand)) {
            browserVersionUsingProperties = this.getBrowserVersionUsingCommand(browserVersionDetectionCommand);
        }
        if (browserVersionUsingProperties.isPresent()) {
            return browserVersionUsingProperties;
        }
        boolean online = this.config.getCommandsPropertiesOnlineFirst();
        String propertiesName = COMMANDS_PROPERTIES;
        Properties commandsProperties = this.getProperties(propertiesName, online);
        String onlineMessage = online ? ONLINE : LOCAL;
        this.log.debug("Detecting {} version using {} {}", new Object[]{browserName, onlineMessage, propertiesName});
        browserVersionUsingProperties = this.getBrowserVersionUsingProperties(browserName, commandsProperties);
        if (!browserVersionUsingProperties.isPresent()) {
            String notOnlineMessage = online ? LOCAL : ONLINE;
            this.log.debug("Browser version for {} not detected using {} properties (using {} {})", new Object[]{browserName, onlineMessage, notOnlineMessage, propertiesName});
            commandsProperties = this.getProperties(propertiesName, !online);
            browserVersionUsingProperties = this.getBrowserVersionUsingProperties(browserName, commandsProperties);
        }
        return browserVersionUsingProperties;
    }

    protected Optional<String> getBrowserVersionUsingProperties(String browserName, Properties commandsProperties) {
        List<String> commandsPerOs = this.getCommandsList(browserName, commandsProperties);
        for (String commandKey : commandsPerOs) {
            String command = commandsProperties.get(commandKey).toString();
            Optional<String> browserVersionUsingCommand = this.getBrowserVersionUsingCommand(command);
            if (!browserVersionUsingCommand.isPresent()) continue;
            return browserVersionUsingCommand;
        }
        return Optional.empty();
    }

    protected List<String> getCommandsList(String browserName, Properties commandsProperties) {
        OperatingSystem operatingSystem = this.config.getOperatingSystem();
        return Collections.list(commandsProperties.keys()).stream().map(Object::toString).filter(s -> s.contains(browserName)).filter(operatingSystem::matchOs).sorted().collect(Collectors.toList());
    }

    protected Optional<String> getBrowserVersionUsingCommand(String command) {
        String browserVersionOutput;
        String commandLowerCase = command.toLowerCase(Locale.ROOT);
        boolean isWmic = commandLowerCase.contains("wmic");
        boolean isRegQuery = commandLowerCase.contains("reg query");
        int lastSpaceIndex = command.lastIndexOf(" ");
        String[] commandArray = !isWmic && !isRegQuery && lastSpaceIndex != -1 ? new String[]{command.substring(0, lastSpaceIndex), command.substring(lastSpaceIndex + 1)} : command.split(" ");
        if (isWmic) {
            File wmicLocation = this.findFileLocation("wmic.exe");
            browserVersionOutput = Shell.runAndWait(wmicLocation, commandArray);
        } else {
            browserVersionOutput = Shell.runAndWait(commandArray);
        }
        if (!Config.isNullOrEmpty(browserVersionOutput)) {
            if (browserVersionOutput.toLowerCase(Locale.ROOT).contains("snap")) {
                this.isSnap = true;
            }
            String parsedBrowserVersion = browserVersionOutput.replaceAll(this.config.getBrowserVersionDetectionRegex(), "");
            this.log.trace("Detected browser version is {}", (Object)parsedBrowserVersion);
            return Optional.of(this.getMajorVersion(parsedBrowserVersion));
        }
        return Optional.empty();
    }

    protected Properties getProperties(String propertiesName, boolean online) {
        if (this.propertiesMap.containsKey(propertiesName)) {
            this.log.trace("Already created {}", (Object)propertiesName);
            return this.propertiesMap.get(propertiesName);
        }
        Properties properties = null;
        try (InputStream inputStream = this.getVersionsInputStream(propertiesName, online);){
            properties = new Properties();
            properties.load(new StringReader(IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8).replace("\\", "\\\\")));
            this.propertiesMap.put(propertiesName, properties);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot read " + propertiesName, e);
        }
        return properties;
    }

    protected InputStream getVersionsInputStream(String propertiesName, boolean online) throws IOException {
        InputStream inputStream;
        String onlineMessage = online ? ONLINE : LOCAL;
        this.log.trace("Reading {} {} to find out driver version", (Object)onlineMessage, (Object)propertiesName);
        try {
            inputStream = online ? this.getOnlineInputStream(propertiesName) : this.getLocalInputStream(propertiesName);
        }
        catch (Exception e) {
            String exceptionMessage = online ? LOCAL : ONLINE;
            this.log.warn("Error reading {}, using {} instead", (Object)propertiesName, (Object)exceptionMessage);
            inputStream = online ? this.getLocalInputStream(propertiesName) : this.getOnlineInputStream(propertiesName);
        }
        return inputStream;
    }

    protected InputStream getLocalInputStream(String propertiesName) {
        InputStream inputStream = Config.class.getResourceAsStream("/" + propertiesName);
        return inputStream;
    }

    protected InputStream getOnlineInputStream(String propertiesName) throws IOException {
        URL propertiesUrl = propertiesName.equals(VERSIONS_PROPERTIES) ? this.config.getVersionsPropertiesUrl() : this.config.getCommandsPropertiesUrl();
        InputStream inputStream = propertiesUrl.getProtocol().equalsIgnoreCase(FILE_PROTOCOL) ? new FileInputStream(new File(propertiesUrl.getFile())) : this.httpClient.execute((ClassicHttpRequest)this.httpClient.createHttpGet(propertiesUrl)).getEntity().getContent();
        return inputStream;
    }

    protected String getMajorVersion(String version) {
        int i = version.indexOf(46);
        return i != -1 ? version.substring(0, i) : version;
    }

    protected File findFileLocation(String filename) {
        File system32File;
        File system32Folder = new File(System.getenv("SystemRoot"), "System32");
        if (this.checkFileAndFolder(system32Folder, system32File = new File(system32Folder, filename))) {
            return system32Folder;
        }
        File wbemFolder = new File(system32Folder, "wbem");
        File wbemFile = new File(wbemFolder, filename);
        if (this.checkFileAndFolder(wbemFolder, wbemFile)) {
            return wbemFolder;
        }
        return new File(".");
    }

    protected boolean checkFileAndFolder(File folder, File file) {
        return folder.exists() && folder.isDirectory() && file.exists() && file.isFile();
    }

    public boolean isSnap() {
        return this.isSnap;
    }
}

