/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.LinkedTreeMap;
import io.github.bonigarcia.wdm.WdmServer;
import io.github.bonigarcia.wdm.cache.CacheHandler;
import io.github.bonigarcia.wdm.cache.ResolutionCache;
import io.github.bonigarcia.wdm.config.Architecture;
import io.github.bonigarcia.wdm.config.Config;
import io.github.bonigarcia.wdm.config.DriverManagerType;
import io.github.bonigarcia.wdm.config.OperatingSystem;
import io.github.bonigarcia.wdm.config.WebDriverManagerException;
import io.github.bonigarcia.wdm.docker.DockerContainer;
import io.github.bonigarcia.wdm.docker.DockerService;
import io.github.bonigarcia.wdm.managers.ChromeDriverManager;
import io.github.bonigarcia.wdm.managers.ChromiumDriverManager;
import io.github.bonigarcia.wdm.managers.EdgeDriverManager;
import io.github.bonigarcia.wdm.managers.FirefoxDriverManager;
import io.github.bonigarcia.wdm.managers.InternetExplorerDriverManager;
import io.github.bonigarcia.wdm.managers.OperaDriverManager;
import io.github.bonigarcia.wdm.managers.SafariDriverManager;
import io.github.bonigarcia.wdm.managers.VoidDriverManager;
import io.github.bonigarcia.wdm.online.Downloader;
import io.github.bonigarcia.wdm.online.GitHubApi;
import io.github.bonigarcia.wdm.online.HttpClient;
import io.github.bonigarcia.wdm.online.NpmMirror;
import io.github.bonigarcia.wdm.online.S3NamespaceContext;
import io.github.bonigarcia.wdm.online.UrlHandler;
import io.github.bonigarcia.wdm.versions.Shell;
import io.github.bonigarcia.wdm.versions.VersionComparator;
import io.github.bonigarcia.wdm.versions.VersionDetector;
import io.github.bonigarcia.wdm.webdriver.WebDriverBrowser;
import io.github.bonigarcia.wdm.webdriver.WebDriverCreator;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chromium.ChromiumOptions;
import org.openqa.selenium.firefox.HasExtensions;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class WebDriverManager {
    protected static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final String SLASH = "/";
    protected static final String DASH = "-";
    protected static final String LATEST_RELEASE = "LATEST_RELEASE";
    protected static final String CFT_LABEL = "chrome-for-testing-public";
    protected static final NamespaceContext S3_NAMESPACE_CONTEXT = new S3NamespaceContext();
    protected static final String IN_DOCKER = "-in-docker";
    protected static final String CLI_SERVER = "server";
    protected static final String CLI_RESOLVER = "resolveDriverFor";
    protected static final String CLI_DOCKER = "runInDocker";
    protected static final String BROWSER_WATCHER_ID = "kbnnckbeejhjlljpgelfponodpecfapp";
    protected Config config;
    protected HttpClient httpClient;
    protected Downloader downloader;
    protected ResolutionCache resolutionCache;
    protected CacheHandler cacheHandler;
    protected VersionDetector versionDetector;
    protected WebDriverCreator webDriverCreator;
    protected DockerService dockerService;
    protected int retryCount = 0;
    protected Capabilities capabilities;
    protected boolean shutdownHook = false;
    protected boolean dockerEnabled = false;
    protected boolean watchEnabled = false;
    protected boolean displayEnabled = false;
    protected boolean disableCsp = false;
    protected boolean isHeadless = false;
    protected List<WebDriverBrowser> webDriverList;
    protected String resolvedBrowserVersion;
    protected String downloadedDriverVersion;
    protected String downloadedDriverPath;

    protected abstract List<URL> getDriverUrls(String var1) throws IOException;

    protected abstract String getDriverName();

    protected abstract String getDriverVersion();

    protected abstract void setDriverVersion(String var1);

    protected abstract String getBrowserVersion();

    protected abstract void setBrowserVersion(String var1);

    protected abstract String getBrowserBinary();

    protected abstract void setBrowserBinary(String var1);

    protected abstract void setDriverUrl(URL var1);

    protected abstract URL getDriverUrl();

    protected abstract Optional<URL> getMirrorUrl();

    protected abstract Optional<String> getExportParameter();

    public abstract DriverManagerType getDriverManagerType();

    public abstract WebDriverManager exportParameter(String var1);

    protected WebDriverManager() {
        Optional<String> wdVersion = VersionDetector.getWdmVersion(this.getClass());
        if (wdVersion.isPresent()) {
            log.debug("Using WebDriverManager {}", (Object)wdVersion.get());
        }
        this.config = new Config();
        this.webDriverList = new CopyOnWriteArrayList<WebDriverBrowser>();
    }

    public synchronized Config config() {
        return Optional.ofNullable(this.config).orElse(new Config());
    }

    public static synchronized WebDriverManager chromedriver() {
        return new ChromeDriverManager();
    }

    public static synchronized WebDriverManager chromiumdriver() {
        return new ChromiumDriverManager();
    }

    public static synchronized WebDriverManager firefoxdriver() {
        return new FirefoxDriverManager();
    }

    public static synchronized WebDriverManager operadriver() {
        return new OperaDriverManager();
    }

    public static synchronized WebDriverManager edgedriver() {
        return new EdgeDriverManager();
    }

    public static synchronized WebDriverManager iedriver() {
        return new InternetExplorerDriverManager();
    }

    public static synchronized WebDriverManager safaridriver() {
        return new SafariDriverManager();
    }

    protected static synchronized WebDriverManager voiddriver() {
        return new VoidDriverManager();
    }

    public static synchronized WebDriverManager getInstance(DriverManagerType driverManagerType) {
        if (driverManagerType == DriverManagerType.CHROMIUM) {
            return WebDriverManager.chromiumdriver();
        }
        return WebDriverManager.getDriver(driverManagerType.browserClass());
    }

    public static synchronized WebDriverManager getInstance(String browserName) {
        DriverManagerType managerType;
        String browserNameUpperCase;
        switch (browserNameUpperCase = browserName.toUpperCase(Locale.ROOT)) {
            case "OPERABLINK": {
                managerType = DriverManagerType.OPERA;
                break;
            }
            case "MSEDGE": 
            case "MICROSOFTEDGE": {
                managerType = DriverManagerType.EDGE;
                break;
            }
            case "INTERNET EXPLORER": {
                managerType = DriverManagerType.IEXPLORER;
                break;
            }
            default: {
                try {
                    managerType = DriverManagerType.valueOf(browserNameUpperCase);
                    break;
                }
                catch (Exception e) {
                    String errorMessage = String.format("The browser name '%s' is not recognized", browserName);
                    log.trace(errorMessage);
                    throw new WebDriverManagerException(errorMessage, e);
                }
            }
        }
        return WebDriverManager.getInstance(managerType);
    }

    public static synchronized WebDriverManager getInstance(Class<? extends WebDriver> webDriverClass) {
        return WebDriverManager.getDriver(webDriverClass.getName());
    }

    protected static synchronized WebDriverManager getDriver(String webDriverClass) {
        switch (webDriverClass) {
            case "org.openqa.selenium.chrome.ChromeDriver": {
                return WebDriverManager.chromedriver();
            }
            case "org.openqa.selenium.chromium.ChromiumDriver": {
                return WebDriverManager.chromiumdriver();
            }
            case "org.openqa.selenium.firefox.FirefoxDriver": {
                return WebDriverManager.firefoxdriver();
            }
            case "org.openqa.selenium.opera.OperaDriver": {
                return WebDriverManager.operadriver();
            }
            case "org.openqa.selenium.ie.InternetExplorerDriver": {
                return WebDriverManager.iedriver();
            }
            case "org.openqa.selenium.edge.EdgeDriver": {
                return WebDriverManager.edgedriver();
            }
            case "org.openqa.selenium.safari.SafariDriver": {
                return WebDriverManager.safaridriver();
            }
        }
        return WebDriverManager.voiddriver();
    }

    public static synchronized WebDriverManager getInstance() {
        WebDriverManager manager = WebDriverManager.voiddriver();
        String defaultBrowser = manager.config().getDefaultBrowser();
        try {
            if (defaultBrowser.contains(IN_DOCKER)) {
                defaultBrowser = defaultBrowser.substring(0, defaultBrowser.indexOf(IN_DOCKER));
                manager = WebDriverManager.getInstance(DriverManagerType.valueOf(defaultBrowser.toUpperCase(Locale.ROOT)));
                manager.dockerEnabled = true;
            } else {
                manager = WebDriverManager.getInstance(DriverManagerType.valueOf(defaultBrowser.toUpperCase(Locale.ROOT)));
            }
            return manager;
        }
        catch (Exception e) {
            log.error("Error trying to get manager for browser {}", (Object)defaultBrowser, (Object)e);
            return manager;
        }
    }

    public static Path zipFolder(Path sourceFolder) {
        Path zipFile = null;
        try {
            zipFile = Files.createTempFile("", ".zip", new FileAttribute[0]);
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(Files.newOutputStream(zipFile, new OpenOption[0]));
                 Stream<Path> paths = Files.walk(sourceFolder, new FileVisitOption[0]);){
                paths.filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                    ZipEntry zipEntry = new ZipEntry(FilenameUtils.separatorsToUnix((String)sourceFolder.relativize((Path)path).toString()));
                    try {
                        zipOutputStream.putNextEntry(zipEntry);
                        Files.copy(path, zipOutputStream);
                        zipOutputStream.closeEntry();
                    }
                    catch (IOException e) {
                        log.warn("Exception adding entry {} to zip", (Object)zipEntry, (Object)e);
                    }
                });
            }
            log.debug("Zipping {} folder to {}", (Object)sourceFolder, (Object)zipFile);
        }
        catch (IOException e) {
            log.warn("Exception zipping folder {}", (Object)sourceFolder, (Object)e);
        }
        return zipFile;
    }

    public static boolean isDockerAvailable() {
        String dockerInfo = Shell.runAndWait(false, "docker", "info");
        return !Config.isNullOrEmpty(dockerInfo) && !dockerInfo.contains("error") && dockerInfo.contains("linux");
    }

    public static boolean isOnline(String url) {
        try {
            return WebDriverManager.isOnline(new URL(url));
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static boolean isOnline(URL url) {
        try {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            return connection.getResponseCode() == 200;
        }
        catch (Exception e) {
            return false;
        }
    }

    public synchronized void setup() {
        this.cacheHandler = new CacheHandler(this.config());
        this.httpClient = new HttpClient(this.config());
        this.downloader = new Downloader(this.getHttpClient(), this.config(), this::postDownload);
        if (this.config().isClearDriverCache()) {
            this.clearDriverCache();
        }
        if (this.config().isClearResolutionCache()) {
            this.clearResolutionCache();
        }
        if (this.isUsingDocker() || !Config.isNullOrEmpty(this.config().getRemoteAddress())) {
            return;
        }
        if (this.getDriverManagerType() != null) {
            this.manage(this.getDriverVersion());
        }
    }

    public synchronized WebDriver create() {
        this.setup();
        return this.instantiateDriver();
    }

    public synchronized List<WebDriver> create(int numberOfBrowser) {
        ArrayList<WebDriver> browserList = new ArrayList<WebDriver>();
        for (int i = 0; i < numberOfBrowser; ++i) {
            if (i == 0) {
                this.setup();
            }
            browserList.add(this.instantiateDriver());
        }
        return browserList;
    }

    public Optional<Path> getBrowserPath() {
        return this.getVersionDetector().getBrowserPath(this.getDriverManagerType().getBrowserNameLowerCase());
    }

    public WebDriverManager browserInDocker() {
        this.dockerEnabled = true;
        return this;
    }

    protected boolean isUsingDocker() {
        return this.dockerEnabled && this.getDockerService().getDockerClient() != null;
    }

    public WebDriverManager dockerEnvVariables(String ... defaultEnvs) {
        this.config().setDockerEnvVariables(defaultEnvs);
        return this;
    }

    public WebDriverManager dockerDefaultArgs(String defaultArgs) {
        this.config().setDockerDefaultArgs(defaultArgs);
        return this;
    }

    public WebDriverManager dockerDaemonUrl(String daemonUrl) {
        this.config().setDockerDaemonUrl(daemonUrl);
        return this;
    }

    public WebDriverManager dockerNetwork(String network) {
        this.config().setDockerNetwork(network);
        return this;
    }

    public WebDriverManager dockerNetworkHost() {
        this.config().setDockerNetwork("host");
        return this;
    }

    public WebDriverManager dockerTimezone(String timezone) {
        this.config().setDockerTimezone(timezone);
        return this;
    }

    public WebDriverManager dockerLang(String lang) {
        this.config().setDockerLang(lang);
        return this;
    }

    public WebDriverManager dockerShmSize(String size) {
        this.config().setDockerShmSize(size);
        return this;
    }

    public WebDriverManager dockerTmpfsSize(String size) {
        this.config().setDockerTmpfsSize(size);
        return this;
    }

    public WebDriverManager dockerTmpfsMount(String mount) {
        this.config().setDockerTmpfsMount(mount);
        return this;
    }

    public WebDriverManager dockerVolumes(String ... volumes) {
        this.config().setDockerVolumes(String.join((CharSequence)",", volumes));
        return this;
    }

    public WebDriverManager dockerExtraHosts(String ... hosts) {
        this.config().setDockerExtraHosts(String.join((CharSequence)",", hosts));
        return this;
    }

    public WebDriverManager dockerScreenResolution(String screenResolution) {
        this.config().setDockerScreenResolution(screenResolution);
        return this;
    }

    public WebDriverManager dockerAvoidPulling() {
        this.config().setDockerAvoidPulling(true);
        return this;
    }

    public WebDriverManager avoidDockerLocalFallback() {
        this.config().setDockerLocalFallback(false);
        return this;
    }

    public WebDriverManager avoidShutdownHook() {
        this.config().setAvoidShutdownHook(true);
        return this;
    }

    public WebDriverManager avoidExternalConnections() {
        this.config().setAvoidExternalConnections(true);
        return this;
    }

    public WebDriverManager enableVnc() {
        this.config().setDockerEnabledVnc(true);
        return this;
    }

    public WebDriverManager viewOnly() {
        this.config().setDockerViewOnly(true);
        return this;
    }

    public WebDriverManager enableRecording() {
        this.config().setDockerEnabledRecording(true);
        return this;
    }

    public WebDriverManager disableTracing() {
        this.config().setEnableTracing(false);
        return this;
    }

    public WebDriverManager dockerRecordingPrefix(String prefix) {
        this.config().setDockerRecordingPrefix(prefix);
        return this;
    }

    public WebDriverManager dockerRecordingOutput(String path) {
        return this.dockerRecordingOutput(Paths.get(path, new String[0]));
    }

    public WebDriverManager dockerRecordingOutput(Path path) {
        this.config().setDockerRecordingOutput(path);
        return this;
    }

    public WebDriverManager dockerPrivateEndpoint(String endpoint) {
        this.config().setDockerPrivateEndpoint(endpoint);
        return this;
    }

    public WebDriverManager dockerStopTimeoutSec(Integer timeout) {
        this.config().setDockerStopTimeoutSec(timeout);
        return this;
    }

    public WebDriverManager watch() {
        this.watchEnabled = true;
        return this;
    }

    public WebDriverManager watchAndDisplay() {
        this.checkBrowserWatcherVersion();
        this.displayEnabled = true;
        return this;
    }

    public WebDriverManager disableCsp() {
        this.checkBrowserWatcherVersion();
        this.disableCsp = true;
        return this;
    }

    protected void checkBrowserWatcherVersion() {
        if (this.getDriverManagerType() != DriverManagerType.FIREFOX) {
            log.warn("This feature is not available in BrowserWatcher {}", (Object)this.getBrowserWatcherVersion());
        }
    }

    public WebDriverManager capabilities(Capabilities capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public WebDriverManager remoteAddress(String remoteAddress) {
        this.config().setRemoteAddress(remoteAddress);
        return this;
    }

    public WebDriverManager remoteAddress(URL remoteAddress) {
        this.config().setRemoteAddress(remoteAddress.toString());
        return this;
    }

    public WebDriverManager dockerCustomImage(String dockerImage) {
        this.config().setDockerCustomImage(dockerImage);
        return this;
    }

    public WebDriverManager driverVersion(String driverVersion) {
        this.setDriverVersion(driverVersion);
        return this;
    }

    public WebDriverManager browserVersion(String browserVersion) {
        this.setBrowserVersion(browserVersion);
        return this;
    }

    public WebDriverManager browserBinary(String browserBinary) {
        this.setBrowserBinary(browserBinary);
        return this;
    }

    public WebDriverManager architecture(Architecture architecture) {
        this.config().setArchitecture(architecture);
        return this;
    }

    public WebDriverManager arch32() {
        this.architecture(Architecture.X32);
        return this;
    }

    public WebDriverManager arch64() {
        this.architecture(Architecture.X64);
        return this;
    }

    public WebDriverManager arm64() {
        this.architecture(Architecture.ARM64);
        return this;
    }

    public WebDriverManager win() {
        this.operatingSystem(OperatingSystem.WIN);
        return this;
    }

    public WebDriverManager linux() {
        this.operatingSystem(OperatingSystem.LINUX);
        return this;
    }

    public WebDriverManager mac() {
        this.operatingSystem(OperatingSystem.MAC);
        return this;
    }

    public WebDriverManager operatingSystem(OperatingSystem os) {
        this.config().setOs(os.name());
        return this;
    }

    public WebDriverManager forceDownload() {
        this.config().setForceDownload(true);
        return this;
    }

    public WebDriverManager driverRepositoryUrl(URL url) {
        this.setDriverUrl(url);
        return this;
    }

    public WebDriverManager useMirror() {
        Optional<URL> mirrorUrl = this.getMirrorUrl();
        if (!mirrorUrl.isPresent()) {
            throw new WebDriverManagerException("Mirror URL not available");
        }
        this.config().setUseMirror(true);
        return this;
    }

    public WebDriverManager proxy(String proxy) {
        this.config().setProxy(proxy);
        return this;
    }

    public WebDriverManager proxyUser(String proxyUser) {
        this.config().setProxyUser(proxyUser);
        return this;
    }

    public WebDriverManager proxyPass(String proxyPass) {
        this.config().setProxyPass(proxyPass);
        return this;
    }

    public WebDriverManager useBetaVersions() {
        this.config().setUseBetaVersions(true);
        return this;
    }

    public WebDriverManager ignoreDriverVersions(String ... driverVersions) {
        this.config().setIgnoreVersions(driverVersions);
        return this;
    }

    public WebDriverManager gitHubToken(String gitHubToken) {
        this.config().setGitHubToken(gitHubToken);
        return this;
    }

    public WebDriverManager timeout(int timeout) {
        this.config().setTimeout(timeout);
        return this;
    }

    public WebDriverManager properties(String properties) {
        this.config().setProperties(properties);
        return this;
    }

    public WebDriverManager cachePath(String cachePath) {
        this.config().setCachePath(cachePath);
        return this;
    }

    public WebDriverManager resolutionCachePath(String resolutionCachePath) {
        this.config().setResolutionCachePath(resolutionCachePath);
        return this;
    }

    public WebDriverManager avoidExport() {
        this.config().setAvoidExport(true);
        return this;
    }

    public WebDriverManager avoidOutputTree() {
        this.config().setAvoidOutputTree(true);
        return this;
    }

    public WebDriverManager avoidBrowserDetection() {
        this.config().setAvoidBrowserDetection(true);
        return this;
    }

    public WebDriverManager avoidResolutionCache() {
        this.config().setAvoidResolutionCache(true);
        return this;
    }

    public WebDriverManager avoidFallback() {
        this.config().setAvoidFallback(true);
        return this;
    }

    public WebDriverManager avoidTmpFolder() {
        this.config().setAvoidTmpFolder(true);
        return this;
    }

    public WebDriverManager avoidUseChromiumDriverSnap() {
        this.config().setUseChromiumDriverSnap(false);
        return this;
    }

    public WebDriverManager avoidUseGeckoDriverSnap() {
        this.config().setUseGeckoDriverSnap(false);
        return this;
    }

    public WebDriverManager ttl(int seconds) {
        this.config().setTtl(seconds);
        return this;
    }

    public WebDriverManager ttlBrowsers(int seconds) {
        this.config().setTtlForBrowsers(seconds);
        return this;
    }

    public WebDriverManager browserVersionDetectionCommand(String browserVersionCommand) {
        this.config().setBrowserVersionDetectionCommand(browserVersionCommand);
        return this;
    }

    public WebDriverManager useLocalCommandsPropertiesFirst() {
        this.config().setCommandsPropertiesOnlineFirst(false);
        return this;
    }

    public WebDriverManager commandsPropertiesUrl(URL url) {
        this.config().setCommandsPropertiesUrl(url);
        return this;
    }

    public WebDriverManager clearResolutionCache() {
        this.getResolutionCache().clear();
        return this;
    }

    public WebDriverManager clearDriverCache() {
        File cacheFolder = this.config().getCacheFolder();
        try {
            log.debug("Clearing driver cache at {}", (Object)cacheFolder);
            FileUtils.cleanDirectory((File)cacheFolder);
        }
        catch (Exception e) {
            log.warn("Exception deleting driver cache at {}", (Object)cacheFolder, (Object)e);
        }
        return this;
    }

    public void reset() {
        this.config().reset();
        this.retryCount = 0;
        this.shutdownHook = false;
        this.dockerEnabled = false;
        this.watchEnabled = false;
        this.displayEnabled = false;
        this.capabilities = null;
        this.resolvedBrowserVersion = null;
    }

    public String getDownloadedDriverPath() {
        return this.downloadedDriverPath;
    }

    public String getDownloadedDriverVersion() {
        return this.downloadedDriverVersion;
    }

    public String getResolvedBrowserVersion() {
        return this.resolvedBrowserVersion;
    }

    public List<String> getDriverVersions() {
        ArrayList<String> driverVersionList = new ArrayList<String>();
        try {
            List<URL> driverUrls = this.isUseMirror() ? this.getDriversFromMirror(this.getMirrorUrl().get(), "") : this.getDriverUrls("");
            for (URL url : driverUrls) {
                String driverVersion = this.getCurrentVersion(url);
                if (driverVersion.isEmpty() || driverVersion.equalsIgnoreCase("icons") || driverVersion.equalsIgnoreCase(this.getDriverName()) || driverVersionList.contains(driverVersion)) continue;
                driverVersionList.add(driverVersion);
            }
            log.trace("Driver version list before sorting {}", driverVersionList);
            Collections.sort(driverVersionList, new VersionComparator());
            return driverVersionList;
        }
        catch (IOException e) {
            throw new WebDriverManagerException(e);
        }
    }

    public WebDriver getWebDriver() {
        List<WebDriver> driverList = this.getWebDriverList();
        return driverList.isEmpty() ? null : driverList.iterator().next();
    }

    public List<WebDriver> getWebDriverList() {
        List<Object> webdriverList = new ArrayList<WebDriver>();
        if (this.webDriverList.isEmpty()) {
            log.warn("WebDriver object(s) not available");
        } else {
            webdriverList = this.webDriverList.stream().map(WebDriverBrowser::getDriver).collect(Collectors.toList());
        }
        return webdriverList;
    }

    public synchronized void quit() {
        this.webDriverList.stream().forEach(this::quit);
        this.webDriverList.clear();
    }

    public synchronized void quit(WebDriver driver) {
        Optional<WebDriverBrowser> webDriverBrowser = this.findWebDriverBrowser(driver);
        if (webDriverBrowser.isPresent()) {
            WebDriverBrowser driverBrowser = webDriverBrowser.get();
            this.quit(driverBrowser);
            this.webDriverList.remove(driverBrowser);
        }
    }

    public synchronized void stopDockerRecording() {
        this.webDriverList.stream().forEach(this::stopDockerRecording);
    }

    public synchronized void stopDockerRecording(WebDriver driver) {
        Optional<WebDriverBrowser> webDriverBrowser = this.findWebDriverBrowser(driver);
        if (webDriverBrowser.isPresent()) {
            this.stopDockerRecording(webDriverBrowser.get());
        }
    }

    protected synchronized void stopDockerRecording(WebDriverBrowser driverBrowser) {
        DockerContainer recorderContainer;
        List<DockerContainer> dockerContainerList = driverBrowser.getDockerContainerList();
        if (dockerContainerList != null && !dockerContainerList.isEmpty() && (recorderContainer = dockerContainerList.get(0)).getImageId().equals(this.config().getDockerRecordingImage())) {
            this.getDockerService().stopAndRemoveContainer(recorderContainer);
            dockerContainerList.remove(0);
        }
    }

    protected synchronized void quit(WebDriverBrowser driverBrowser) {
        try {
            List<DockerContainer> dockerContainerList;
            SessionId sessionId;
            WebDriver driver = driverBrowser.getDriver();
            if (driver != null && (sessionId = ((RemoteWebDriver)driver).getSessionId()) != null) {
                log.debug("Quitting {}", (Object)driver);
                driver.quit();
            }
            if ((dockerContainerList = driverBrowser.getDockerContainerList()) != null) {
                dockerContainerList.stream().forEach(this.getDockerService()::stopAndRemoveContainer);
            }
        }
        catch (Exception e) {
            log.warn("Exception closing {} ({})", new Object[]{driverBrowser.getDriver(), e.getMessage(), e});
        }
    }

    public String getDockerBrowserContainerId(WebDriver driver) {
        return (String)this.getPropertyFromWebDriverBrowser(driver, WebDriverBrowser::getBrowserContainerId);
    }

    public String getDockerBrowserContainerId() {
        return (String)this.getPropertyFromFirstWebDriverBrowser(WebDriverBrowser::getBrowserContainerId);
    }

    public URL getDockerSeleniumServerUrl(WebDriver driver) {
        return (URL)this.getPropertyFromWebDriverBrowser(driver, WebDriverBrowser::getSeleniumServerUrl);
    }

    public URL getDockerSeleniumServerUrl() {
        return (URL)this.getPropertyFromFirstWebDriverBrowser(WebDriverBrowser::getSeleniumServerUrl);
    }

    public URL getDockerNoVncUrl(WebDriver driver) {
        return (URL)this.getPropertyFromWebDriverBrowser(driver, WebDriverBrowser::getNoVncUrl);
    }

    public URL getDockerNoVncUrl() {
        return (URL)this.getPropertyFromFirstWebDriverBrowser(WebDriverBrowser::getNoVncUrl);
    }

    public String getDockerVncUrl(WebDriver driver) {
        return (String)this.getPropertyFromWebDriverBrowser(driver, WebDriverBrowser::getVncUrl);
    }

    public String getDockerVncUrl() {
        return (String)this.getPropertyFromFirstWebDriverBrowser(WebDriverBrowser::getVncUrl);
    }

    public Path getDockerRecordingPath(WebDriver driver) {
        return (Path)this.getPropertyFromWebDriverBrowser(driver, WebDriverBrowser::getRecordingPath);
    }

    public Path getDockerRecordingPath() {
        return (Path)this.getPropertyFromFirstWebDriverBrowser(WebDriverBrowser::getRecordingPath);
    }

    public void startRecording(WebDriver driver) {
        Optional<WebDriverBrowser> webDriverBrowser = this.findWebDriverBrowser(driver);
        if (webDriverBrowser.isPresent()) {
            webDriverBrowser.get().startRecording();
        }
    }

    public void startRecording() {
        this.webDriverList.get(0).startRecording();
    }

    public void startRecording(WebDriver driver, String recordingName) {
        Optional<WebDriverBrowser> webDriverBrowser = this.findWebDriverBrowser(driver);
        if (webDriverBrowser.isPresent()) {
            webDriverBrowser.get().startRecording(recordingName);
        }
    }

    public void startRecording(String recordingName) {
        this.webDriverList.get(0).startRecording(recordingName);
    }

    public void stopRecording(WebDriver driver) {
        Optional<WebDriverBrowser> webDriverBrowser = this.findWebDriverBrowser(driver);
        if (webDriverBrowser.isPresent()) {
            webDriverBrowser.get().stopRecording();
        }
    }

    public void stopRecording() {
        this.webDriverList.get(0).stopRecording();
    }

    public Path getRecordingPath() {
        return this.webDriverList.get(0).getRecordingPath();
    }

    public Path getRecordingPath(WebDriver driver) {
        Optional<WebDriverBrowser> webDriverBrowser = this.findWebDriverBrowser(driver);
        if (webDriverBrowser.isPresent()) {
            return webDriverBrowser.get().getRecordingPath();
        }
        return null;
    }

    public String getRecordingBase64() {
        return this.webDriverList.get(0).getRecordingBase64();
    }

    public String getRecordingPath64(WebDriver driver) {
        Optional<WebDriverBrowser> webDriverBrowser = this.findWebDriverBrowser(driver);
        if (webDriverBrowser.isPresent()) {
            return webDriverBrowser.get().getRecordingBase64();
        }
        return null;
    }

    public List<Map<String, Object>> getLogs(WebDriver driver) {
        ArrayList<Map<String, Object>> logs = new ArrayList();
        if (this.getDriverManagerType() == DriverManagerType.FIREFOX) {
            logs = (List)this.getPropertyFromWebDriverBrowser(driver, WebDriverBrowser::readLogs);
        } else {
            LogEntries logEntries = driver.manage().logs().get("browser");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            for (LogEntry logEntry : logEntries) {
                HashMap<String, Object> entry = new HashMap<String, Object>();
                entry.put("datetime", dateFormat.format(new Date(logEntry.getTimestamp())));
                entry.put("source", "LoggingPreferences");
                entry.put("type", logEntry.getLevel());
                entry.put("message", logEntry.getMessage());
                logs.add(entry);
            }
        }
        return logs;
    }

    public List<Map<String, Object>> getLogs() {
        return this.getLogs(this.webDriverList.get(0).getDriver());
    }

    public synchronized DockerService getDockerService() {
        if (this.dockerService == null) {
            this.dockerService = new DockerService(this.config(), this.getResolutionCache());
        }
        return this.dockerService;
    }

    public WebDriverManager exportParameter(DriverManagerType driverManagerType) {
        switch (driverManagerType) {
            case CHROME: 
            case CHROMIUM: {
                this.exportParameter(this.config().getChromeDriverExport());
                break;
            }
            case FIREFOX: {
                this.exportParameter(this.config().getFirefoxDriverExport());
                break;
            }
            case EDGE: {
                this.exportParameter(this.config().getEdgeDriverExport());
                break;
            }
            case OPERA: {
                this.exportParameter(this.config().getOperaDriverExport());
                break;
            }
            case IEXPLORER: {
                this.exportParameter(this.config().getIExplorerDriverExport());
                break;
            }
        }
        return this;
    }

    protected Object getPropertyFromWebDriverBrowser(WebDriver driver, Function<WebDriverBrowser, Object> function) {
        Object object = null;
        Optional<WebDriverBrowser> webDriverBrowser = this.findWebDriverBrowser(driver);
        if (webDriverBrowser.isPresent()) {
            object = function.apply(webDriverBrowser.get());
        }
        return object;
    }

    protected Optional<WebDriverBrowser> findWebDriverBrowser(WebDriver driver) {
        for (WebDriverBrowser webDriver : this.webDriverList) {
            if (webDriver.getIdentityHash() != webDriver.calculateIdentityHash(driver)) continue;
            return Optional.of(webDriver);
        }
        return Optional.empty();
    }

    protected Object getPropertyFromFirstWebDriverBrowser(Function<WebDriverBrowser, Object> function) {
        Object object = null;
        if (this.webDriverList == null || this.webDriverList.isEmpty()) {
            log.warn("Property not available since there is no browsers in Docker");
        } else {
            object = function.apply(this.webDriverList.get(0));
        }
        return object;
    }

    protected void manage(String driverVersion) {
        if (this.config().getOperatingSystem().isLinux() && this.getDriverManagerType() == DriverManagerType.FIREFOX && this.config.isUseGeckoDriverSnap() && this.checkSnap(this.config().getGeckoDriverSnapPath())) {
            return;
        }
        try (HttpClient wdmHttpClient = this.getHttpClient();){
            String exportValue;
            if (Config.isUnknown(driverVersion)) {
                driverVersion = this.resolveDriverVersion(driverVersion);
            }
            if (this.getVersionDetector().isSnap() && this.config().isUseChromiumDriverSnap() && this.checkSnap(this.config().getChromiumDriverSnapPath())) {
                return;
            }
            Optional<Object> driverInCache = Optional.empty();
            if (!Config.isUnknown(driverVersion)) {
                driverInCache = this.cacheHandler.getDriverFromCache(driverVersion, this.getDriverName(), this.getDriverManagerType(), this.config().getArchitecture(), this.config().getOs());
            }
            if (driverInCache.isPresent() && !this.config().isForceDownload()) {
                log.debug("Driver {} {} found in cache", (Object)this.getDriverName(), (Object)this.getDriverVersionLabel(driverVersion));
                exportValue = (String)driverInCache.get();
                this.downloadedDriverVersion = driverVersion;
            } else {
                exportValue = this.download(driverVersion);
            }
            this.exportDriver(exportValue);
        }
        catch (Exception e) {
            this.handleException(e, driverVersion);
        }
    }

    protected boolean checkSnap(String driverSnapPath) {
        File snapDriverPath = new File(driverSnapPath);
        boolean existsSnap = snapDriverPath.exists();
        if (existsSnap) {
            log.debug("Found {} snap", (Object)this.getDriverManagerType());
            this.exportDriver(driverSnapPath);
        }
        return existsSnap;
    }

    protected String resolveDriverVersion(String driverVersion) {
        String preferenceKey = this.getKeyForResolutionCache();
        Optional<String> optionalBrowserVersion = Optional.ofNullable(this.getBrowserVersion()).filter(StringUtils::isNotEmpty);
        if (!optionalBrowserVersion.isPresent()) {
            optionalBrowserVersion = this.getValueFromResolutionCache(preferenceKey);
        }
        if (!optionalBrowserVersion.isPresent()) {
            optionalBrowserVersion = this.detectBrowserVersion();
        }
        if (optionalBrowserVersion.isPresent()) {
            this.resolvedBrowserVersion = optionalBrowserVersion.get();
            preferenceKey = this.getKeyForResolutionCache() + this.resolvedBrowserVersion;
            Optional<String> optionalDriverVersion = this.getValueFromResolutionCache(preferenceKey);
            if (!optionalDriverVersion.isPresent()) {
                optionalDriverVersion = this.getDriverVersionFromRepository(optionalBrowserVersion);
            }
            if (optionalDriverVersion.isPresent()) {
                driverVersion = optionalDriverVersion.get();
                log.info("Using {} {} (resolved driver for {} {})", new Object[]{this.getDriverName(), driverVersion, this.getDriverManagerType().getBrowserName(), this.resolvedBrowserVersion});
                if (this.config().getIgnoreVersions().contains(driverVersion)) {
                    String formerBrowserVersion = String.valueOf(Integer.parseInt(this.resolvedBrowserVersion) - 1);
                    log.info("The driver {} {} is configured to be ignored ... trying again resolving driver for former version of {} (i.e. {})", new Object[]{this.getDriverName(), driverVersion, this.getDriverManagerType(), formerBrowserVersion});
                    this.setBrowserVersion(formerBrowserVersion);
                    return this.resolveDriverVersion("");
                }
                this.storeInResolutionCache(preferenceKey, driverVersion, this.resolvedBrowserVersion);
            }
        }
        if (Config.isUnknown(driverVersion)) {
            String browserVersionStr = optionalBrowserVersion.isPresent() ? " " + optionalBrowserVersion.get() : "";
            log.debug("The driver version for {}{} is unknown ... trying with latest", (Object)this.getDriverManagerType(), (Object)browserVersionStr);
            Optional<String> latestDriverVersionFromRepository = this.getLatestDriverVersionFromRepository();
            if (latestDriverVersionFromRepository.isPresent()) {
                driverVersion = latestDriverVersionFromRepository.get();
            }
        }
        return driverVersion;
    }

    protected String download(String driverVersion) throws IOException {
        URL url;
        if (driverVersion.startsWith(".")) {
            driverVersion = driverVersion.substring(1);
        }
        Optional<URL> optionalURL = this.buildUrl(driverVersion);
        if (this.config.isAvoidExternalConnections() && optionalURL.isPresent()) {
            url = optionalURL.get();
            this.downloadedDriverVersion = driverVersion;
        } else {
            UrlHandler urlHandler = this.createUrlHandler(driverVersion);
            url = urlHandler.getCandidateUrl();
            this.downloadedDriverVersion = urlHandler.getDriverVersion();
        }
        return this.downloader.download(url, this.downloadedDriverVersion, this.getDriverName(), this.getDriverManagerType());
    }

    protected void exportDriver(String variableValue) {
        this.downloadedDriverPath = variableValue;
        Optional<String> exportParameter = this.getExportParameter();
        if (!this.config().isAvoidExport() && exportParameter.isPresent()) {
            String variableName = exportParameter.get();
            log.info("Exporting {} as {}", (Object)variableName, (Object)variableValue);
            System.setProperty(variableName, variableValue);
        } else {
            log.info("Driver location: {}", (Object)variableValue);
        }
    }

    protected void storeInResolutionCache(String preferenceKey, String resolvedDriverVersion, String resolvedBrowserVersion) {
        if (this.getVersionDetector().isSnap()) {
            return;
        }
        if (this.useResolutionCache()) {
            this.getResolutionCache().putValueInResolutionCacheIfEmpty(this.getKeyForResolutionCache(), resolvedBrowserVersion, this.config().getTtlForBrowsers());
            this.getResolutionCache().putValueInResolutionCacheIfEmpty(preferenceKey, resolvedDriverVersion, this.config().getTtl());
        }
    }

    protected Optional<String> getValueFromResolutionCache(String preferenceKey) {
        Optional<String> optionalBrowserVersion = Optional.empty();
        if (this.useResolutionCacheWithKey(preferenceKey)) {
            optionalBrowserVersion = Optional.of(this.getResolutionCache().getValueFromResolutionCache(preferenceKey));
        }
        return optionalBrowserVersion;
    }

    protected List<File> postDownload(File archive) {
        File parentFolder = archive.getParentFile();
        Collection ls = FileUtils.listFiles((File)parentFolder, null, (boolean)true);
        ArrayList<File> listFiles = new ArrayList<File>();
        for (File f : ls) {
            if (f.getName().startsWith(this.getDriverName()) && this.getDriverName().contains(FilenameUtils.removeExtension((String)f.getName()))) {
                log.trace("Found driver in post-download: {}", (Object)f);
                listFiles.add(f);
                continue;
            }
            Downloader.deleteFile(f);
        }
        if (!listFiles.isEmpty()) {
            return listFiles;
        }
        throw new WebDriverManagerException("Driver " + this.getDriverName() + " not found (using temporal folder " + parentFolder + ")");
    }

    protected Optional<String> getBrowserVersionFromTheShell() {
        return this.getVersionDetector().getBrowserVersionFromTheShell(this.getDriverManagerType().getBrowserNameLowerCase(), this.getBrowserBinary());
    }

    protected Optional<String> detectBrowserVersion() {
        Optional<String> optionalBrowserVersion;
        if (this.config().isAvoidBrowserDetection()) {
            return Optional.empty();
        }
        String driverManagerTypeLowerCase = this.getDriverManagerType().getNameLowerCase();
        if (this.useResolutionCacheWithKey(driverManagerTypeLowerCase)) {
            optionalBrowserVersion = Optional.of(this.getResolutionCache().getValueFromResolutionCache(driverManagerTypeLowerCase));
            log.trace("Detected {} version {}", (Object)this.getDriverManagerType(), optionalBrowserVersion);
        } else {
            optionalBrowserVersion = this.getBrowserVersionFromTheShell();
        }
        return optionalBrowserVersion;
    }

    protected boolean useResolutionCacheWithKey(String key) {
        return this.useResolutionCache() && this.getResolutionCache().checkKeyInResolutionCache(key);
    }

    protected boolean useResolutionCache() {
        return !this.config().isAvoidResolutionCache();
    }

    protected boolean isUseMirror() {
        return this.getMirrorUrl().isPresent() && this.config().isUseMirror();
    }

    protected boolean isChrome() {
        DriverManagerType managerType = this.getDriverManagerType();
        return managerType != null && (managerType == DriverManagerType.CHROME || managerType == DriverManagerType.CHROMIUM);
    }

    protected String getCurrentVersion(URL url) {
        String urlFile = url.getFile();
        if (this.isUseMirror()) {
            int i = urlFile.lastIndexOf(SLASH);
            int j = urlFile.substring(0, i).lastIndexOf(SLASH) + 1;
            return urlFile.substring(j, i);
        }
        if (urlFile.contains(CFT_LABEL)) {
            int i = urlFile.indexOf(CFT_LABEL) + CFT_LABEL.length() + 1;
            int j = urlFile.indexOf(SLASH, i);
            return urlFile.substring(i, j);
        }
        String currentVersion = "";
        String pattern = "/([^/]*?)/[^/]*?" + this.getShortDriverName();
        Matcher matcher = Pattern.compile(pattern, 2).matcher(urlFile);
        boolean find = matcher.find();
        if (find) {
            currentVersion = matcher.group(1);
        } else {
            log.trace("Version not found in URL {}", (Object)url);
        }
        return currentVersion;
    }

    protected void handleException(Exception e, String driverVersion) {
        String driverVersionStr = this.getDriverVersionLabel(driverVersion);
        String errorMessage = String.format("There was an error managing %s %s (%s)", this.getDriverName(), driverVersionStr, e.getMessage());
        if (this.retryCount == 0 && !this.config().isAvoidFallback()) {
            ++this.retryCount;
            this.fallback(e, errorMessage);
        } else if (this.retryCount == 1 && !this.config().isAvoidFallback()) {
            this.fallback(e, errorMessage);
        } else {
            log.error("{}", (Object)errorMessage, (Object)e);
            throw new WebDriverManagerException(e);
        }
    }

    protected void fallback(Exception e, String errorMessage) {
        this.config().setAvoidBrowserDetection(true);
        String driverVersion = "";
        this.setBrowserVersion("");
        ++this.retryCount;
        log.warn("{} ... trying again using latest driver stored in cache", (Object)errorMessage);
        if (log.isTraceEnabled()) {
            log.trace("Error trace: ", (Throwable)e);
        }
        this.manage(driverVersion);
    }

    protected UrlHandler createUrlHandler(String driverVersion) throws IOException {
        boolean continueSearchingVersion;
        boolean isMirrorCfT;
        List<URL> candidateUrls = this.getDriverUrls(driverVersion);
        String shortDriverName = this.getShortDriverName();
        UrlHandler urlHandler = new UrlHandler(this.config(), candidateUrls, driverVersion, shortDriverName, this::buildUrl);
        boolean getLatest = Config.isUnknown(driverVersion);
        boolean bl = isMirrorCfT = this.isChrome() && this.isUseMirror() && VersionDetector.isCfT(driverVersion);
        do {
            if (!isMirrorCfT) {
                urlHandler.filterByDriverName(shortDriverName);
            }
            if (getLatest) {
                urlHandler.filterByLatestVersion(this::getCurrentVersion);
            } else {
                urlHandler.filterByVersion(driverVersion);
            }
            String resolvedDriverVersion = urlHandler.getDriverVersion();
            if (resolvedDriverVersion == null) break;
            log.debug("Driver to be downloaded {} {}", (Object)shortDriverName, (Object)resolvedDriverVersion);
            if (!Config.isNullOrEmpty(this.resolvedBrowserVersion)) {
                this.storeInResolutionCache(this.getKeyForResolutionCache() + this.resolvedBrowserVersion, resolvedDriverVersion, this.resolvedBrowserVersion);
            }
            log.trace("Driver URLs after filtering for version: {}", urlHandler.getCandidateUrls());
            String os = this.config().getOs();
            Architecture architecture = this.config().getArchitecture();
            boolean isEdgeArm64 = architecture == Architecture.ARM64 && this.getDriverManagerType() == DriverManagerType.EDGE;
            boolean isMac = this.config().getOperatingSystem().isMac();
            if (!isEdgeArm64 || isMac) {
                urlHandler.filterByOs(this.getDriverName(), os);
            }
            urlHandler.filterByArch(architecture);
            urlHandler.filterByIgnoredVersions(this.config().getIgnoreVersions());
            urlHandler.filterByBeta(this.config().isUseBetaVersions());
            boolean bl2 = continueSearchingVersion = urlHandler.hasNoCandidateUrl() && getLatest;
            if (!continueSearchingVersion) continue;
            log.info("No proper driver found for {} {} ... seeking another version", (Object)this.getDriverName(), (Object)this.getDriverVersionLabel(driverVersion));
            urlHandler.resetList(candidateUrls);
            candidateUrls = urlHandler.getCandidateUrls();
        } while (continueSearchingVersion);
        if (isMirrorCfT) {
            List<URL> driversFromMirror = this.getMirrorUrls(urlHandler.getCandidateUrl(), "");
            urlHandler.setCandidateUrls(driversFromMirror);
            urlHandler.filterByDriverName(shortDriverName);
        }
        return urlHandler;
    }

    protected List<URL> getDriversFromMirror(URL driverUrl, String driverVersion) throws IOException {
        if (this.isChrome() && VersionDetector.isCfT(driverVersion)) {
            driverUrl = this.config().getChromeDriverCfTMirrorUrl();
            this.config().setChromeDriverCfTMirrorUrl(driverUrl);
        }
        ArrayList<URL> urls = new ArrayList();
        if (Config.isNullOrEmpty(driverVersion)) {
            List<URL> mirrorUrls = this.getMirrorUrls(driverUrl, "");
            for (URL url : mirrorUrls) {
                if (!url.getPath().endsWith(SLASH)) continue;
                urls.addAll(this.getMirrorUrls(url, ""));
            }
        } else {
            urls = this.getMirrorUrls(driverUrl, driverVersion + SLASH);
        }
        return urls;
    }

    private List<URL> getMirrorUrls(URL driverUrl, String versionPath) throws IOException {
        List<URL> urls;
        HttpGet get = this.getHttpClient().createHttpGet(new URL(driverUrl, versionPath));
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getHttpClient().execute((ClassicHttpRequest)get).getEntity().getContent()));){
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            NpmMirror[] releaseArray = (NpmMirror[])gson.fromJson((Reader)reader, NpmMirror[].class);
            urls = Arrays.stream(releaseArray).map(NpmMirror::getUrl).collect(Collectors.toList());
        }
        return urls;
    }

    protected NamespaceContext getNamespaceContext() {
        return null;
    }

    protected Optional<NamespaceContext> getS3NamespaceContext() {
        return Optional.of(S3_NAMESPACE_CONTEXT);
    }

    protected void logSeekRepo(URL driverUrl) {
        log.info("Reading {} to seek {}", (Object)driverUrl, (Object)this.getDriverName());
    }

    public static Document loadXML(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setExpandEntityReferences(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new InputSource(new ByteArrayInputStream(IOUtils.toByteArray((InputStream)inputStream))));
    }

    protected InputStream openGitHubConnection(URL driverUrl) throws IOException {
        HttpGet get = this.getHttpClient().createHttpGet(driverUrl);
        String gitHubToken = this.config().getGitHubToken();
        if (Config.isNullOrEmpty(gitHubToken)) {
            gitHubToken = System.getenv("GITHUB_TOKEN");
        }
        if (!Config.isNullOrEmpty(gitHubToken)) {
            get.addHeader("Authorization", (Object)("token " + gitHubToken));
        }
        return this.getHttpClient().execute((ClassicHttpRequest)get).getEntity().getContent();
    }

    protected List<URL> getDriversFromGitHub(String driverVersion) throws IOException {
        List<URL> urls;
        URL driverUrl = this.getDriverUrl();
        this.logSeekRepo(driverUrl);
        if (this.isUseMirror()) {
            urls = this.getDriversFromMirror(this.getMirrorUrl().get(), driverVersion);
        } else {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.openGitHubConnection(driverUrl)));){
                GsonBuilder gsonBuilder = new GsonBuilder();
                Gson gson = gsonBuilder.create();
                GitHubApi[] releaseArray = (GitHubApi[])gson.fromJson((Reader)reader, GitHubApi[].class);
                urls = new ArrayList<URL>();
                for (GitHubApi release : releaseArray) {
                    if (release == null) continue;
                    List<LinkedTreeMap<String, Object>> assets = release.getAssets();
                    for (LinkedTreeMap<String, Object> asset : assets) {
                        urls.add(new URL(asset.get((Object)"browser_download_url").toString()));
                    }
                }
            }
        }
        return urls;
    }

    protected HttpClient getHttpClient() {
        return Optional.ofNullable(this.httpClient).orElse(new HttpClient(this.config()));
    }

    protected ResolutionCache getResolutionCache() {
        return Optional.ofNullable(this.resolutionCache).orElseGet(() -> {
            this.resolutionCache = new ResolutionCache(this.config());
            return this.resolutionCache;
        });
    }

    protected VersionDetector getVersionDetector() {
        return Optional.ofNullable(this.versionDetector).orElseGet(() -> {
            this.versionDetector = new VersionDetector(this.config(), this.getHttpClient());
            return this.versionDetector;
        });
    }

    protected WebDriverCreator getWebDriverCreator() {
        return Optional.ofNullable(this.webDriverCreator).orElseGet(() -> {
            this.webDriverCreator = new WebDriverCreator(this.config());
            return this.webDriverCreator;
        });
    }

    protected FilenameFilter getFolderFilter() {
        return (dir, name) -> dir.isDirectory() && name.toLowerCase(Locale.ROOT).contains(this.getDriverName());
    }

    protected Charset getVersionCharset() {
        return Charset.defaultCharset();
    }

    protected String getLatestVersionLabel() {
        return LATEST_RELEASE;
    }

    protected Optional<String> getOsLabel() {
        return Optional.empty();
    }

    protected Optional<String> getDriverVersionFromRepository(Optional<String> driverVersion) {
        return this.getVersionDetector().getDriverVersionFromRepository(driverVersion, this.getDriverUrl(), this.getVersionCharset(), this.getDriverName(), this.getLatestVersionLabel(), LATEST_RELEASE, this.getOsLabel());
    }

    protected URL getDriverUrlCkeckingMirror(URL url) {
        Optional<URL> mirrorUrl;
        if (this.config().isUseMirror() && (mirrorUrl = this.getMirrorUrl()).isPresent()) {
            return mirrorUrl.get();
        }
        return url;
    }

    protected Optional<String> getLatestDriverVersionFromRepository() {
        return Optional.empty();
    }

    protected String getShortDriverName() {
        return this.getDriverName();
    }

    protected String getKeyForResolutionCache() {
        return this.getDriverManagerType().getNameLowerCase();
    }

    protected String getDriverVersionLabel(String driverVersion) {
        return Config.isUnknown(driverVersion) ? "(latest version)" : driverVersion;
    }

    protected Optional<URL> buildUrl(String driverVersion) {
        return Optional.empty();
    }

    protected synchronized WebDriver instantiateDriver() {
        WebDriver driver = null;
        DriverManagerType managerType = this.getDriverManagerType();
        try {
            Capabilities caps;
            boolean watcher;
            String remoteAddress = this.config().getRemoteAddress();
            Path extensionPath = null;
            boolean bl = watcher = this.watchEnabled || this.displayEnabled;
            if (watcher) {
                extensionPath = this.getBrowserWatcherAsPath();
                caps = Optional.ofNullable(this.capabilities).orElse(this.getCapabilities());
                switch (managerType) {
                    case CHROME: 
                    case CHROMIUM: 
                    case EDGE: 
                    case OPERA: {
                        this.initBrowserWatcherForChromium(extensionPath, caps);
                        break;
                    }
                    case FIREFOX: {
                        log.trace("Extension to be installed after driver instantiation");
                        break;
                    }
                    default: {
                        log.warn("Watcher not available for {}", (Object)managerType);
                    }
                }
            }
            if (this.isUsingDocker()) {
                driver = this.createDockerWebDriver();
            } else if (!Config.isNullOrEmpty(remoteAddress)) {
                caps = Optional.ofNullable(this.capabilities).orElse(this.getCapabilities());
                driver = this.getWebDriverCreator().createRemoteWebDriver(remoteAddress, caps);
                this.webDriverList.add(new WebDriverBrowser(driver, this.getDriverManagerType().getBrowserNameLowerCase(), this.config().getOperatingSystem()));
            } else {
                driver = this.createLocalWebDriver();
            }
            if (watcher && managerType == DriverManagerType.FIREFOX) {
                WebDriver augmentedDriver = new Augmenter().augment(driver);
                ((HasExtensions)augmentedDriver).installExtension(extensionPath, Boolean.valueOf(true));
            }
        }
        catch (Exception e) {
            throw new WebDriverManagerException("There was an error creating WebDriver object for " + managerType.getBrowserName(), e);
        }
        this.addShutdownHookIfRequired();
        return driver;
    }

    protected void initBrowserWatcherForChromium(Path extensionPath, Capabilities caps) {
        DriverManagerType managerType = this.getDriverManagerType();
        LoggingPreferences logs = new LoggingPreferences();
        logs.enable("browser", Level.ALL);
        String logCapName = managerType == DriverManagerType.EDGE ? "ms:loggingPrefs" : "goog:loggingPrefs";
        ((ChromiumOptions)caps).setCapability(logCapName, (Object)logs);
        String allowExtensionFlag = this.resolvedBrowserVersion != null && Integer.parseInt(this.resolvedBrowserVersion) < 112 ? "--whitelisted-extension-id=" : "--allowlisted-extension-id=";
        ((ChromiumOptions)caps).addExtensions(new File[]{extensionPath.toFile()});
        this.capabilities = ((ChromiumOptions)caps).addArguments(new String[]{allowExtensionFlag + BROWSER_WATCHER_ID, "--disable-features=DisableLoadExtensionCommandLineSwitch"});
    }

    protected Path getBrowserWatcherAsPath() throws IOException {
        String extFilename = "/browserwatcher-%s%s.crx";
        String extModifier = "";
        if (this.getDriverManagerType() == DriverManagerType.FIREFOX) {
            if (this.displayEnabled && !this.disableCsp) {
                extModifier = "display-";
            } else if (!this.displayEnabled && this.disableCsp) {
                extModifier = "csp-";
            } else if (this.displayEnabled && this.disableCsp) {
                extModifier = "display-csp-";
            }
        }
        InputStream extensionInputStream = Config.class.getResourceAsStream(String.format(extFilename, extModifier, this.getBrowserWatcherVersion()));
        Path extensionPath = Files.createTempFile("", ".crx", new FileAttribute[0]);
        File extensionFile = extensionPath.toFile();
        extensionFile.deleteOnExit();
        FileUtils.copyInputStreamToFile((InputStream)extensionInputStream, (File)extensionFile);
        return extensionPath;
    }

    protected String getBrowserWatcherVersion() {
        String browserWatcherVersion = this.getDriverManagerType() == DriverManagerType.FIREFOX ? "1.2.0" : this.config().getBrowserWatcherVersion();
        return browserWatcherVersion;
    }

    protected Capabilities getMergedCapabilities() {
        Capabilities caps = this.getCapabilities();
        if (this.capabilities != null) {
            caps = caps.merge(this.capabilities);
        }
        return caps;
    }

    protected void addShutdownHookIfRequired() {
        if (!this.shutdownHook && !this.config().isAvoidShutdownHook()) {
            Runtime.getRuntime().addShutdownHook(new Thread("wdm-shutdown-hook"){

                @Override
                public void run() {
                    try {
                        WebDriverManager.this.quit();
                    }
                    catch (Exception e) {
                        log.warn("Exception in wdm-shutdown-hook ({})", (Object)e.getMessage());
                    }
                }
            });
            this.shutdownHook = true;
        }
    }

    protected WebDriver createDockerWebDriver() {
        String browserImage;
        String browserName = this.getKeyForResolutionCache();
        String browserVersion = this.getBrowserVersion();
        String browserCacheKey = browserName + "-container-";
        String dockerCustomImage = this.config().getDockerCustomImage();
        if (!Config.isNullOrEmpty(dockerCustomImage)) {
            browserImage = dockerCustomImage;
            browserVersion = this.getDockerService().getVersionFromImage(browserImage);
            browserCacheKey = browserCacheKey + "custom";
        } else {
            if (Config.isUnknown(browserVersion) || this.getDockerService().isBrowserVersionLatestMinus(browserVersion)) {
                browserCacheKey = browserCacheKey + (Config.isNullOrEmpty(browserVersion) ? "latest" : browserVersion);
                browserVersion = this.getDockerService().getDockerImageVersion(this.getDriverManagerType(), browserCacheKey, browserName, browserVersion);
            } else {
                if (!this.getDockerService().isBrowserVersionWildCard(browserVersion) && !browserVersion.contains(".")) {
                    browserVersion = browserVersion + ".0";
                }
                browserCacheKey = browserCacheKey + browserVersion;
            }
            browserImage = this.getDockerService().getDockerImage(this.getDriverManagerType(), browserName, browserVersion);
        }
        DockerContainer browserContainer = this.getDockerService().startBrowserContainer(browserImage, browserCacheKey, browserVersion);
        browserContainer.setBrowserName(browserName);
        String seleniumServerUrl = browserContainer.getContainerUrl();
        WebDriverBrowser driverBrowser = new WebDriverBrowser(this.getDriverManagerType().getBrowserNameLowerCase(), this.config().getOperatingSystem());
        driverBrowser.addDockerContainer(browserContainer);
        driverBrowser.setSeleniumServerUrl(seleniumServerUrl);
        log.trace("The Selenium Server URL is {}", (Object)seleniumServerUrl);
        driverBrowser.setBrowserContainerId(browserContainer.getContainerId());
        this.webDriverList.add(driverBrowser);
        WebDriver driver = this.getWebDriverCreator().createRemoteWebDriver(seleniumServerUrl, this.getMergedCapabilities());
        driverBrowser.setDriver(driver);
        String sessionId = this.getWebDriverCreator().getSessionId(driverBrowser.getDriver());
        browserContainer.setSessionId(sessionId);
        if (this.config().isDockerEnabledVnc()) {
            String noVncImage = this.config().getDockerNoVncImage();
            String noVncVersion = this.getDockerService().getVersionFromImage(noVncImage);
            DockerContainer noVncContainer = this.getDockerService().startNoVncContainer(noVncImage, "novnc-container", noVncVersion, browserContainer);
            driverBrowser.addDockerContainer(noVncContainer);
            String noVncUrl = noVncContainer.getContainerUrl();
            driverBrowser.setNoVncUrl(noVncUrl);
            driverBrowser.setVncUrl(browserContainer.getVncAddress());
            log.info("Docker session noVNC URL: {}", (Object)noVncUrl);
        }
        if (this.config().isDockerEnabledRecording()) {
            String recorderImage = this.config().getDockerRecordingImage();
            String recorderVersion = this.getDockerService().getVersionFromImage(recorderImage);
            DockerContainer recorderContainer = this.getDockerService().startRecorderContainer(recorderImage, "recorder-container", recorderVersion, browserContainer);
            driverBrowser.addDockerContainer(recorderContainer, 0);
            Path recordingPath = recorderContainer.getRecordingPath();
            driverBrowser.setRecordingPath(recordingPath);
            log.info("Starting recording {}", (Object)recordingPath);
        }
        return driverBrowser.getDriver();
    }

    protected synchronized WebDriver createLocalWebDriver() throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        WebDriver driver = null;
        DriverManagerType managerType = this.getDriverManagerType();
        if (managerType != null) {
            if (managerType == DriverManagerType.CHROMIUM) {
                this.capabilities = this.getCapabilities();
            }
            Class<?> browserClass = managerType == DriverManagerType.OPERA ? Class.forName("org.openqa.selenium.chrome.ChromeDriver") : Class.forName(managerType.browserClass());
            driver = this.getWebDriverCreator().createLocalWebDriver(browserClass, this.capabilities);
            this.webDriverList.add(new WebDriverBrowser(driver, this.getDriverManagerType().getBrowserNameLowerCase(), this.config().getOperatingSystem()));
        }
        return driver;
    }

    protected Capabilities getCapabilities() {
        return new MutableCapabilities();
    }

    protected void addDefaultArgumentsForDocker(Capabilities options) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (this.isUsingDocker()) {
            Method addArgumentsMethod = options.getClass().getMethod("addArguments", List.class);
            List<String> defaultArgs = Arrays.asList(this.config().getDockerDefaultArgs().split(","));
            addArgumentsMethod.invoke((Object)options, defaultArgs);
        }
    }

    protected static void logCliError(String browserForResolving, String browserForDocker, int port) {
        log.error("The valid arguments for WebDriverManager CLI are:");
        log.error("1. For resolving drivers locally:");
        log.error("\t{} browserName <browserVersion>", (Object)CLI_RESOLVER);
        log.error("(where browserName is: {})", (Object)browserForResolving);
        log.error("");
        log.error("2. For running a browser in a Docker (and use it trough noVNC):");
        log.error("\t{} browserName <browserVersion>", (Object)CLI_DOCKER);
        log.error("(where browserName is: {})", (Object)browserForDocker);
        log.error("");
        log.error("3. For starting WebDriverManager Server:");
        log.error("\t{} <port>", (Object)CLI_SERVER);
        log.error("(where the default port is {})", (Object)port);
    }

    protected static void resolveLocal(String[] args, String validBrowsers) {
        String browserName = args[1];
        log.info("Using WebDriverManager to resolve {}", (Object)browserName);
        try {
            WebDriverManager wdm = WebDriverManager.getInstance(browserName).avoidExport().cachePath(".").forceDownload().avoidResolutionCache();
            if (browserName.equalsIgnoreCase("iexplorer")) {
                wdm.operatingSystem(OperatingSystem.WIN);
            }
            if (args.length > 2) {
                wdm.browserVersion(args[2]);
            }
            if (SystemUtils.IS_OS_LINUX && wdm.getDockerService().isRunningInsideDocker()) {
                wdm.avoidBrowserDetection();
            }
            wdm.avoidOutputTree().setup();
        }
        catch (Exception e) {
            log.error("Driver for {} not found (valid browsers {})", (Object)browserName, (Object)validBrowsers);
        }
    }

    protected static void runInDocker(String[] args, String validBrowsers) {
        String browserName = args[1];
        log.info("Using WebDriverManager to run {} in Docker", (Object)browserName);
        try {
            WebDriverManager wdm = WebDriverManager.getInstance(browserName).browserInDocker();
            if (args.length > 2) {
                wdm.browserVersion(args[2]);
            }
            wdm.enableVnc().avoidResolutionCache().create();
            log.info("Press ENTER to exit");
            Scanner scanner = new Scanner(System.in);
            scanner.nextLine();
            scanner.close();
            wdm.quit();
        }
        catch (Exception e) {
            log.error("Exception running {} in Docker (valid browsers {})", new Object[]{browserName, validBrowsers, e});
        }
    }

    protected static void startServer(String[] args, int port) {
        if (args.length > 1 && StringUtils.isNumeric((CharSequence)args[1])) {
            port = Integer.parseInt(args[1]);
        }
        new WdmServer(port);
    }

    public static void main(String[] args) {
        String browserForResolving = "chrome|edge|firefox|opera|chromium|iexplorer";
        String browserForNoVnc = "chrome|edge|firefox|chromium";
        int port = new Config().getServerPort();
        int numArgs = args.length;
        if (numArgs <= 0) {
            WebDriverManager.logCliError(browserForResolving, browserForNoVnc, port);
        } else {
            String arg = args[0].toLowerCase(Locale.ROOT);
            if (arg.equalsIgnoreCase(CLI_SERVER)) {
                WebDriverManager.startServer(args, port);
            } else if (arg.equalsIgnoreCase(CLI_RESOLVER) && numArgs > 1) {
                WebDriverManager.resolveLocal(args, browserForResolving);
            } else if (arg.equalsIgnoreCase(CLI_DOCKER) && numArgs > 1) {
                WebDriverManager.runInDocker(args, browserForNoVnc);
            } else {
                WebDriverManager.logCliError(browserForResolving, browserForNoVnc, port);
            }
        }
    }
}

