/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.support;

import java.io.Serializable;
import org.socialsignin.spring.data.dynamodb.core.DynamoDBOperations;
import org.socialsignin.spring.data.dynamodb.mapping.DynamoDBMappingContext;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBRepositoryFactory;
import org.socialsignin.spring.data.dynamodb.repository.util.DynamoDBMappingContextProcessor;
import org.socialsignin.spring.data.dynamodb.repository.util.Entity2DynamoDBTableSynchronizer;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;

public class DynamoDBRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends RepositoryFactoryBeanSupport<T, S, ID> {
    private DynamoDBOperations dynamoDBOperations;
    private Entity2DynamoDBTableSynchronizer<S, ID> tableSynchronizer;
    private DynamoDBMappingContextProcessor<S, ID> dynamoDBMappingContextProcessor;

    public DynamoDBRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    protected RepositoryFactorySupport createRepositoryFactory() {
        assert (this.dynamoDBOperations != null);
        assert (this.tableSynchronizer != null);
        assert (this.dynamoDBMappingContextProcessor != null);
        DynamoDBRepositoryFactory dynamoDBRepositoryFactory = new DynamoDBRepositoryFactory(this.dynamoDBOperations);
        dynamoDBRepositoryFactory.addRepositoryProxyPostProcessor(this.tableSynchronizer);
        dynamoDBRepositoryFactory.addRepositoryProxyPostProcessor(this.dynamoDBMappingContextProcessor);
        return dynamoDBRepositoryFactory;
    }

    @Required
    public void setDynamoDBMappingContextProcessor(DynamoDBMappingContextProcessor<S, ID> dynamoDBMappingContextProcessor) {
        this.dynamoDBMappingContextProcessor = dynamoDBMappingContextProcessor;
    }

    @Required
    public void setEntity2DynamoDBTableSynchronizer(Entity2DynamoDBTableSynchronizer<S, ID> tableSynchronizer) {
        this.tableSynchronizer = tableSynchronizer;
    }

    @Required
    public void setDynamoDBOperations(DynamoDBOperations dynamoDBOperations) {
        this.dynamoDBOperations = dynamoDBOperations;
    }

    @Required
    public void setDynamoDBMappingContext(DynamoDBMappingContext dynamoDBMappingContext) {
        this.setMappingContext((MappingContext)dynamoDBMappingContext);
    }
}

