/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.domain;

import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class UnpagedPageImpl<T>
implements Page<T> {
    private final List<T> content;
    private final Pageable pageable;
    private final long total;

    public UnpagedPageImpl(@NonNull List<T> content, long total) {
        Assert.notNull(content, (String)"content must not be null!");
        this.pageable = Pageable.unpaged();
        this.content = content;
        this.total = total;
    }

    public int getNumber() {
        return 0;
    }

    public int getSize() {
        return this.getNumberOfElements();
    }

    public int getNumberOfElements() {
        if (this.total > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)this.total;
    }

    public Sort getSort() {
        return this.pageable.getSort();
    }

    public boolean isFirst() {
        return true;
    }

    public boolean isLast() {
        return true;
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasPrevious() {
        return false;
    }

    @Nullable
    public Pageable nextPageable() {
        return null;
    }

    @Nullable
    public Pageable previousPageable() {
        return null;
    }

    public Iterator<T> iterator() {
        return this.content.iterator();
    }

    public int getTotalPages() {
        return 1;
    }

    public long getTotalElements() {
        return this.total;
    }

    public <U> UnpagedPageImpl<U> map(Function<? super T, ? extends U> converter) {
        List convertedContent = this.content.stream().map(converter).collect(Collectors.toList());
        return new UnpagedPageImpl(convertedContent, this.total);
    }

    public List<T> getContent() {
        return this.content;
    }

    public boolean hasContent() {
        return this.total > 0L;
    }

    public String toString() {
        String contentType = "UNKNOWN";
        if (this.total > 0L) {
            contentType = this.iterator().getClass().getName();
        }
        return String.format("Page %s of %d containing %s instances", this.getNumber() + 1, this.getTotalPages(), contentType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UnpagedPageImpl)) {
            return false;
        }
        UnpagedPageImpl that = (UnpagedPageImpl)obj;
        return this.total == that.total && this.pageable.equals(that.pageable) && this.content.equals(that.content);
    }

    public int hashCode() {
        int result = 17;
        result += 31 * (int)(this.total ^ this.total >>> 32);
        result += 31 * this.pageable.hashCode();
        return result += 31 * this.content.hashCode();
    }
}

