/*
 * Decompiled with CFR 0.152.
 */
package kr.co.bootpay.pg;

import java.util.HashMap;
import kr.co.bootpay.pg.BootpayObject;
import kr.co.bootpay.pg.model.request.Authentication;
import kr.co.bootpay.pg.model.request.Cancel;
import kr.co.bootpay.pg.model.request.CashReceipt;
import kr.co.bootpay.pg.model.request.Payload;
import kr.co.bootpay.pg.model.request.Shipping;
import kr.co.bootpay.pg.model.request.Subscribe;
import kr.co.bootpay.pg.model.request.SubscribePayload;
import kr.co.bootpay.pg.model.request.UserToken;
import kr.co.bootpay.pg.model.response.ResDefault;
import kr.co.bootpay.pg.service.AuthService;
import kr.co.bootpay.pg.service.BillingService;
import kr.co.bootpay.pg.service.CancelService;
import kr.co.bootpay.pg.service.CashService;
import kr.co.bootpay.pg.service.ConfirmService;
import kr.co.bootpay.pg.service.EasyService;
import kr.co.bootpay.pg.service.EscrowService;
import kr.co.bootpay.pg.service.LinkService;
import kr.co.bootpay.pg.service.PaymentService;
import kr.co.bootpay.pg.service.SellerService;
import kr.co.bootpay.pg.service.TokenService;
import kr.co.bootpay.pg.service.VerificationService;

public class Bootpay
extends BootpayObject {
    public Bootpay() {
    }

    public Bootpay(String restApplicationId, String privateKey) {
        super(restApplicationId, privateKey);
    }

    public Bootpay(String restApplicationId, String privateKey, String devMode) {
        super(restApplicationId, privateKey, devMode);
    }

    public HashMap<String, Object> getAccessToken() throws Exception {
        return TokenService.getAccessToken(this);
    }

    public HashMap<String, Object> lookupBillingKey(String receiptId) throws Exception {
        return BillingService.lookupBillingKey(this, receiptId);
    }

    public HashMap<String, Object> lookupBillingKeyByKey(String billingKey) throws Exception {
        return BillingService.lookupBillingKeyByKey(this, billingKey);
    }

    public HashMap<String, Object> lookupPaymentMethods() throws Exception {
        return SellerService.lookupPaymentMethods(this);
    }

    public HashMap<String, Object> lookupOrderId(String orderId) throws Exception {
        return PaymentService.lookupOrderId(this, orderId);
    }

    public HashMap<String, Object> getBillingKey(Subscribe subscribeBilling) throws Exception {
        return BillingService.getBillingKey(this, subscribeBilling);
    }

    public HashMap<String, Object> requestSubscribe(SubscribePayload payload) throws Exception {
        return BillingService.requestSubscribe(this, payload);
    }

    public HashMap<String, Object> reserveSubscribe(SubscribePayload payload) throws Exception {
        return BillingService.reserveSubscribe(this, payload);
    }

    public HashMap<String, Object> reserveSubscribeLookup(String reserveId) throws Exception {
        return BillingService.reserveSubscribeLookup(this, reserveId);
    }

    public HashMap<String, Object> reserveCancelSubscribe(String reserveId) throws Exception {
        return BillingService.reserveCancelSubscribe(this, reserveId);
    }

    public HashMap<String, Object> destroyBillingKey(String billingKey) throws Exception {
        return BillingService.destroyBillingKey(this, billingKey);
    }

    public HashMap<String, Object> receiptCancel(Cancel cancel) throws Exception {
        return CancelService.receiptCancel(this, cancel);
    }

    public HashMap<String, Object> getUserToken(UserToken userToken) throws Exception {
        return EasyService.getUserToken(this, userToken);
    }

    public ResDefault<String> requestLink(Payload payload) throws Exception {
        return LinkService.requestLink(this, payload);
    }

    public HashMap<String, Object> confirm(String receiptId) throws Exception {
        return ConfirmService.confirm(this, receiptId);
    }

    public HashMap<String, Object> getReceipt(String receiptId) throws Exception {
        return VerificationService.receipt(this, receiptId);
    }

    public HashMap<String, Object> certificate(String receiptId) throws Exception {
        return VerificationService.certificate(this, receiptId);
    }

    public HashMap<String, Object> shippingStart(Shipping shipping) throws Exception {
        return EscrowService.shippingStart(this, shipping);
    }

    public HashMap<String, Object> requestCashReceipt(CashReceipt cashReceipt) throws Exception {
        return CashService.requestCashReceipt(this, cashReceipt);
    }

    public HashMap<String, Object> requestCashReceiptCancel(Cancel cancel) throws Exception {
        return CashService.requestCashReceiptCancel(this, cancel);
    }

    public HashMap<String, Object> requestCashReceiptByBootpay(CashReceipt cashReceipt) throws Exception {
        return CashService.requestCashReceiptByBootpay(this, cashReceipt);
    }

    public HashMap<String, Object> requestCashReceiptCancelByBootpay(Cancel cancel) throws Exception {
        return CashService.requestCashReceiptCancelByBootpay(this, cancel);
    }

    public HashMap<String, Object> requestAuthentication(Authentication authentication) throws Exception {
        return AuthService.requestAuthentication(this, authentication);
    }

    public HashMap<String, Object> confirmAuthentication(String receiptId, String otp) throws Exception {
        return AuthService.confirmAuthentication(this, receiptId, otp);
    }

    public HashMap<String, Object> realarmAuthentication(String receiptId) throws Exception {
        return AuthService.realarmAuthentication(this, receiptId);
    }

    public HashMap<String, Object> getBillingKeyTransfer(Subscribe subscribe) throws Exception {
        return BillingService.getBillingKeyTransfer(this, subscribe);
    }

    public HashMap<String, Object> publishBillingKeyTransfer(String receiptId) throws Exception {
        return BillingService.publishBillingKeyTransfer(this, receiptId);
    }
}

