/*
 * Decompiled with CFR 0.152.
 */
package kr.co.bootpay.pg;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kr.co.bootpay.http.HttpDeleteWithBody;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class BootpayObject {
    public String token;
    public String application_id;
    public String private_key;
    public String baseUrl;
    public final String DEVELOPMENT = "https://dev-api.bootpay.co.kr/v2/";
    public final String TEST = "https://test-api.bootpay.co.kr/v2/";
    public final String STAGE = "https://stage-api.bootpay.co.kr/v2/";
    public final String PRODUCTION = "https://api.bootpay.co.kr/v2/";
    public static final Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();

    public BootpayObject() {
    }

    public BootpayObject(String rest_application_id, String private_key) {
        this.application_id = rest_application_id;
        this.private_key = private_key;
        this.baseUrl = "https://api.bootpay.co.kr/v2/";
    }

    public BootpayObject(String rest_application_id, String private_key, String devMode) {
        this.application_id = rest_application_id;
        this.private_key = private_key;
        if ("DEVELOPMENT".equals(devMode)) {
            this.baseUrl = "https://dev-api.bootpay.co.kr/v2/";
        } else if ("TEST".equalsIgnoreCase(devMode)) {
            this.baseUrl = "https://test-api.bootpay.co.kr/v2/";
        } else if ("STAGE".equalsIgnoreCase(devMode)) {
            this.baseUrl = "https://stage-api.bootpay.co.kr/v2/";
        } else if ("PRODUCTION".equalsIgnoreCase(devMode)) {
            this.baseUrl = "https://api.bootpay.co.kr/v2/";
        }
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getTokenValue() {
        return "Bearer " + this.token;
    }

    protected void setCommonHeaders(HttpRequestBase request) {
        request.setHeader("Accept", "application/json");
        request.setHeader("Content-Type", "application/json");
        request.setHeader("Accept-Charset", "utf-8");
        request.setHeader("BOOTPAY-API-VERSION", "5.1.0");
        request.setHeader("BOOTPAY-SDK-VERSION", "3.0.0");
        request.setHeader("BOOTPAY-SDK-TYPE", "304");
    }

    protected void setAuthHeader(HttpRequestBase request) {
        if (this.token != null && !this.token.isEmpty()) {
            request.setHeader("Authorization", this.getTokenValue());
        }
    }

    public HashMap<String, Object> doGet(String url) throws Exception {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = this.httpGet(url);
        this.setCommonHeaders((HttpRequestBase)get);
        this.setAuthHeader((HttpRequestBase)get);
        HttpResponse response = client.execute((HttpUriRequest)get);
        return this.responseToJson(response);
    }

    public HashMap<String, Object> doGet(String url, List<NameValuePair> params) throws Exception {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = this.httpGet(url, params);
        this.setAuthHeader((HttpRequestBase)get);
        HttpResponse response = client.execute((HttpUriRequest)get);
        return this.responseToJson(response);
    }

    public HashMap<String, Object> doPost(String url, Object payload) throws Exception {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        StringEntity entity = new StringEntity(gson.toJson(payload), "UTF-8");
        HttpPost post = this.httpPost(url, entity);
        this.setAuthHeader((HttpRequestBase)post);
        HttpResponse response = client.execute((HttpUriRequest)post);
        return this.responseToJson(response);
    }

    public HashMap<String, Object> doPostWithoutAuth(String url, Object payload) throws Exception {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        StringEntity entity = new StringEntity(gson.toJson(payload), "UTF-8");
        HttpPost post = this.httpPost(url, entity);
        HttpResponse response = client.execute((HttpUriRequest)post);
        return this.responseToJson(response);
    }

    public HashMap<String, Object> doPut(String url, Object payload) throws Exception {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        StringEntity entity = new StringEntity(gson.toJson(payload), "UTF-8");
        HttpPut put = this.httpPut(url, entity);
        this.setCommonHeaders((HttpRequestBase)put);
        this.setAuthHeader((HttpRequestBase)put);
        HttpResponse response = client.execute((HttpUriRequest)put);
        return this.responseToJson(response);
    }

    public HashMap<String, Object> doDelete(String url) throws Exception {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpDelete delete = this.httpDelete(url);
        this.setAuthHeader((HttpRequestBase)delete);
        HttpResponse response = client.execute((HttpUriRequest)delete);
        return this.responseToJson(response);
    }

    public HashMap<String, Object> doDeleteWithBody(String url, Object payload) throws Exception {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        StringEntity entity = new StringEntity(gson.toJson(payload), "UTF-8");
        HttpDeleteWithBody delete = this.httpDeleteWithBody(url, entity);
        this.setAuthHeader((HttpRequestBase)delete);
        HttpResponse response = client.execute((HttpUriRequest)delete);
        return this.responseToJson(response);
    }

    public HashMap<String, Object> doGetArray(String url) throws Exception {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = this.httpGet(url);
        this.setCommonHeaders((HttpRequestBase)get);
        this.setAuthHeader((HttpRequestBase)get);
        HttpResponse response = client.execute((HttpUriRequest)get);
        return this.responseToJsonArray(response);
    }

    public HttpGet httpGet(String url) throws Exception {
        HttpGet get = new HttpGet(this.baseUrl + url);
        URI uri = new URIBuilder(get.getURI()).build();
        get.setURI(uri);
        return get;
    }

    public HttpGet httpGet(String url, List<NameValuePair> nameValuePairList) throws Exception {
        HttpGet get = new HttpGet(this.baseUrl + url);
        this.setCommonHeaders((HttpRequestBase)get);
        URI uri = new URIBuilder(get.getURI()).addParameters(nameValuePairList).build();
        get.setURI(uri);
        return get;
    }

    public HttpPost httpPost(String url, StringEntity entity) {
        HttpPost post = new HttpPost(this.baseUrl + url);
        this.setCommonHeaders((HttpRequestBase)post);
        post.setEntity((HttpEntity)entity);
        return post;
    }

    public HttpDelete httpDelete(String url) {
        HttpDelete delete = new HttpDelete(this.baseUrl + url);
        this.setCommonHeaders((HttpRequestBase)delete);
        return delete;
    }

    public HttpDeleteWithBody httpDeleteWithBody(String url, StringEntity entity) {
        HttpDeleteWithBody delete = new HttpDeleteWithBody(this.baseUrl + url);
        this.setCommonHeaders((HttpRequestBase)delete);
        delete.setEntity((HttpEntity)entity);
        return delete;
    }

    public HttpPut httpPut(String url, StringEntity entity) {
        HttpPut put = new HttpPut(this.baseUrl + url);
        put.setHeader("Accept", "application/json");
        put.setHeader("Content-Type", "application/json");
        put.setHeader("Accept-Charset", "utf-8");
        put.setEntity((HttpEntity)entity);
        return put;
    }

    public HashMap<String, Object> responseToJsonArray(HttpResponse response) throws Exception {
        String str = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8");
        HashMap<String, Object> result = new HashMap<String, Object>();
        ObjectMapper mapper = new ObjectMapper();
        TypeReference<List<HashMap<String, Object>>> typeRef = new TypeReference<List<HashMap<String, Object>>>(){};
        ArrayList data = (ArrayList)mapper.readValue(str, (TypeReference)typeRef);
        if (data == null) {
            data = new ArrayList();
        }
        result.put("http_status", response.getStatusLine().getStatusCode());
        result.put("data", data);
        return result;
    }

    public HashMap<String, Object> responseToJson(HttpResponse response) throws Exception {
        TypeReference<HashMap<String, Object>> typeRef;
        ObjectMapper mapper = new ObjectMapper();
        String str = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8");
        HashMap<String, Object> result = (HashMap<String, Object>)mapper.readValue(str, (TypeReference)(typeRef = new TypeReference<HashMap<String, Object>>(){}));
        if (result == null) {
            result = new HashMap<String, Object>();
        }
        result.put("http_status", response.getStatusLine().getStatusCode());
        return result;
    }
}

