/*
 * Decompiled with CFR 0.152.
 */
package kr.co.bootpay.pg.service;

import java.util.HashMap;
import kr.co.bootpay.pg.BootpayObject;
import kr.co.bootpay.pg.model.request.Subscribe;
import kr.co.bootpay.pg.model.request.SubscribePayload;

public class BillingService {
    private static void validateToken(BootpayObject bootpay) throws Exception {
        if (bootpay.token == null || bootpay.token.isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
    }

    public static HashMap<String, Object> getBillingKey(BootpayObject bootpay, Subscribe subscribe) throws Exception {
        BillingService.validateToken(bootpay);
        if (subscribe.orderName == null || subscribe.orderName.isEmpty()) {
            throw new Exception("order_name \uac12\uc744 \uc785\ub825\ud574\uc8fc\uc138\uc694.");
        }
        if (subscribe.subscriptionId == null || subscribe.subscriptionId.isEmpty()) {
            throw new Exception("order_id \uc8fc\ubb38\ubc88\ud638\ub97c \uc124\uc815\ud574\uc8fc\uc138\uc694.");
        }
        if (subscribe.pg == null || subscribe.pg.isEmpty()) {
            throw new Exception("\uacb0\uc81c\ud558\uace0\uc790 \ud558\ub294 pg alias\ub97c \uc785\ub825\ud574\uc8fc\uc138\uc694.");
        }
        return bootpay.doPost("request/subscribe", subscribe);
    }

    public static HashMap<String, Object> lookupBillingKey(BootpayObject bootpay, String receiptId) throws Exception {
        BillingService.validateToken(bootpay);
        if (receiptId == null || receiptId.isEmpty()) {
            throw new Exception("receiptId \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        return bootpay.doGet("subscribe/billing_key/" + receiptId);
    }

    public static HashMap<String, Object> lookupBillingKeyByKey(BootpayObject bootpay, String billingKey) throws Exception {
        BillingService.validateToken(bootpay);
        if (billingKey == null || billingKey.isEmpty()) {
            throw new Exception("billingKey \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        return bootpay.doGet("billing_key/" + billingKey);
    }

    public static HashMap<String, Object> destroyBillingKey(BootpayObject bootpay, String billingKey) throws Exception {
        BillingService.validateToken(bootpay);
        if (billingKey == null || billingKey.isEmpty()) {
            throw new Exception("billingKey \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        return bootpay.doDelete("subscribe/billing_key/" + billingKey);
    }

    public static HashMap<String, Object> requestSubscribe(BootpayObject bootpay, SubscribePayload payload) throws Exception {
        BillingService.validateToken(bootpay);
        if (payload.billingKey == null || payload.billingKey.isEmpty()) {
            throw new Exception("billing_key \uac12\uc744 \uc785\ub825\ud574\uc8fc\uc138\uc694.");
        }
        if (payload.orderName == null || payload.orderName.isEmpty()) {
            throw new Exception("order_name \uac12\uc744 \uc785\ub825\ud574\uc8fc\uc138\uc694.");
        }
        if (payload.price <= 0.0) {
            throw new Exception("price \uae08\uc561\uc744 \uc124\uc815\uc744 \ud574\uc8fc\uc138\uc694.");
        }
        if (payload.orderId == null || payload.orderId.isEmpty()) {
            throw new Exception("order_id \uc8fc\ubb38\ubc88\ud638\ub97c \uc124\uc815\ud574\uc8fc\uc138\uc694.");
        }
        return bootpay.doPost("subscribe/payment", payload);
    }

    public static HashMap<String, Object> reserveSubscribe(BootpayObject bootpay, SubscribePayload reserve) throws Exception {
        BillingService.validateToken(bootpay);
        if (reserve.billingKey == null || reserve.billingKey.isEmpty()) {
            throw new Exception("billing_key \uac12\uc744 \uc785\ub825\ud574\uc8fc\uc138\uc694.");
        }
        if (reserve.orderName == null || reserve.orderName.isEmpty()) {
            throw new Exception("order_name \uac12\uc744 \uc785\ub825\ud574\uc8fc\uc138\uc694.");
        }
        if (reserve.price <= 0.0) {
            throw new Exception("price \uae08\uc561\uc744 \uc124\uc815\uc744 \ud574\uc8fc\uc138\uc694.");
        }
        if (reserve.orderId == null || reserve.orderId.isEmpty()) {
            throw new Exception("order_id \uc8fc\ubb38\ubc88\ud638\ub97c \uc124\uc815\ud574\uc8fc\uc138\uc694.");
        }
        if (reserve.reserveExecuteAt == null || reserve.reserveExecuteAt.isEmpty()) {
            throw new Exception("execute_at \uc2e4\ud589 \uc2dc\uac04\uc744 \uc124\uc815\ud574\uc8fc\uc138\uc694.");
        }
        return bootpay.doPost("subscribe/payment/reserve", reserve);
    }

    public static HashMap<String, Object> reserveSubscribeLookup(BootpayObject bootpay, String reserveId) throws Exception {
        BillingService.validateToken(bootpay);
        if (reserveId == null || reserveId.isEmpty()) {
            throw new Exception("reserveId \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        return bootpay.doGet("subscribe/payment/reserve/" + reserveId);
    }

    public static HashMap<String, Object> reserveCancelSubscribe(BootpayObject bootpay, String reserve_id) throws Exception {
        BillingService.validateToken(bootpay);
        if (reserve_id == null || reserve_id.isEmpty()) {
            throw new Exception("reserve_id \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        return bootpay.doDelete("subscribe/payment/reserve/" + reserve_id);
    }

    public static HashMap<String, Object> getBillingKeyTransfer(BootpayObject bootpay, Subscribe subscribe) throws Exception {
        BillingService.validateToken(bootpay);
        if (subscribe.orderName == null || subscribe.orderName.isEmpty()) {
            throw new Exception("order_name \uac12\uc744 \uc785\ub825\ud574\uc8fc\uc138\uc694.");
        }
        if (subscribe.subscriptionId == null || subscribe.subscriptionId.isEmpty()) {
            throw new Exception("order_id \uc8fc\ubb38\ubc88\ud638\ub97c \uc124\uc815\ud574\uc8fc\uc138\uc694.");
        }
        if (subscribe.pg == null || subscribe.pg.isEmpty()) {
            throw new Exception("\uacb0\uc81c\ud558\uace0\uc790 \ud558\ub294 pg alias\ub97c \uc785\ub825\ud574\uc8fc\uc138\uc694.");
        }
        if (subscribe.bankName == null || subscribe.bankName.isEmpty()) {
            throw new Exception("\uacc4\uc88c \uc740\ud589\uba85\uc744 \uc785\ub825\ud574\uc8fc\uc138\uc694.");
        }
        if (subscribe.bankAccount == null || subscribe.bankAccount.isEmpty()) {
            throw new Exception("\uacc4\uc88c \ubc88\ud638\ub97c \uc785\ub825\ud574\uc8fc\uc138\uc694.");
        }
        if (subscribe.username == null || subscribe.username.isEmpty()) {
            throw new Exception("\uacc4\uc88c\uc8fc \uc774\ub984\uc744 \uc785\ub825\ud574\uc8fc\uc138\uc694.");
        }
        if (subscribe.identityNo == null || subscribe.identityNo.isEmpty()) {
            throw new Exception("\uacc4\uc88c\uc8fc\uc758 \uc0dd\ub144\uc6d4\uc77c 6\uc790\ub9ac \ub610\ub294 \uc0ac\uc5c5\uc790\ubc88\ud638 10\uc790\ub9ac\ub97c \uc785\ub825\ud574\uc8fc\uc138\uc694.");
        }
        return bootpay.doPost("request/subscribe/automatic-transfer", subscribe);
    }

    public static HashMap<String, Object> publishBillingKeyTransfer(BootpayObject bootpay, String receiptId) throws Exception {
        BillingService.validateToken(bootpay);
        if (receiptId == null || receiptId.isEmpty()) {
            throw new Exception("receiptId \uac12\uc744 \uc785\ub825\ud574\uc8fc\uc138\uc694.");
        }
        SubscribePayload payload = new SubscribePayload();
        payload.receiptId = receiptId;
        return bootpay.doPost("request/subscribe/automatic-transfer/publish", payload);
    }
}

