/*
 * Decompiled with CFR 0.152.
 */
package kr.co.bootpay.pg.service;

import java.util.HashMap;
import kr.co.bootpay.pg.BootpayObject;
import kr.co.bootpay.pg.model.request.Cancel;
import kr.co.bootpay.pg.model.request.CashReceipt;

public class CashService {
    private static void validateToken(BootpayObject bootpay) throws Exception {
        if (bootpay.token == null || bootpay.token.isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
    }

    public static HashMap<String, Object> requestCashReceiptByBootpay(BootpayObject bootpay, CashReceipt cashReceipt) throws Exception {
        CashService.validateToken(bootpay);
        if (cashReceipt.receiptId == null || cashReceipt.receiptId.isEmpty()) {
            throw new Exception("receiptId \uac12\uc744 \uc785\ub825\ud574\uc8fc\uc138\uc694.");
        }
        if (cashReceipt.username == null || cashReceipt.username.isEmpty()) {
            throw new Exception("username \uac12\uc744 \uc785\ub825\ud574\uc8fc\uc138\uc694.");
        }
        if (cashReceipt.phone == null || cashReceipt.phone.isEmpty()) {
            throw new Exception("phone \uac12\uc744 \uc785\ub825\ud574\uc8fc\uc138\uc694.");
        }
        if (cashReceipt.identityNo == null || cashReceipt.identityNo.isEmpty()) {
            throw new Exception("identityNo \uac12\uc744 \uc785\ub825\ud574\uc8fc\uc138\uc694.");
        }
        if (cashReceipt.cashReceiptType == null || cashReceipt.cashReceiptType.isEmpty()) {
            throw new Exception("cashReceiptType \uac12\uc744 \uc785\ub825\ud574\uc8fc\uc138\uc694.");
        }
        return bootpay.doPost("request/receipt/cash/publish", cashReceipt);
    }

    public static HashMap<String, Object> requestCashReceiptCancelByBootpay(BootpayObject bootpay, Cancel cancel) throws Exception {
        CashService.validateToken(bootpay);
        if (cancel == null || cancel.receiptId == null || cancel.receiptId.isEmpty()) {
            throw new Exception("receiptId \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        if (cancel.cancelUsername == null || cancel.cancelUsername.isEmpty()) {
            throw new Exception("cancelUsername \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        if (cancel.cancelMessage == null || cancel.cancelMessage.isEmpty()) {
            throw new Exception("cancelMessage \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        return bootpay.doDeleteWithBody("request/receipt/cash/cancel/" + cancel.receiptId, cancel);
    }

    public static HashMap<String, Object> requestCashReceipt(BootpayObject bootpay, CashReceipt cashReceipt) throws Exception {
        CashService.validateToken(bootpay);
        if (cashReceipt == null) {
            throw new Exception("cashReceipt \ubaa8\ub378\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4. \ub370\uc774\ud130\ub97c \ucc44\uc6cc\uc8fc\uc138\uc694");
        }
        if (cashReceipt.pg == null || cashReceipt.pg.isEmpty()) {
            throw new Exception("pg \uac12\uc744 \uc785\ub825\ud574\uc8fc\uc138\uc694.");
        }
        if (cashReceipt.orderName == null || cashReceipt.orderName.isEmpty()) {
            throw new Exception("orderName \uac12\uc744 \uc785\ub825\ud574\uc8fc\uc138\uc694.");
        }
        if (cashReceipt.orderId == null || cashReceipt.orderId.isEmpty()) {
            throw new Exception("orderId \uac12\uc744 \uc785\ub825\ud574\uc8fc\uc138\uc694.");
        }
        if (cashReceipt.identityNo == null || cashReceipt.identityNo.isEmpty()) {
            throw new Exception("identityNo \uac12\uc744 \uc785\ub825\ud574\uc8fc\uc138\uc694.");
        }
        if (cashReceipt.cashReceiptType == null || cashReceipt.cashReceiptType.isEmpty()) {
            throw new Exception("cashReceiptType \uac12\uc744 \uc785\ub825\ud574\uc8fc\uc138\uc694.");
        }
        return bootpay.doPost("request/cash/receipt", cashReceipt);
    }

    public static HashMap<String, Object> requestCashReceiptCancel(BootpayObject bootpay, Cancel cancel) throws Exception {
        CashService.validateToken(bootpay);
        if (cancel == null || cancel.receiptId == null || cancel.receiptId.isEmpty()) {
            throw new Exception("receiptId \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        if (cancel.cancelUsername == null || cancel.cancelUsername.isEmpty()) {
            throw new Exception("cancelUsername \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        if (cancel.cancelMessage == null || cancel.cancelMessage.isEmpty()) {
            throw new Exception("cancelMessage \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        return bootpay.doDeleteWithBody("request/cash/receipt/" + cancel.receiptId, cancel);
    }
}

