/*
 * Decompiled with CFR 0.152.
 */
package kr.co.bootpay.store;

import java.util.HashMap;
import kr.co.bootpay.store.BootpayStoreObject;
import kr.co.bootpay.store.layer.Invoice;
import kr.co.bootpay.store.layer.Order;
import kr.co.bootpay.store.layer.OrderCancel;
import kr.co.bootpay.store.layer.OrderSubscription;
import kr.co.bootpay.store.layer.OrderSubscriptionAdjustment;
import kr.co.bootpay.store.layer.OrderSubscriptionBill;
import kr.co.bootpay.store.layer.Product;
import kr.co.bootpay.store.layer.User;
import kr.co.bootpay.store.layer.UserGroup;
import kr.co.bootpay.store.model.request.TokenPayload;
import kr.co.bootpay.store.model.response.BootpayStoreResponse;
import kr.co.bootpay.store.service.STokenService;

public class BootpayStore
extends BootpayStoreObject {
    public User user;
    public UserGroup userGroup;
    public Product product;
    public Invoice invoice;
    public Order order;
    public OrderCancel orderCancel;
    public OrderSubscription orderSubscription;
    public OrderSubscriptionBill orderSubscriptionBill;
    public OrderSubscriptionAdjustment orderSubscriptionAdjustment;

    public BootpayStore() {
        this.initModules();
    }

    public BootpayStore(TokenPayload tokenPayload) {
        super(tokenPayload);
        this.initModules();
    }

    public BootpayStore(TokenPayload tokenPayload, String devMode) {
        super(tokenPayload, devMode);
        this.initModules();
    }

    private void initModules() {
        this.user = new User(this);
        this.userGroup = new UserGroup(this);
        this.product = new Product(this);
        this.invoice = new Invoice(this);
        this.order = new Order(this);
        this.orderCancel = new OrderCancel(this);
        this.orderSubscription = new OrderSubscription(this);
        this.orderSubscriptionBill = new OrderSubscriptionBill(this);
        this.orderSubscriptionAdjustment = new OrderSubscriptionAdjustment(this);
    }

    public BootpayStoreResponse getAccessToken() throws Exception {
        return STokenService.getAccessToken(this);
    }

    public BootpayStore withToken() throws Exception {
        HashMap<String, Object> data;
        BootpayStoreResponse response = this.getAccessToken();
        if (response.isSuccess() && (data = response.getData()) != null && data.containsKey("access_token")) {
            this.setTokenFromAPI((String)data.get("access_token"));
        }
        return this;
    }

    public String getCurrentToken() {
        return this.getToken();
    }

    public boolean hasToken() {
        return this.getToken() != null && !this.getToken().isEmpty();
    }

    public BootpayStore withRole(String role) {
        this.setRole(role);
        return this;
    }

    public BootpayStore asUser() {
        return this.withRole("user");
    }

    public BootpayStore asManager() {
        return this.withRole("manager");
    }

    public BootpayStore asPartner() {
        return this.withRole("partner");
    }

    public BootpayStore asVendor() {
        return this.withRole("vendor");
    }

    public BootpayStore asSupervisor() {
        return this.withRole("supervisor");
    }

    public String getCurrentRole() {
        return this.getRole();
    }

    public BootpayStore clearRole() {
        this.setRole("user");
        return this;
    }
}

