/*
 * Decompiled with CFR 0.152.
 */
package kr.co.bootpay.store;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kr.co.bootpay.http.HttpDeleteWithBody;
import kr.co.bootpay.store.context.RequestContext;
import kr.co.bootpay.store.model.request.TokenPayload;
import kr.co.bootpay.store.model.response.BootpayStoreResponse;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;

public class BootpayStoreObject {
    private String token;
    private String role = "user";
    public TokenPayload tokenPayload = new TokenPayload();
    public String baseUrl;
    public final String DEVELOPMENT = "https://dev-api.bootapi.com/v1/";
    public final String TEST = "https://test-api.bootapi.com/v1/";
    public final String STAGE = "https://stage-api.bootapi.com/v1/";
    public final String PRODUCTION = "https://api.bootapi.com/v1/";

    public BootpayStoreObject() {
    }

    public BootpayStoreObject(TokenPayload tokenPayload) {
        this.tokenPayload = tokenPayload;
        this.baseUrl = "https://api.bootapi.com/v1/";
    }

    public BootpayStoreObject(TokenPayload tokenPayload, String devMode) {
        this.tokenPayload = tokenPayload;
        if ("DEVELOPMENT".equalsIgnoreCase(devMode)) {
            this.baseUrl = "https://dev-api.bootapi.com/v1/";
        } else if ("TEST".equalsIgnoreCase(devMode)) {
            this.baseUrl = "https://test-api.bootapi.com/v1/";
        } else if ("STAGE".equalsIgnoreCase(devMode)) {
            this.baseUrl = "https://stage-api.bootapi.com/v1/";
        } else if ("PRODUCTION".equalsIgnoreCase(devMode)) {
            this.baseUrl = "https://api.bootapi.com/v1/";
        }
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getTokenValue() {
        return "Bearer " + this.token;
    }

    public String getToken() {
        return this.token;
    }

    public void setTokenFromAPI(String token) {
        this.token = token;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String requestAccessToken() {
        if ((this.tokenPayload.clientKey == null || this.tokenPayload.clientKey.isEmpty()) && (this.tokenPayload.secretKey == null || this.tokenPayload.secretKey.isEmpty())) {
            return "";
        }
        String credentials = this.tokenPayload.clientKey + ":" + this.tokenPayload.secretKey;
        String encoded = Base64.getEncoder().encodeToString(credentials.getBytes());
        return "Basic " + encoded;
    }

    public HttpGet httpGet(String url) throws Exception {
        return this.httpGet(url, (RequestContext)null);
    }

    public HttpGet httpGet(String url, RequestContext context) throws Exception {
        String tokenToUse;
        String roleToUse;
        HttpGet get = new HttpGet(this.baseUrl + url);
        URI uri = new URIBuilder(get.getURI()).build();
        get.setHeader("Accept", "application/json");
        get.setHeader("Content-Type", "application/json");
        get.setHeader("Accept-Charset", "utf-8");
        get.setHeader("BOOTPAY-API-VERSION", "5.1.0");
        get.setHeader("BOOTPAY-SDK-VERSION", "3.0.0");
        get.setHeader("BOOTPAY-SDK-TYPE", "304");
        String string = roleToUse = context != null && context.getRole() != null ? context.getRole() : this.getRole();
        if (roleToUse == null || roleToUse.isEmpty()) {
            roleToUse = "user";
        }
        get.setHeader("BOOTPAY-ROLE", roleToUse);
        String string2 = tokenToUse = context != null && context.getToken() != null ? context.getToken() : this.getToken();
        if (tokenToUse != null) {
            get.setHeader("Authorization", "Bearer " + tokenToUse);
        }
        get.setURI(uri);
        return get;
    }

    public HttpGet httpGet(String url, List<NameValuePair> nameValuePairList) throws Exception {
        return this.httpGet(url, nameValuePairList, null);
    }

    public HttpGet httpGet(String url, List<NameValuePair> nameValuePairList, RequestContext context) throws Exception {
        String tokenToUse;
        String roleToUse;
        HttpGet get = new HttpGet(this.baseUrl + url);
        get.setHeader("Accept", "application/json");
        get.setHeader("Content-Type", "application/json");
        get.setHeader("Accept-Charset", "utf-8");
        get.setHeader("BOOTPAY-API-VERSION", "5.1.0");
        get.setHeader("BOOTPAY-SDK-VERSION", "3.0.0");
        get.setHeader("BOOTPAY-SDK-TYPE", "304");
        String string = roleToUse = context != null && context.getRole() != null ? context.getRole() : this.getRole();
        if (roleToUse == null || roleToUse.isEmpty()) {
            roleToUse = "user";
        }
        get.setHeader("BOOTPAY-ROLE", roleToUse);
        String string2 = tokenToUse = context != null && context.getToken() != null ? context.getToken() : this.getToken();
        if (tokenToUse != null) {
            get.setHeader("Authorization", "Bearer " + tokenToUse);
        }
        URI uri = new URIBuilder(get.getURI()).addParameters(nameValuePairList).build();
        get.setURI(uri);
        return get;
    }

    public HttpPost httpPost(String url, StringEntity entity) {
        return this.httpPost(url, entity, (RequestContext)null);
    }

    public HttpPost httpPost(String url, StringEntity entity, RequestContext context) {
        String tokenToUse;
        String roleToUse;
        HttpPost post = new HttpPost(this.baseUrl + url);
        post.setHeader("Accept", "application/json");
        post.setHeader("Content-Type", "application/json");
        post.setHeader("Accept-Charset", "utf-8");
        post.setHeader("BOOTPAY-API-VERSION", "5.1.0");
        post.setHeader("BOOTPAY-SDK-VERSION", "3.0.0");
        post.setHeader("BOOTPAY-SDK-TYPE", "304");
        String string = roleToUse = context != null && context.getRole() != null ? context.getRole() : this.getRole();
        if (roleToUse == null || roleToUse.isEmpty()) {
            roleToUse = "user";
        }
        post.setHeader("BOOTPAY-ROLE", roleToUse);
        String string2 = tokenToUse = context != null && context.getToken() != null ? context.getToken() : this.getToken();
        if (tokenToUse != null) {
            post.setHeader("Authorization", "Bearer " + tokenToUse);
        } else {
            post.setHeader("Authorization", this.requestAccessToken());
        }
        post.setEntity((HttpEntity)entity);
        return post;
    }

    public HttpPost httpPost(String url, StringEntity entity, Map<String, String> header) {
        return this.httpPost(url, entity, header, null);
    }

    public HttpPost httpPost(String url, StringEntity entity, Map<String, String> header, RequestContext context) {
        String tokenToUse;
        String roleToUse;
        HttpPost post = new HttpPost(this.baseUrl + url);
        post.setHeader("Accept", "application/json");
        post.setHeader("Content-Type", "application/json");
        post.setHeader("Accept-Charset", "utf-8");
        post.setHeader("BOOTPAY-API-VERSION", "5.1.0");
        post.setHeader("BOOTPAY-SDK-VERSION", "3.0.0");
        post.setHeader("BOOTPAY-SDK-TYPE", "304");
        String string = roleToUse = context != null && context.getRole() != null ? context.getRole() : this.getRole();
        if (roleToUse == null || roleToUse.isEmpty()) {
            roleToUse = "user";
        }
        post.setHeader("BOOTPAY-ROLE", roleToUse);
        String string2 = tokenToUse = context != null && context.getToken() != null ? context.getToken() : this.getToken();
        if (tokenToUse != null) {
            post.setHeader("Authorization", this.getTokenValue());
        } else {
            post.setHeader("Authorization", this.requestAccessToken());
        }
        if (header != null) {
            for (Map.Entry<String, String> entry : header.entrySet()) {
                post.setHeader(entry.getKey(), entry.getValue());
            }
        }
        post.setEntity((HttpEntity)entity);
        return post;
    }

    public HttpPost httpPostMultipart(String url, List<File> files, HashMap<String, String> params) throws Exception {
        return this.httpPostMultipart(url, files, params, null);
    }

    public HttpPost httpPostMultipart(String url, List<File> files, HashMap<String, String> params, RequestContext context) throws Exception {
        String tokenToUse;
        String roleToUse;
        HttpPost post = new HttpPost(this.baseUrl + url);
        post.setHeader("Accept", "application/json");
        post.setHeader("Accept-Charset", "utf-8");
        post.setHeader("BOOTPAY-API-VERSION", "5.1.0");
        post.setHeader("BOOTPAY-SDK-VERSION", "3.0.0");
        post.setHeader("BOOTPAY-SDK-TYPE", "304");
        String string = roleToUse = context != null && context.getRole() != null ? context.getRole() : this.getRole();
        if (roleToUse == null || roleToUse.isEmpty()) {
            roleToUse = "user";
        }
        post.setHeader("BOOTPAY-ROLE", roleToUse);
        String string2 = tokenToUse = context != null && context.getToken() != null ? context.getToken() : this.getToken();
        if (tokenToUse != null) {
            post.setHeader("Authorization", "Bearer " + tokenToUse);
        }
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        if (files != null) {
            for (File file : files) {
                builder.addBinaryBody("images", file, ContentType.APPLICATION_OCTET_STREAM, file.getName());
            }
        }
        if (params != null) {
            for (Map.Entry entry : params.entrySet()) {
                builder.addTextBody((String)entry.getKey(), (String)entry.getValue(), ContentType.TEXT_PLAIN.withCharset("UTF-8"));
            }
        }
        post.setEntity(builder.build());
        return post;
    }

    public HttpDelete httpDelete(String url) {
        return this.httpDelete(url, null);
    }

    public HttpDelete httpDelete(String url, RequestContext context) {
        String tokenToUse;
        String roleToUse;
        HttpDelete delete = new HttpDelete(this.baseUrl + url);
        delete.setHeader("Accept", "application/json");
        delete.setHeader("Content-Type", "application/json");
        delete.setHeader("Accept-Charset", "utf-8");
        delete.setHeader("BOOTPAY-API-VERSION", "5.1.0");
        delete.setHeader("BOOTPAY-SDK-VERSION", "3.0.0");
        delete.setHeader("BOOTPAY-SDK-TYPE", "304");
        String string = roleToUse = context != null && context.getRole() != null ? context.getRole() : this.getRole();
        if (roleToUse == null || roleToUse.isEmpty()) {
            roleToUse = "user";
        }
        delete.setHeader("BOOTPAY-ROLE", roleToUse);
        String string2 = tokenToUse = context != null && context.getToken() != null ? context.getToken() : this.getToken();
        if (tokenToUse != null) {
            delete.setHeader("Authorization", "Bearer " + tokenToUse);
        }
        return delete;
    }

    public HttpDeleteWithBody httpDeleteWithBody(String url, StringEntity entity) {
        return this.httpDeleteWithBody(url, entity, null);
    }

    public HttpDeleteWithBody httpDeleteWithBody(String url, StringEntity entity, RequestContext context) {
        String tokenToUse;
        String roleToUse;
        HttpDeleteWithBody delete = new HttpDeleteWithBody(this.baseUrl + url);
        delete.setHeader("Accept", "application/json");
        delete.setHeader("Content-Type", "application/json");
        delete.setHeader("Accept-Charset", "utf-8");
        delete.setHeader("BOOTPAY-API-VERSION", "5.1.0");
        delete.setHeader("BOOTPAY-SDK-VERSION", "3.0.0");
        delete.setHeader("BOOTPAY-SDK-TYPE", "304");
        String string = roleToUse = context != null && context.getRole() != null ? context.getRole() : this.getRole();
        if (roleToUse == null || roleToUse.isEmpty()) {
            roleToUse = "user";
        }
        delete.setHeader("BOOTPAY-ROLE", roleToUse);
        String string2 = tokenToUse = context != null && context.getToken() != null ? context.getToken() : this.getToken();
        if (tokenToUse != null) {
            delete.setHeader("Authorization", "Bearer " + tokenToUse);
        }
        delete.setEntity((HttpEntity)entity);
        return delete;
    }

    public HttpPut httpPut(String url, StringEntity entity) {
        return this.httpPut(url, entity, null);
    }

    public HttpPut httpPut(String url, StringEntity entity, RequestContext context) {
        String tokenToUse;
        String roleToUse;
        HttpPut put = new HttpPut(this.baseUrl + url);
        put.setHeader("Accept", "application/json");
        put.setHeader("Content-Type", "application/json");
        put.setHeader("Accept-Charset", "utf-8");
        String string = roleToUse = context != null && context.getRole() != null ? context.getRole() : this.getRole();
        if (roleToUse == null || roleToUse.isEmpty()) {
            roleToUse = "user";
        }
        put.setHeader("BOOTPAY-ROLE", roleToUse);
        String string2 = tokenToUse = context != null && context.getToken() != null ? context.getToken() : this.getToken();
        if (tokenToUse != null) {
            put.setHeader("Authorization", "Bearer " + tokenToUse);
        }
        put.setEntity((HttpEntity)entity);
        return put;
    }

    public BootpayStoreResponse responseToJsonObject(HttpResponse response) throws Exception {
        HashMap<String, Object> result = this.responseToJson(response);
        int httpStatus = (Integer)result.get("http_status");
        boolean success = (Boolean)result.get("success");
        Object data = result.get("data");
        String error = (String)result.get("error");
        return new BootpayStoreResponse(httpStatus, success, data, error);
    }

    public HashMap<String, Object> responseToJson(HttpResponse response) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int statusCode = response.getStatusLine().getStatusCode();
        result.put("http_status", statusCode);
        result.put("success", statusCode >= 200 && statusCode < 300);
        try {
            if (response.getEntity() == null) {
                result.put("data", null);
                return result;
            }
            if (response.getEntity().getContent() == null || "null".equals(response.getEntity().getContent())) {
                result.put("data", null);
                return result;
            }
            String str = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8");
            System.out.println(str);
            if (str == null || str.trim().isEmpty() || "null".equalsIgnoreCase(str.trim())) {
                result.put("data", null);
                return result;
            }
            ObjectMapper mapper = new ObjectMapper();
            TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
            HashMap parsedData = (HashMap)mapper.readValue(str, (TypeReference)typeRef);
            result.put("data", parsedData);
        }
        catch (Exception e) {
            result.put("data", null);
            result.put("error", e.getMessage());
        }
        return result;
    }
}

