/*
 * Decompiled with CFR 0.152.
 */
package kr.co.bootpay.store.service;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import kr.co.bootpay.store.BootpayStoreObject;
import kr.co.bootpay.store.model.pojo.SToken;
import kr.co.bootpay.store.model.response.BootpayStoreResponse;
import kr.co.bootpay.store.model.response.STokenResponse;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class STokenService {
    public static BootpayStoreResponse getAccessToken(BootpayStoreObject bootpay) throws Exception {
        if (bootpay.tokenPayload == null) {
            throw new Exception("tokenPayload \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        boolean clientKeyEmpty = bootpay.tokenPayload.clientKey == null || bootpay.tokenPayload.clientKey.isEmpty();
        boolean secretKeyEmpty = bootpay.tokenPayload.secretKey == null || bootpay.tokenPayload.secretKey.isEmpty();
        boolean serverKeyEmpty = bootpay.tokenPayload.serverKey == null || bootpay.tokenPayload.serverKey.isEmpty();
        boolean privateKeyEmpty = bootpay.tokenPayload.privateKey == null || bootpay.tokenPayload.privateKey.isEmpty();
        SToken token = new SToken();
        if (clientKeyEmpty || secretKeyEmpty) {
            if (serverKeyEmpty && privateKeyEmpty) {
                if (clientKeyEmpty) {
                    throw new Exception("clientKey \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
                }
                throw new Exception("secretKey \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
            }
            if (serverKeyEmpty) {
                throw new Exception("serverKey \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
            }
            if (privateKeyEmpty) {
                throw new Exception("privateKey \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
            }
            token.serverKey = bootpay.tokenPayload.serverKey;
            token.privateKey = bootpay.tokenPayload.privateKey;
        }
        bootpay.setTokenFromAPI(null);
        CloseableHttpClient client = HttpClientBuilder.create().build();
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        HttpPost post = bootpay.httpPost("request/token", new StringEntity(gson.toJson((Object)token), "UTF-8"));
        HttpResponse response = client.execute((HttpUriRequest)post);
        String str = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8");
        STokenResponse res = (STokenResponse)new Gson().fromJson(str, STokenResponse.class);
        bootpay.setTokenFromAPI(res.access_token);
        return bootpay.responseToJsonObject(response);
    }
}

