/*
 * Decompiled with CFR 0.152.
 */
package kr.co.bootpay.store.service.order_subscription_bill;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.stream.Collectors;
import kr.co.bootpay.store.BootpayStoreObject;
import kr.co.bootpay.store.model.pojo.SOrderSubscriptionBill;
import kr.co.bootpay.store.model.request.orderSubscriptionBill.OrderSubscriptionBillListParams;
import kr.co.bootpay.store.model.response.BootpayStoreResponse;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;

public class SOrderSubscriptionBillService {
    public static BootpayStoreResponse list(BootpayStoreObject bootpay, OrderSubscriptionBillListParams params) throws Exception {
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        String url = "order_subscription_bills";
        if (params != null) {
            ArrayList<NameValuePair> nameValuePairList = new ArrayList<NameValuePair>();
            if (params.orderSubscriptionId != null) {
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("order_subscription_id", params.orderSubscriptionId));
            }
            if (params.keyword != null) {
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("keyword", params.keyword));
            }
            if (params.page != null) {
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("page", params.page.toString()));
            }
            if (params.limit != null) {
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("limit", params.limit.toString()));
            }
            if (params.status != null && !params.status.isEmpty()) {
                String statusStr = params.status.stream().map(String::valueOf).collect(Collectors.joining(","));
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("status", statusStr));
            }
            HttpGet get = bootpay.httpGet(url, nameValuePairList);
            HttpResponse response = client.execute((HttpUriRequest)get);
            return bootpay.responseToJsonObject(response);
        }
        HttpGet get = bootpay.httpGet(url);
        HttpResponse response = client.execute((HttpUriRequest)get);
        return bootpay.responseToJsonObject(response);
    }

    public static BootpayStoreResponse detail(BootpayStoreObject bootpay, String orderSubscriptionBillId) throws Exception {
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = bootpay.httpGet("order_subscription_bills/" + orderSubscriptionBillId);
        HttpResponse response = client.execute((HttpUriRequest)get);
        return bootpay.responseToJsonObject(response);
    }

    public static BootpayStoreResponse update(BootpayStoreObject bootpay, SOrderSubscriptionBill orderSubscriptionBill) throws Exception {
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        HttpPut put = bootpay.httpPut("order_subscription_bills/" + orderSubscriptionBill.orderSubscriptionBillId, new StringEntity(gson.toJson((Object)orderSubscriptionBill), "UTF-8"));
        HttpResponse response = client.execute((HttpUriRequest)put);
        return bootpay.responseToJsonObject(response);
    }
}

