/*
 * Decompiled with CFR 0.152.
 */
package kr.co.bootpay.store.service.order_subscriptions.request;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import kr.co.bootpay.store.BootpayStoreObject;
import kr.co.bootpay.store.model.request.orderSubscription.request.ing.OrderSubscriptionPauseParams;
import kr.co.bootpay.store.model.request.orderSubscription.request.ing.OrderSubscriptionResumeParams;
import kr.co.bootpay.store.model.request.orderSubscription.request.ing.OrderSubscriptionTerminationParams;
import kr.co.bootpay.store.model.response.BootpayStoreResponse;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class SOrderSubscriptionRequestIngService {
    public static BootpayStoreResponse pause(BootpayStoreObject bootpay, OrderSubscriptionPauseParams params) throws Exception {
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        HttpPost post = bootpay.httpPost("order_subscriptions/requests/ing/pause", new StringEntity(gson.toJson((Object)params), "UTF-8"));
        HttpResponse response = client.execute((HttpUriRequest)post);
        return bootpay.responseToJsonObject(response);
    }

    public static BootpayStoreResponse resume(BootpayStoreObject bootpay, OrderSubscriptionResumeParams params) throws Exception {
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        HttpPut put = bootpay.httpPut("order_subscriptions/requests/ing/resume", new StringEntity(gson.toJson((Object)params), "UTF-8"));
        HttpResponse response = client.execute((HttpUriRequest)put);
        return bootpay.responseToJsonObject(response);
    }

    public static BootpayStoreResponse calculateTerminationFee(BootpayStoreObject bootpay, String orderSubscriptionId, String orderNumber) throws Exception {
        boolean hasOrderNumber;
        if (bootpay == null || bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new IllegalArgumentException("Bootpay \ud1a0\ud070\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        boolean hasOrderSubscriptionId = orderSubscriptionId != null && !orderSubscriptionId.trim().isEmpty();
        boolean bl = hasOrderNumber = orderNumber != null && !orderNumber.trim().isEmpty();
        if (!hasOrderSubscriptionId && !hasOrderNumber) {
            throw new IllegalArgumentException("orderSubscriptionId \ub610\ub294 orderNumber \uc911 \ud558\ub098\ub294 \ud544\uc218\uc785\ub2c8\ub2e4.");
        }
        StringBuilder url = new StringBuilder("order_subscriptions/requests/ing/calculate_termination_fee?");
        if (hasOrderSubscriptionId) {
            url.append("order_subscription_id=").append(URLEncoder.encode(orderSubscriptionId, StandardCharsets.UTF_8));
        } else {
            url.append("order_number=").append(URLEncoder.encode(orderNumber, StandardCharsets.UTF_8));
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = bootpay.httpGet(url.toString());
        HttpResponse response = client.execute((HttpUriRequest)get);
        return bootpay.responseToJsonObject(response);
    }

    public static BootpayStoreResponse calculateTerminationFeeByOrderNumber(BootpayStoreObject bootpay, String orderNumber) throws Exception {
        return SOrderSubscriptionRequestIngService.calculateTerminationFee(bootpay, null, orderNumber);
    }

    public static BootpayStoreResponse calculateTerminationFeeBySubscriptionId(BootpayStoreObject bootpay, String orderSubscriptionId) throws Exception {
        return SOrderSubscriptionRequestIngService.calculateTerminationFee(bootpay, orderSubscriptionId, null);
    }

    public static BootpayStoreResponse termination(BootpayStoreObject bootpay, OrderSubscriptionTerminationParams params) throws Exception {
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        HttpPost post = bootpay.httpPost("order_subscriptions/requests/ing/termination", new StringEntity(gson.toJson((Object)params), "UTF-8"));
        HttpResponse response = client.execute((HttpUriRequest)post);
        return bootpay.responseToJsonObject(response);
    }
}

