/*
 * Decompiled with CFR 0.152.
 */
package kr.co.bootpay.store.service.orders;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.util.ArrayList;
import kr.co.bootpay.store.BootpayStoreObject;
import kr.co.bootpay.store.model.request.order.cancel.OrderCancelActionParams;
import kr.co.bootpay.store.model.request.order.cancel.OrderCancelListParams;
import kr.co.bootpay.store.model.request.order.cancel.OrderCancelParams;
import kr.co.bootpay.store.model.response.BootpayStoreResponse;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;

public class SOrderCancelService {
    public static BootpayStoreResponse list(BootpayStoreObject bootpay, OrderCancelListParams params) throws Exception {
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        String url = "order/cancel";
        if (params != null) {
            ArrayList<NameValuePair> nameValuePairList = new ArrayList<NameValuePair>();
            if (params.orderId != null) {
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("order_id", params.orderId));
            }
            if (params.orderNumber != null) {
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("order_number", params.orderNumber));
            }
            HttpGet get = bootpay.httpGet(url, nameValuePairList);
            HttpResponse response = client.execute((HttpUriRequest)get);
            return bootpay.responseToJsonObject(response);
        }
        HttpGet get = bootpay.httpGet(url);
        HttpResponse response = client.execute((HttpUriRequest)get);
        return bootpay.responseToJsonObject(response);
    }

    public static BootpayStoreResponse request(BootpayStoreObject bootpay, OrderCancelParams orderCancelParams) throws Exception {
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        HttpPost post = bootpay.httpPost("order/cancel", new StringEntity(gson.toJson((Object)orderCancelParams), "UTF-8"));
        HttpResponse response = client.execute((HttpUriRequest)post);
        return bootpay.responseToJsonObject(response);
    }

    public static BootpayStoreResponse withdraw(BootpayStoreObject bootpay, String orderCancelRequestHistoryId) throws Exception {
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        HttpPut put = bootpay.httpPut("order/cancel/" + orderCancelRequestHistoryId + "/withdraw", new StringEntity(gson.toJson((Object)""), "UTF-8"));
        HttpResponse response = client.execute((HttpUriRequest)put);
        String str = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8");
        System.out.println(str);
        return bootpay.responseToJsonObject(response);
    }

    public static BootpayStoreResponse approve(BootpayStoreObject bootpay, OrderCancelActionParams params) throws Exception {
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        HttpPut put = bootpay.httpPut("order/cancel/" + params.orderCancelRequestHistoryId + "/approve", new StringEntity(gson.toJson((Object)params), "UTF-8"));
        HttpResponse response = client.execute((HttpUriRequest)put);
        return bootpay.responseToJsonObject(response);
    }

    public static BootpayStoreResponse reject(BootpayStoreObject bootpay, OrderCancelActionParams params) throws Exception {
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        HttpPut put = bootpay.httpPut("order/cancel/" + params.orderCancelRequestHistoryId + "/reject", new StringEntity(gson.toJson((Object)params), "UTF-8"));
        HttpResponse response = client.execute((HttpUriRequest)put);
        return bootpay.responseToJsonObject(response);
    }
}

