/*
 * Decompiled with CFR 0.152.
 */
package kr.co.bootpay.store.service.orders;

import java.util.ArrayList;
import java.util.stream.Collectors;
import kr.co.bootpay.store.BootpayStoreObject;
import kr.co.bootpay.store.model.request.order.OrderListParams;
import kr.co.bootpay.store.model.response.BootpayStoreResponse;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;

public class SOrderService {
    public static BootpayStoreResponse list(BootpayStoreObject bootpay, OrderListParams params) throws Exception {
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        String url = "orders";
        if (params != null) {
            String joined;
            ArrayList<NameValuePair> nameValuePairList = new ArrayList<NameValuePair>();
            if (params.keyword != null) {
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("keyword", params.keyword));
            }
            if (params.csType != null) {
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("cs_type", params.csType));
            }
            if (params.cssAt != null) {
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("css_at", params.cssAt));
            }
            if (params.cseAt != null) {
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("cse_at", params.cseAt));
            }
            if (params.page != null) {
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("page", params.page.toString()));
            }
            if (params.limit != null) {
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("limit", params.limit.toString()));
            }
            if (params.userId != null) {
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("user_id", params.userId));
            }
            if (params.userGroupId != null) {
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("user_group_id", params.userGroupId));
            }
            if (params.subscriptionBillingType != null) {
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("subscription_billing_type", params.subscriptionBillingType.toString()));
            }
            if (params.status != null && !params.status.isEmpty()) {
                joined = params.status.stream().map(String::valueOf).collect(Collectors.joining(","));
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("status", joined));
            }
            if (params.paymentStatus != null && !params.paymentStatus.isEmpty()) {
                joined = params.paymentStatus.stream().map(String::valueOf).collect(Collectors.joining(","));
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("payment_status", joined));
            }
            if (params.orderSubscriptionIds != null && !params.orderSubscriptionIds.isEmpty()) {
                joined = params.orderSubscriptionIds.stream().map(String::valueOf).collect(Collectors.joining(","));
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("order_subscription_ids", joined));
            }
            HttpGet get = bootpay.httpGet(url, nameValuePairList);
            HttpResponse response = client.execute((HttpUriRequest)get);
            return bootpay.responseToJsonObject(response);
        }
        HttpGet get = bootpay.httpGet(url);
        HttpResponse response = client.execute((HttpUriRequest)get);
        return bootpay.responseToJsonObject(response);
    }

    public static BootpayStoreResponse detail(BootpayStoreObject bootpay, String orderId) throws Exception {
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = bootpay.httpGet("orders/" + orderId);
        HttpResponse response = client.execute((HttpUriRequest)get);
        return bootpay.responseToJsonObject(response);
    }

    public static BootpayStoreResponse month(BootpayStoreObject bootpay, String userGroupId, String searchDate) throws Exception {
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        if (userGroupId == null || userGroupId.isEmpty()) {
            throw new Exception("user_group_id \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        if (searchDate == null || searchDate.isEmpty()) {
            throw new Exception("search_date \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        ArrayList<NameValuePair> nameValuePairList = new ArrayList<NameValuePair>();
        nameValuePairList.add((NameValuePair)new BasicNameValuePair("user_group_id", userGroupId));
        nameValuePairList.add((NameValuePair)new BasicNameValuePair("search_date", searchDate));
        HttpGet get = bootpay.httpGet("orders/month", nameValuePairList);
        HttpResponse response = client.execute((HttpUriRequest)get);
        return bootpay.responseToJsonObject(response);
    }
}

