/*
 * Decompiled with CFR 0.152.
 */
package kr.co.bootpay.store.service.products;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kr.co.bootpay.store.BootpayStoreObject;
import kr.co.bootpay.store.model.pojo.SProduct;
import kr.co.bootpay.store.model.request.product.ProductListParams;
import kr.co.bootpay.store.model.request.product.ProductStatusParams;
import kr.co.bootpay.store.model.response.BootpayStoreResponse;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;

public class SProductService {
    public static BootpayStoreResponse create(BootpayStoreObject bootpay, SProduct product, List<URL> imagePaths) throws Exception {
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        ArrayList<File> fileList = new ArrayList<File>();
        for (URL imageUrl : imagePaths) {
            File tempFile = new File(imageUrl.toURI());
            if (!tempFile.exists()) {
                throw new Exception("\ud30c\uc77c \uacbd\ub85c\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4: " + tempFile.getAbsolutePath());
            }
            fileList.add(tempFile);
        }
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        String jsonProduct = gson.toJson((Object)product);
        HashMap params = (HashMap)gson.fromJson(jsonProduct, new TypeToken<HashMap<String, String>>(){}.getType());
        HttpPost post = bootpay.httpPostMultipart("products", fileList, params);
        HttpResponse response = client.execute((HttpUriRequest)post);
        return bootpay.responseToJsonObject(response);
    }

    public static BootpayStoreResponse update(BootpayStoreObject bootpay, SProduct product) throws Exception {
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        HttpPut put = bootpay.httpPut("products/" + product.productId, new StringEntity(gson.toJson((Object)product), "UTF-8"));
        HttpResponse response = client.execute((HttpUriRequest)put);
        return bootpay.responseToJsonObject(response);
    }

    public static BootpayStoreResponse list(BootpayStoreObject bootpay, ProductListParams params) throws Exception {
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        String url = "products";
        if (params != null) {
            ArrayList<NameValuePair> nameValuePairList = new ArrayList<NameValuePair>();
            if (params.type != null) {
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("type", params.type.toString()));
            }
            if (params.periodType != null) {
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("period_type", params.periodType));
            }
            if (params.sAt != null) {
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("s_at", params.sAt));
            }
            if (params.eAt != null) {
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("e_at", params.eAt));
            }
            if (params.categoryCode != null) {
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("category_code", params.categoryCode));
            }
            if (params.keyword != null) {
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("keyword", params.keyword));
            }
            if (params.page != null) {
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("page", params.page.toString()));
            }
            if (params.limit != null) {
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("limit", params.limit.toString()));
            }
            HttpGet get = bootpay.httpGet(url, nameValuePairList);
            HttpResponse response = client.execute((HttpUriRequest)get);
            return bootpay.responseToJsonObject(response);
        }
        HttpGet get = bootpay.httpGet(url);
        HttpResponse response = client.execute((HttpUriRequest)get);
        return bootpay.responseToJsonObject(response);
    }

    public static BootpayStoreResponse detail(BootpayStoreObject bootpay, String productId) throws Exception {
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = bootpay.httpGet("products/" + productId);
        HttpResponse response = client.execute((HttpUriRequest)get);
        return bootpay.responseToJsonObject(response);
    }

    public static BootpayStoreResponse status(BootpayStoreObject bootpay, ProductStatusParams params) throws Exception {
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        if (params == null || params.productId == null || params.productId.isEmpty()) {
            throw new Exception("params\uc5d0 product_id \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        HttpPut put = bootpay.httpPut("products/" + params.productId + "/status", new StringEntity(gson.toJson((Object)params), "UTF-8"));
        HttpResponse response = client.execute((HttpUriRequest)put);
        return bootpay.responseToJsonObject(response);
    }

    public static BootpayStoreResponse delete(BootpayStoreObject bootpay, String productId) throws Exception {
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpDelete delete = bootpay.httpDelete("products/" + productId);
        HttpResponse response = client.execute((HttpUriRequest)delete);
        return bootpay.responseToJsonObject(response);
    }
}

