/*
 * Decompiled with CFR 0.152.
 */
package kr.co.bootpay.store.service.user_groups;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import kr.co.bootpay.store.BootpayStoreObject;
import kr.co.bootpay.store.model.pojo.SUserGroup;
import kr.co.bootpay.store.model.request.userGroup.UserGroupAggregateTransactionParams;
import kr.co.bootpay.store.model.request.userGroup.UserGroupLimitParams;
import kr.co.bootpay.store.model.request.userGroup.UserGroupListParams;
import kr.co.bootpay.store.model.response.BootpayStoreResponse;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;

public class SUserGroupService {
    public static BootpayStoreResponse create(BootpayStoreObject bootpay, SUserGroup userGroup) throws Exception {
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        HttpPost post = bootpay.httpPost("user-groups", new StringEntity(gson.toJson((Object)userGroup), "UTF-8"));
        HttpResponse response = client.execute((HttpUriRequest)post);
        return bootpay.responseToJsonObject(response);
    }

    public static BootpayStoreResponse list(BootpayStoreObject bootpay, UserGroupListParams params) throws Exception {
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        String url = "user-groups";
        if (params != null) {
            ArrayList<NameValuePair> nameValuePairList = new ArrayList<NameValuePair>();
            if (params.corporateType != null) {
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("corporate_type", params.corporateType.toString()));
            }
            if (params.keyword != null) {
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("keyword", params.keyword));
            }
            if (params.page != null) {
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("page", params.page.toString()));
            }
            if (params.limit != null) {
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("limit", params.limit.toString()));
            }
            HttpGet get = bootpay.httpGet(url, nameValuePairList);
            HttpResponse response = client.execute((HttpUriRequest)get);
            return bootpay.responseToJsonObject(response);
        }
        HttpGet get = bootpay.httpGet(url);
        HttpResponse response = client.execute((HttpUriRequest)get);
        return bootpay.responseToJsonObject(response);
    }

    public static BootpayStoreResponse detail(BootpayStoreObject bootpay, String userGroupId) throws Exception {
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = bootpay.httpGet("user-groups/" + userGroupId);
        HttpResponse response = client.execute((HttpUriRequest)get);
        return bootpay.responseToJsonObject(response);
    }

    public static BootpayStoreResponse update(BootpayStoreObject bootpay, SUserGroup userGroup) throws Exception {
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        HttpPut put = bootpay.httpPut("user-groups/" + userGroup.userGroupId, new StringEntity(gson.toJson((Object)userGroup), "UTF-8"));
        HttpResponse response = client.execute((HttpUriRequest)put);
        return bootpay.responseToJsonObject(response);
    }

    public static BootpayStoreResponse userCreate(BootpayStoreObject bootpay, String userGroupId, String userId) throws Exception {
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("user_id", userId);
        HttpPost post = bootpay.httpPost("user-groups/" + userGroupId + "/add_user", new StringEntity(gson.toJson(params), "UTF-8"));
        HttpResponse response = client.execute((HttpUriRequest)post);
        return bootpay.responseToJsonObject(response);
    }

    public static BootpayStoreResponse userDelete(BootpayStoreObject bootpay, String userGroupId, String userId) throws Exception {
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpDelete delete = bootpay.httpDelete("user-groups/" + userGroupId + "/remove_user?user_id=" + userId);
        HttpResponse response = client.execute((HttpUriRequest)delete);
        return bootpay.responseToJsonObject(response);
    }

    public static BootpayStoreResponse limit(BootpayStoreObject bootpay, UserGroupLimitParams params) throws Exception {
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        if (params == null) {
            throw new Exception("params \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4");
        }
        if (params.userGroupId == null || params.userGroupId.isEmpty()) {
            throw new Exception("userGroupId \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4");
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        HttpPut put = bootpay.httpPut("user-groups/" + params.userGroupId + "/limit", new StringEntity(gson.toJson((Object)params), "UTF-8"));
        HttpResponse response = client.execute((HttpUriRequest)put);
        return bootpay.responseToJsonObject(response);
    }

    public static BootpayStoreResponse aggregateTransaction(BootpayStoreObject bootpay, UserGroupAggregateTransactionParams params) throws Exception {
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        if (params == null) {
            throw new Exception("params \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4");
        }
        if (params.userGroupId == null || params.userGroupId.isEmpty()) {
            throw new Exception("userGroupId \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4");
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        HttpPut put = bootpay.httpPut("user-groups/" + params.userGroupId + "/aggregate-transaction", new StringEntity(gson.toJson((Object)params), "UTF-8"));
        HttpResponse response = client.execute((HttpUriRequest)put);
        return bootpay.responseToJsonObject(response);
    }
}

