/*
 * Decompiled with CFR 0.152.
 */
package kr.co.bootpay.store.service.users;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import kr.co.bootpay.store.BootpayStoreObject;
import kr.co.bootpay.store.model.pojo.SUser;
import kr.co.bootpay.store.model.request.user.UserListParams;
import kr.co.bootpay.store.model.response.BootpayStoreResponse;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;

public class SUserService {
    public static BootpayStoreResponse list(BootpayStoreObject bootpay, UserListParams params) throws Exception {
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        String url = "users";
        if (params != null) {
            ArrayList<NameValuePair> nameValuePairList = new ArrayList<NameValuePair>();
            if (params.page != null) {
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("page", params.page.toString()));
            }
            if (params.limit != null) {
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("limit", params.limit.toString()));
            }
            if (params.keyword != null) {
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("keyword", params.keyword));
            }
            if (params.memberType != null) {
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("member_type", params.memberType.toString()));
            }
            if (params.type != null) {
                nameValuePairList.add((NameValuePair)new BasicNameValuePair("type", params.type));
            }
            HttpGet get = bootpay.httpGet(url, nameValuePairList);
            HttpResponse response = client.execute((HttpUriRequest)get);
            return bootpay.responseToJsonObject(response);
        }
        HttpGet get = bootpay.httpGet(url);
        HttpResponse response = client.execute((HttpUriRequest)get);
        return bootpay.responseToJsonObject(response);
    }

    public static BootpayStoreResponse update(BootpayStoreObject bootpay, SUser user) throws Exception {
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        HttpPut put = bootpay.httpPut("users/" + user.userId, new StringEntity(gson.toJson((Object)user), "UTF-8"));
        HttpResponse response = client.execute((HttpUriRequest)put);
        return bootpay.responseToJsonObject(response);
    }

    public static BootpayStoreResponse detail(BootpayStoreObject bootpay, String userId) throws Exception {
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = bootpay.httpGet("users/" + userId);
        HttpResponse response = client.execute((HttpUriRequest)get);
        return bootpay.responseToJsonObject(response);
    }

    public static BootpayStoreResponse destroy(BootpayStoreObject bootpay, String userId) throws Exception {
        if (bootpay.getToken() == null || bootpay.getToken().isEmpty()) {
            throw new Exception("token \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpDelete delete = bootpay.httpDelete("users/" + userId);
        HttpResponse response = client.execute((HttpUriRequest)delete);
        return bootpay.responseToJsonObject(response);
    }
}

