/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.content;

import christophedelory.content.Content;
import christophedelory.content.ContentMetadataProvider;
import java.util.ServiceLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ContentMetadataCenter {
    private static ContentMetadataCenter _instance = null;
    private final ServiceLoader<ContentMetadataProvider> _serviceLoader;
    private final Log _logger = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentMetadataCenter getInstance() {
        Class<ContentMetadataCenter> clazz = ContentMetadataCenter.class;
        synchronized (ContentMetadataCenter.class) {
            if (_instance == null) {
                _instance = new ContentMetadataCenter();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    private ContentMetadataCenter() {
        this._serviceLoader = ServiceLoader.load(ContentMetadataProvider.class);
    }

    public void reloadProviders() {
        this._serviceLoader.reload();
    }

    public boolean fillMetadata(Content content) {
        boolean ret = false;
        for (ContentMetadataProvider service : this._serviceLoader) {
            try {
                service.fillMetadata(content, this._logger);
                ret = true;
                break;
            }
            catch (Throwable e) {
                if (this._logger.isTraceEnabled()) {
                    this._logger.trace((Object)("Metadata provider " + service + " cannot handle content <" + content + ">"), e);
                    continue;
                }
                if (!this._logger.isDebugEnabled()) continue;
                this._logger.debug((Object)("Metadata provider " + service + " cannot handle content <" + content + ">: " + e));
            }
        }
        return ret;
    }
}

