/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.content;

import christophedelory.content.Content;
import christophedelory.content.ContentMetadataProvider;
import com.sun.jna.ptr.PointerByReference;
import net.sf.ffmpeg_java.AVCodecLibrary;
import net.sf.ffmpeg_java.AVFormatLibrary;
import org.apache.commons.logging.Log;

public class FFMPEGMetadataProvider
implements ContentMetadataProvider {
    private transient AVFormatLibrary _avFormatLibrary = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillMetadata(Content content, Log logger) throws Exception {
        String filename = content.toString();
        FFMPEGMetadataProvider fFMPEGMetadataProvider = this;
        synchronized (fFMPEGMetadataProvider) {
            if (this._avFormatLibrary == null) {
                AVFormatLibrary lib = AVFormatLibrary.INSTANCE;
                lib.av_register_all();
                this._avFormatLibrary = lib;
            }
        }
        PointerByReference ppFormatCtx = new PointerByReference();
        if (this._avFormatLibrary.av_open_input_file(ppFormatCtx, filename, null, 0, null) != 0) {
            throw new RuntimeException("Couldn't open " + filename);
        }
        AVFormatLibrary.AVFormatContext formatCtx = new AVFormatLibrary.AVFormatContext(ppFormatCtx.getValue());
        if (this._avFormatLibrary.av_find_stream_info(formatCtx) < 0) {
            throw new RuntimeException("Couldn't find stream information in " + filename);
        }
        if (formatCtx.bit_rate > 0) {
            content.setDuration((formatCtx.duration + 999L) / 1000L);
        } else {
            content.setDuration(0L);
        }
        content.setWidth(0);
        content.setHeight(0);
        for (int i = 0; i < formatCtx.nb_streams; ++i) {
            AVFormatLibrary.AVStream stream = new AVFormatLibrary.AVStream(formatCtx.getStreams()[i]);
            AVCodecLibrary.AVCodecContext codecCtx = new AVCodecLibrary.AVCodecContext(stream.codec);
            if (codecCtx.codec_type != 0) continue;
            content.setWidth(codecCtx.width);
            content.setHeight(codecCtx.height);
            break;
        }
        this._avFormatLibrary.av_close_input_file(formatCtx);
    }
}

