/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.content.type;

import christophedelory.player.PlayerSupport;
import java.io.File;
import java.util.Locale;
import javax.swing.filechooser.FileFilter;

public class ContentType
extends FileFilter
implements Cloneable {
    private final String[] _extensions;
    private final String[] _mimeTypes;
    private final PlayerSupport[] _playerSupports;
    private String _description;

    public ContentType(String[] extensions, String[] mimeTypes, PlayerSupport[] playerSupports, String description) {
        int i;
        if (extensions.length <= 0) {
            throw new IllegalArgumentException("Empty extension array");
        }
        if (mimeTypes.length <= 0) {
            throw new IllegalArgumentException("Empty MIME type array");
        }
        this._extensions = new String[extensions.length];
        for (i = 0; i < extensions.length; ++i) {
            this._extensions[i] = extensions[i].toLowerCase(Locale.ENGLISH);
        }
        this._mimeTypes = new String[mimeTypes.length];
        for (i = 0; i < mimeTypes.length; ++i) {
            this._mimeTypes[i] = mimeTypes[i].toLowerCase(Locale.ENGLISH);
        }
        this._description = description;
        this._playerSupports = playerSupports == null ? new PlayerSupport[]{} : (PlayerSupport[])playerSupports.clone();
    }

    public String[] getExtensions() {
        return (String[])this._extensions.clone();
    }

    public String[] getMimeTypes() {
        return (String[])this._mimeTypes.clone();
    }

    public PlayerSupport[] getPlayerSupports() {
        return (PlayerSupport[])this._playerSupports.clone();
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public boolean matchExtension(String pattern) {
        String p = pattern.toLowerCase(Locale.ENGLISH);
        boolean ret = false;
        for (String extension : this._extensions) {
            ret = ret || p.endsWith(extension);
        }
        return ret;
    }

    @Override
    public boolean accept(File f) {
        return f.isDirectory() ? true : this.matchExtension(f.getName());
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

