/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.content.type;

import christophedelory.content.type.ContentType;
import christophedelory.content.type.ContentTypeProvider;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.ServiceLoader;

public final class ContentTypeFactory {
    private static ContentTypeFactory _instance = null;
    private final ServiceLoader<ContentTypeProvider> _serviceLoader = ServiceLoader.load(ContentTypeProvider.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentTypeFactory getInstance() {
        Class<ContentTypeFactory> clazz = ContentTypeFactory.class;
        synchronized (ContentTypeFactory.class) {
            if (_instance == null) {
                _instance = new ContentTypeFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    private ContentTypeFactory() {
    }

    public void reloadProviders() {
        this._serviceLoader.reload();
    }

    public ContentType getContentType(String contentName) {
        URI uri;
        String name = contentName.trim().replace('\\', '/');
        try {
            uri = new URI(name);
        }
        catch (URISyntaxException e) {
            uri = new File(name).toURI();
        }
        return this.getContentType(uri);
    }

    public ContentType getContentType(URI uri) {
        ContentType ret;
        block1: {
            ContentTypeProvider service;
            ret = null;
            String path = uri.getPath();
            if (path == null) break block1;
            Iterator<ContentTypeProvider> iterator = this._serviceLoader.iterator();
            while (iterator.hasNext() && (ret = (service = iterator.next()).getContentType(path)) == null) {
            }
        }
        return ret;
    }
}

